/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.util;

public class TimerQueue<E extends Node> {
    public static final int DEFAULT_INITIAL_CAPACITY = 11;
    private Node[] _heap;
    protected int _size;

    public TimerQueue() {
        this(11);
    }

    public TimerQueue(int initialCapacity) {
        this._heap = new Node[initialCapacity];
    }

    public int getSize() {
        return this._size;
    }

    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        if (((Node)e)._index > 0) {
            this.remove(e);
        }
        if (++this._size == this._heap.length) {
            Node[] newHeap = new Node[this._heap.length * 2];
            System.arraycopy(this._heap, 0, newHeap, 0, this._heap.length);
            this._heap = newHeap;
        }
        if (this._size == 1) {
            this.set(this._size, (Node)e);
        } else {
            this.siftUp(this._size, (Node)e);
        }
        assert (this.invariant());
        return true;
    }

    public void offer(E e, long value) {
        if (((Node)e)._index > 0) {
            if (this._heap[((Node)e)._index] != e) {
                throw new IllegalArgumentException("invalid node: " + e);
            }
            long oldValue = ((Node)e)._value;
            ((Node)e)._value = value;
            if (value > oldValue) {
                this.siftDown(((Node)e)._index, (Node)e);
            } else {
                this.siftUp(((Node)e)._index, (Node)e);
            }
        } else {
            ((Node)e)._value = value;
            this.offer(e);
        }
        assert (this.invariant());
    }

    public E peek() {
        return (E)(this._size > 0 ? this._heap[1] : null);
    }

    public E poll() {
        if (this._size == 0) {
            return null;
        }
        Node node = this._heap[1];
        node._index = -1;
        Node last = this._heap[this._size];
        this._heap[this._size--] = null;
        if (this._size != 0) {
            this.siftDown(1, last);
        }
        assert (this.invariant());
        return (E)node;
    }

    public void remove(E e) {
        if (((Node)e)._index != -1) {
            if (this._heap[((Node)e)._index] != e) {
                throw new IllegalArgumentException("invalid node: " + e);
            }
            this.removeAt(((Node)e)._index);
        }
        ((Node)e)._index = -1;
        assert (this.invariant());
    }

    private void removeAt(int i) {
        assert (i > 0 && i <= this._size);
        if (i == this._size) {
            this._heap[this._size--] = null;
        } else {
            Node node = this._heap[this._size];
            this._heap[this._size--] = null;
            this.siftDown(i, node);
            if (this._heap[i] == node) {
                this.siftUp(i, node);
            }
        }
    }

    private void siftUp(int i, Node node) {
        assert (i > 0 && i <= this._size);
        while (i > 1) {
            int j = i >>> 1;
            Node parent = this._heap[j];
            if (parent._value <= node._value) break;
            this.set(i, parent);
            i = j;
        }
        this.set(i, node);
    }

    private void siftDown(int i, Node node) {
        int j;
        assert (i > 0 && i <= this._size);
        while ((j = i << 1) <= this._size) {
            Node child = this._heap[j];
            if (j < this._size && child._value > this._heap[j + 1]._value) {
                child = this._heap[++j];
            }
            if (node._value <= child._value) break;
            this.set(i, child);
            i = j;
        }
        this.set(i, node);
    }

    private final void set(int k, Node node) {
        this._heap[k] = node;
        node._index = k;
    }

    protected Node[] toArray() {
        Node[] nodes = new Node[this._size];
        System.arraycopy(this._heap, 1, nodes, 0, this._size);
        return nodes;
    }

    public boolean invariant() {
        for (int i = this._size; i > 1; --i) {
            Node node = this._heap[i];
            Node parent = this._heap[i / 2];
            if (parent._value <= node._value) continue;
            return false;
        }
        return true;
    }

    public static class Node {
        int _index = -1;
        long _value;

        public Node() {
            this(Long.MAX_VALUE);
        }

        public Node(long value) {
            this._value = value;
        }

        public long getValue() {
            return this._value;
        }
    }
}

