/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.util;

import java.text.ParseException;
import java.util.BitSet;

public class StringScanner {
    private int _position;
    private int _end;
    private int _mark;
    private String _string;

    public StringScanner(String s) {
        this._string = s;
        this._end = this._string.length();
    }

    public boolean eof() {
        return this._position >= this._end;
    }

    public int position() {
        return this._position;
    }

    public void position(int i) {
        if (i < 0 || i >= this._end) {
            throw new IndexOutOfBoundsException();
        }
        this._position = i;
    }

    public StringScanner end() {
        this._position = this._end;
        return this;
    }

    public void reset() {
        this._position = this._mark;
    }

    public StringScanner skipWhitespace() {
        block3: while (this._position < this._end) {
            switch (this._string.charAt(this._position)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    ++this._position;
                    continue block3;
                }
            }
            return this;
        }
        return this;
    }

    public StringScanner skipBackWhitespace() {
        block3: while (this._position > 0) {
            switch (this._string.charAt(this._position - 1)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    --this._position;
                    continue block3;
                }
            }
            return this;
        }
        return this;
    }

    public StringScanner skipToChar(char c) {
        this._position = this._string.indexOf(c, this._position);
        if (this._position < 0) {
            this._position = this._end;
        }
        return this;
    }

    public StringScanner skipToOneOf(BitSet bs) {
        while (this._position < this._end && !bs.get(this._string.charAt(this._position))) {
            ++this._position;
        }
        return this;
    }

    public StringScanner skipChars(BitSet bs) {
        while (this._position < this._end && bs.get(this._string.charAt(this._position))) {
            ++this._position;
        }
        return this;
    }

    public StringScanner skipChar() {
        ++this._position;
        return this;
    }

    public StringScanner readSWSChar(char c) throws ParseException {
        this.skipWhitespace();
        this.readChar(c);
        this.skipWhitespace();
        return this;
    }

    public StringScanner readChar(char c) throws ParseException {
        if (this.eof()) {
            throw new ParseException("expected " + c, this._position);
        }
        if (this._string.charAt(this._position) != c) {
            throw new ParseException(this._string.charAt(this._position) + " instead of " + c, this._position);
        }
        ++this._position;
        return this;
    }

    public StringScanner readString(String s) throws ParseException {
        for (int i = 0; i < s.length(); ++i) {
            if (this.eof() || this._string.charAt(this._position) != s.charAt(i)) {
                throw new ParseException("expected " + s, this._position);
            }
            ++this._position;
        }
        return this;
    }

    public StringScanner mark() {
        this._mark = this._position;
        return this;
    }

    public String sliceFromMark() {
        return this._string.substring(this._mark, this._position);
    }

    public char charAt(int i) {
        return this._string.charAt(i);
    }

    public String readToSpace() {
        int m = this._position;
        while (this._position < this._end && !Character.isWhitespace(this._string.charAt(this._position))) {
            ++this._position;
        }
        return this._string.substring(m, this._position);
    }

    public char peekChar() {
        return this._string.charAt(this._position);
    }

    public String readTo(BitSet bs) {
        int m = this._position;
        while (this._position < this._end && !bs.get(this._string.charAt(this._position))) {
            ++this._position;
        }
        return this._string.substring(m, this._position);
    }

    public int readInt(int base) {
        int value = 0;
        while (!this.eof()) {
            char c = this._string.charAt(this._position);
            int digit = c - 48;
            if (!(digit >= 0 && digit < base && digit < 10 || (digit = 10 + c - 65) >= 10 && digit < base)) {
                digit = 10 + c - 97;
            }
            if (digit < 0 || digit >= base) {
                return value;
            }
            value = value * base + digit;
            ++this._position;
        }
        return value;
    }

    public int readInt() {
        return this.readInt(10);
    }

    public String readQuoted() throws ParseException {
        int m = this._position;
        this.readChar('\"');
        while (this._position < this._end) {
            if (this._string.charAt(this._position) == '\"' && this._string.charAt(this._position - 1) != '\\') {
                return this._string.substring(m, ++this._position);
            }
            ++this._position;
        }
        throw new ParseException("cannot find closing quote", this._position);
    }

    public String readFromMark() {
        return this._string.substring(this._mark, this._position);
    }
}

