/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.cipango.sip.security.Authorization;
import org.cipango.util.HexString;

public class DigestAuthenticator {
    private MessageDigest md;
    public static final String AUTH = "auth";

    public DigestAuthenticator() {
        try {
            this.md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public String calculateResponse(Authorization authorization, String password, String method) {
        String user = authorization.getUsername();
        String realm = authorization.getRealm();
        String uri = authorization.getUri();
        String qop = authorization.getQop();
        String nc = authorization.getNonceCount();
        String nonce = authorization.getNonce();
        String cnonce = authorization.getCNonce();
        String a1 = user + ":" + realm + ":" + password;
        String a2 = method + ":" + uri;
        if (qop != null) {
            if (!qop.equals(AUTH)) {
                throw new IllegalArgumentException("Invalid qop: " + qop);
            }
            if (nc == null || cnonce == null) {
                throw new IllegalArgumentException("Invalid Authorization header: " + nc + "/" + cnonce);
            }
            return this.KD(this.H(a1), nonce + ":" + nc + ":" + cnonce + ":" + qop + ":" + this.H(a2));
        }
        return this.KD(this.H(a1), nonce + ":" + this.H(a2));
    }

    private String KD(String secret, String data) {
        return this.H(secret + ":" + data);
    }

    private String H(String s) {
        this.md.reset();
        try {
            this.md.update(s.getBytes("ISO-8859-1"));
            return HexString.toHexString(this.md.digest());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

