/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sipapp.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.sip.SipServletRequest;
import org.cipango.sipapp.rules.MatchingRule;
import org.cipango.sipapp.rules.request.DisplayName;
import org.cipango.sipapp.rules.request.Extractor;
import org.cipango.sipapp.rules.request.From;
import org.cipango.sipapp.rules.request.Host;
import org.cipango.sipapp.rules.request.Method;
import org.cipango.sipapp.rules.request.Param;
import org.cipango.sipapp.rules.request.Port;
import org.cipango.sipapp.rules.request.Route;
import org.cipango.sipapp.rules.request.Scheme;
import org.cipango.sipapp.rules.request.Tel;
import org.cipango.sipapp.rules.request.To;
import org.cipango.sipapp.rules.request.Uri;
import org.cipango.sipapp.rules.request.User;

public abstract class RequestRule
implements MatchingRule {
    private String _varName;
    private List<Extractor> _extractors;

    protected RequestRule(String varName) {
        this._varName = varName;
        this._extractors = new ArrayList<Extractor>();
        StringTokenizer st = new StringTokenizer(varName, ".");
        String lastToken = st.nextToken();
        if (!lastToken.equals("request")) {
            throw new IllegalArgumentException("Expression does not start with request: " + varName);
        }
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("from")) {
                this._extractors.add(new From(lastToken));
            } else if (token.equals("uri")) {
                this._extractors.add(new Uri(lastToken));
            } else if (token.equals("method")) {
                this._extractors.add(new Method(lastToken));
            } else if (token.equals("user")) {
                this._extractors.add(new User(lastToken));
            } else if (token.equals("scheme")) {
                this._extractors.add(new Scheme(lastToken));
            } else if (token.equals("host")) {
                this._extractors.add(new Host(lastToken));
            } else if (token.equals("port")) {
                this._extractors.add(new Port(lastToken));
            } else if (token.equals("tel")) {
                this._extractors.add(new Tel(lastToken));
            } else if (token.equals("display-name")) {
                this._extractors.add(new DisplayName(lastToken));
            } else if (token.equals("to")) {
                this._extractors.add(new To(lastToken));
            } else if (token.equals("route")) {
                this._extractors.add(new Route(lastToken));
            } else if (token.equals("param")) {
                if (!st.hasMoreTokens()) {
                    throw new IllegalArgumentException("No param name: " + varName);
                }
                String param = st.nextToken();
                this._extractors.add(new Param(lastToken, param));
                if (st.hasMoreTokens()) {
                    throw new IllegalArgumentException("Invalid var: " + st.nextToken() + " in " + varName);
                }
            } else {
                throw new IllegalArgumentException("Invalid property: " + token + " in " + varName);
            }
            lastToken = token;
        }
    }

    public String getValue(SipServletRequest request) {
        Object o = request;
        for (int i = 0; i < this._extractors.size(); ++i) {
            Extractor e = this._extractors.get(i);
            o = e.extract(o);
            if (o != null) continue;
            return null;
        }
        return o.toString();
    }

    public String getVarName() {
        return this._varName;
    }
}

