/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sipapp.rules;

import javax.servlet.sip.SipServletRequest;
import org.cipango.sipapp.rules.MatchingRule;
import org.cipango.sipapp.rules.RequestRule;

public class ContainsRule
extends RequestRule
implements MatchingRule {
    private String _value;
    private boolean _ignoreCase;

    public ContainsRule(String var, String value, boolean ignoreCase) {
        super(var);
        this._value = value;
        if (ignoreCase) {
            value = value.toLowerCase();
        }
        this._ignoreCase = ignoreCase;
    }

    public boolean matches(SipServletRequest request) {
        String requestValue = this.getValue(request);
        if (requestValue == null) {
            return false;
        }
        if (this._ignoreCase) {
            requestValue = requestValue.toLowerCase();
        }
        return requestValue.indexOf(this._value) != -1;
    }

    public String getExpression() {
        return "(" + this.getVarName() + " contains " + this._value + ")";
    }
}

