/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sipapp;

import java.io.IOException;
import java.net.MalformedURLException;
import org.cipango.servlet.SipServletHandler;
import org.cipango.sipapp.SipAppContext;
import org.cipango.sipapp.StandardDescriptorProcessor;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.DescriptorProcessor;
import org.eclipse.jetty.webapp.WebAppContext;

public class SipXmlConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = Log.getLogger(SipXmlConfiguration.class);

    public void preConfigure(WebAppContext context) throws Exception {
        Resource sipXml;
        if (!(context instanceof SipAppContext)) {
            throw new IllegalArgumentException("!sip context: " + context.getClass());
        }
        SipAppContext sipContext = (SipAppContext)context;
        if (sipContext.isStarted()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot configure sipapp after it is started", new Object[0]);
            }
            return;
        }
        String defaultsSipDescriptor = sipContext.getDefaultsSipDescriptor();
        if (defaultsSipDescriptor != null && defaultsSipDescriptor.length() > 0) {
            Resource dftSipResource = Resource.newSystemResource((String)defaultsSipDescriptor);
            if (dftSipResource == null) {
                dftSipResource = context.newResource(defaultsSipDescriptor);
            }
            sipContext.getSipMetaData().setDefaults(dftSipResource);
        }
        if ((sipXml = this.findSipXml(context)) != null) {
            sipContext.getSipMetaData().setSipXml(sipXml);
        }
        for (String overrideDescriptor : sipContext.getOverrideSipDescriptors()) {
            if (overrideDescriptor == null || overrideDescriptor.length() <= 0) continue;
            Resource orideResource = Resource.newSystemResource((String)overrideDescriptor);
            if (orideResource == null) {
                orideResource = context.newResource(overrideDescriptor);
            }
            sipContext.getSipMetaData().addOverride(orideResource);
        }
    }

    public void configure(WebAppContext context) throws Exception {
        if (!(context instanceof SipAppContext)) {
            throw new IllegalArgumentException("! sip context");
        }
        SipAppContext sipContext = (SipAppContext)context;
        if (sipContext.isStarted() && LOG.isDebugEnabled()) {
            LOG.debug("Cannot configure sipapp after it is started", new Object[0]);
        }
        ((SipAppContext)context).getSipMetaData().addDescriptorProcessor((DescriptorProcessor)new StandardDescriptorProcessor());
    }

    public void deconfigure(WebAppContext context) throws Exception {
        SipServletHandler servletHandler = ((SipAppContext)context).getSipServletHandler();
        servletHandler.setSipServlets(null);
        servletHandler.setSipServletMappings(null);
        context.setEventListeners(null);
    }

    protected Resource findSipXml(WebAppContext context) throws IOException, MalformedURLException {
        Resource webInf = context.getWebInf();
        if (webInf != null && webInf.isDirectory()) {
            Resource sip = webInf.addPath("sip.xml");
            if (sip.exists()) {
                return sip;
            }
            LOG.debug("No WEB-INF/sip.xml in " + context.getWar(), new Object[0]);
        }
        return null;
    }
}

