/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sipapp;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.cipango.servlet.SipServletHolder;
import org.cipango.sipapp.SipAppContext;
import org.cipango.sipapp.SipDescriptor;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.Descriptor;
import org.eclipse.jetty.webapp.DescriptorProcessor;
import org.eclipse.jetty.webapp.DiscoveredAnnotation;
import org.eclipse.jetty.webapp.WebAppContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SipMetaData {
    private static final Logger LOG = Log.getLogger(SipMetaData.class);
    protected SipDescriptor _sipDefaultsRoot;
    protected SipDescriptor _sipXmlRoot;
    protected final List<SipDescriptor> _sipOverrideRoots = new ArrayList<SipDescriptor>();
    protected final List<DiscoveredAnnotation> _annotations = new ArrayList<DiscoveredAnnotation>();
    protected final List<DescriptorProcessor> _descriptorProcessors = new ArrayList<DescriptorProcessor>();
    private String _mainServletName;
    private String _appName;
    private final List<String> _listeners = new ArrayList<String>();

    public void clear() {
        this._sipDefaultsRoot = null;
        this._sipXmlRoot = null;
        this._sipOverrideRoots.clear();
        this._annotations.clear();
        this._descriptorProcessors.clear();
    }

    public void setDefaults(Resource sipDefaults) throws Exception {
        this._sipDefaultsRoot = new SipDescriptor(sipDefaults);
        this._sipDefaultsRoot.parse();
    }

    public void setSipXml(Resource sipXml) throws Exception {
        this._sipXmlRoot = new SipDescriptor(sipXml);
        this._sipXmlRoot.parse();
    }

    public void addOverride(Resource override) throws Exception {
        SipDescriptor sipOverrideRoot = new SipDescriptor(override);
        sipOverrideRoot.setValidating(false);
        sipOverrideRoot.parse();
        this._sipOverrideRoots.add(sipOverrideRoot);
    }

    public void addDiscoveredAnnotations(List<DiscoveredAnnotation> annotations) {
        this._annotations.addAll(annotations);
    }

    public void addDescriptorProcessor(DescriptorProcessor p) {
        this._descriptorProcessors.add(p);
    }

    public void resolve(WebAppContext appContext) throws Exception {
        SipAppContext context = (SipAppContext)appContext;
        for (DescriptorProcessor p : this._descriptorProcessors) {
            p.process((WebAppContext)context, (Descriptor)this.getSipDefault());
            p.process((WebAppContext)context, (Descriptor)this.getSipXml());
            for (SipDescriptor wd : this.getOverrideSips()) {
                p.process((WebAppContext)context, (Descriptor)wd);
            }
        }
        for (DiscoveredAnnotation a : this._annotations) {
            a.apply();
        }
        if (this._mainServletName != null) {
            context.getSipServletHandler().setMainServletName(this._mainServletName);
        }
        int version = 11;
        version = this._appName != null || this.getSipXml() == null ? 11 : this.getSipXml().getVersion();
        context.setSpecVersion(version);
        if (context.getName() == null) {
            if (this._appName == null) {
                context.setName(context.getDefaultName());
            } else {
                context.setName(this._appName);
            }
        }
        this.initListeners(context);
    }

    protected SipServletHolder getServlet(SipAppContext context, String className) {
        if (context.getSipServletHandler().getSipServlets() == null) {
            return null;
        }
        for (SipServletHolder holder : context.getSipServletHandler().getSipServlets()) {
            if (!className.equals(holder.getClassName())) continue;
            return holder;
        }
        return null;
    }

    private void initListeners(SipAppContext context) {
        for (String className : this._listeners) {
            SipServletHolder holder = this.getServlet(context, className);
            boolean found = false;
            if (context.getEventListeners() != null) {
                for (EventListener listener : context.getEventListeners()) {
                    if (!listener.getClass().getName().equals(className)) continue;
                    LOG.debug("Found multiple listener declaration " + className, new Object[0]);
                    if (holder != null) {
                        holder.setServlet((Servlet)listener);
                    }
                    found = true;
                    break;
                }
            }
            if (found) continue;
            try {
                Class listenerClass = context.loadClass(className);
                EventListener listener = this.newListenerInstance(context, listenerClass);
                if (holder != null) {
                    holder.setServlet((Servlet)listener);
                }
                context.addEventListener(listener);
            }
            catch (Exception e) {
                LOG.warn("Could not instantiate listener: " + className, (Throwable)e);
            }
        }
    }

    public EventListener newListenerInstance(WebAppContext context, Class<? extends EventListener> clazz) throws ServletException, InstantiationException, IllegalAccessException {
        try {
            return ((ServletContextHandler.Context)context.getServletContext()).createListener(clazz);
        }
        catch (ServletException se) {
            Throwable cause = se.getRootCause();
            if (cause instanceof InstantiationException) {
                throw (InstantiationException)cause;
            }
            if (cause instanceof IllegalAccessException) {
                throw (IllegalAccessException)cause;
            }
            throw se;
        }
    }

    public boolean isDistributable() {
        boolean distributable = this._sipDefaultsRoot != null && this._sipDefaultsRoot.isDistributable() || this._sipXmlRoot != null && this._sipXmlRoot.isDistributable();
        for (SipDescriptor d : this._sipOverrideRoots) {
            distributable &= d.isDistributable();
        }
        return distributable;
    }

    public SipDescriptor getSipXml() {
        return this._sipXmlRoot;
    }

    public List<SipDescriptor> getOverrideSips() {
        return this._sipOverrideRoots;
    }

    public SipDescriptor getSipDefault() {
        return this._sipDefaultsRoot;
    }

    public String getMainServletName() {
        return this._mainServletName;
    }

    public void setMainServletName(String mainServletName) {
        this._mainServletName = mainServletName;
    }

    public void addListener(String classname) {
        this._listeners.add(classname);
    }

    public List<DescriptorProcessor> getDescriptorProcessors() {
        return this._descriptorProcessors;
    }

    public String getAppName() {
        return this._appName;
    }

    public void setAppName(String appName) {
        this._appName = appName;
    }
}

