/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sipapp;

import java.net.URL;
import javax.servlet.Servlet;
import javax.servlet.sip.SipServlet;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.Descriptor;
import org.eclipse.jetty.webapp.WebDescriptor;
import org.eclipse.jetty.xml.XmlParser;

public class SipDescriptor
extends Descriptor {
    protected static XmlParser _parserSingleton;
    protected int _version;
    protected boolean _distributable;

    public void ensureParser() throws ClassNotFoundException {
        if (_parserSingleton == null) {
            _parserSingleton = this.newParser();
        }
        this._parser = _parserSingleton;
    }

    public XmlParser newParser() throws ClassNotFoundException {
        XmlParser xmlParser = new WebDescriptor(null).newParser();
        URL jsp21xsd = Loader.getResource(Servlet.class, (String)"javax/servlet/resources/jsp_2_1.xsd", (boolean)true);
        this.redirect(xmlParser, "jsp_2_1.xsd", jsp21xsd);
        URL dtd10 = Loader.getResource(SipServlet.class, (String)"javax/servlet/sip/resources/sip-app_1_0.dtd", (boolean)true);
        URL sipapp11xsd = Loader.getResource(SipServlet.class, (String)"javax/servlet/sip/resources/sip-app_1_1.xsd", (boolean)true);
        URL javaee5xsd = Loader.getResource(Servlet.class, (String)"javax/servlet/resources/javaee_5.xsd", (boolean)true);
        this.redirect(xmlParser, "-//Java Community Process//DTD SIP Application 1.0//EN", dtd10);
        this.redirect(xmlParser, "javaee_5.xsd", javaee5xsd);
        this.redirect(xmlParser, "sip-app_1_1.xsd", sipapp11xsd);
        this.redirect(xmlParser, "http://www.jcp.org/xml/ns/sipservlet/sip-app_1_1.xsd", sipapp11xsd);
        return xmlParser;
    }

    public SipDescriptor(Resource xml) {
        super(xml);
    }

    public void parse() throws Exception {
        super.parse();
        this.processVersion();
    }

    public void processVersion() {
        String version = this._root.getAttribute("version", "DTD");
        if ("1.0".equals(version)) {
            this._version = 10;
        } else if ("1.1".equals(version)) {
            this._version = 11;
        } else if ("DTD".equals(version)) {
            String schemaLocation = this._root.getAttribute("schemaLocation");
            this._version = schemaLocation != null && schemaLocation.indexOf("sip-app_1_1.xsd") > 0 ? 11 : 10;
        }
    }

    public void setDistributable(boolean distributable) {
        this._distributable = distributable;
    }

    public boolean isDistributable() {
        return this._distributable;
    }

    public int getVersion() {
        return this._version;
    }
}

