/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sipapp;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.sip.Address;
import javax.servlet.sip.AuthInfo;
import javax.servlet.sip.Parameterable;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.ServletTimer;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipApplicationSessionAttributeListener;
import javax.servlet.sip.SipApplicationSessionListener;
import javax.servlet.sip.SipErrorListener;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletContextEvent;
import javax.servlet.sip.SipServletListener;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipSessionAttributeListener;
import javax.servlet.sip.SipSessionListener;
import javax.servlet.sip.SipSessionsUtil;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.TimerListener;
import javax.servlet.sip.TimerService;
import javax.servlet.sip.URI;
import javax.servlet.sip.ar.SipApplicationRoutingDirective;
import org.cipango.http.servlet.ConvergedSessionManager;
import org.cipango.log.event.Events;
import org.cipango.server.ID;
import org.cipango.server.Server;
import org.cipango.server.SipConnector;
import org.cipango.server.SipHandler;
import org.cipango.server.SipRequest;
import org.cipango.server.session.AppSession;
import org.cipango.server.session.AppSessionIf;
import org.cipango.server.session.CallSession;
import org.cipango.server.session.Session;
import org.cipango.server.session.SessionManager;
import org.cipango.server.session.scope.ScopedAppSession;
import org.cipango.server.session.scope.ScopedTimer;
import org.cipango.servlet.SipDispatcher;
import org.cipango.servlet.SipServletHandler;
import org.cipango.servlet.SipServletHolder;
import org.cipango.sip.NameAddr;
import org.cipango.sip.ParameterableImpl;
import org.cipango.sip.SipURIImpl;
import org.cipango.sip.URIFactory;
import org.cipango.sip.security.AuthInfoImpl;
import org.cipango.sip.security.ConstraintSecurityHandler;
import org.cipango.sipapp.SipMetaData;
import org.cipango.util.ReadOnlySipURI;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.statistic.CounterStatistic;
import org.eclipse.jetty.util.statistic.SampleStatistic;
import org.eclipse.jetty.webapp.WebAppContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SipAppContext
extends WebAppContext
implements SipHandler {
    private static final Logger LOG = Log.getLogger(SipAppContext.class);
    public static final int VERSION_10 = 10;
    public static final int VERSION_11 = 11;
    private static final String SIP_CONFIGURATION_CLASS = "org.cipango.sipapp.SipXmlConfiguration";
    public static final String SIP_DEFAULTS_XML = "org/cipango/sipapp/sipdefault.xml";
    public static final String[] EXTENSIONS = new String[]{"MESSAGE", "INFO", "SUBSCRIBE", "NOTIFY", "UPDATE", "PUBLISH", "REFER", "100rel"};
    public static final String[] SUPPORTED_RFC = new String[]{"2976", "3261", "3262", "3265", "3311", "3327", "3428", "3515", "3903", "5658", "6026"};
    public static final String EXTERNAL_INTERFACES = "org.cipango.externalOutboundInterfaces";
    private String _name;
    private TimerListener[] _timerListeners = new TimerListener[0];
    private SipApplicationSessionListener[] _appSessionListeners = new SipApplicationSessionListener[0];
    private SipErrorListener[] _errorListeners = new SipErrorListener[0];
    private SipApplicationSessionAttributeListener[] _appSessionAttributeListeners = new SipApplicationSessionAttributeListener[0];
    private SipSessionListener[] _sessionListeners = new SipSessionListener[0];
    private SipSessionAttributeListener[] _sessionAttributeListeners = new SipSessionAttributeListener[0];
    private SipServletListener[] _servletListeners = new SipServletListener[0];
    private int _sessionTimeout = -1;
    private int _proxyTimeout = -1;
    private final CounterStatistic _sessionsStats = new CounterStatistic();
    private final SampleStatistic _sessionTimeStats = new SampleStatistic();
    private String _defaultsSipDescriptor = "org/cipango/sipapp/sipdefault.xml";
    private final List<String> _overrideSipDescriptors = new ArrayList<String>();
    private SipFactory _sipFactory = new Factory();
    private TimerService _timerService = new Timer();
    private SipSessionsUtil _sipSessionsUtil = new SessionUtil();
    private Method _sipApplicationKeyMethod;
    private int _specVersion;
    private SipMetaData _sipMetaData = new SipMetaData();
    private ConstraintSecurityHandler _sipSecurityHandler;

    public SipAppContext() {
        this.setSessionHandler(new SessionHandler((SessionManager)new ConvergedSessionManager()));
        this.setServletHandler(new SipServletHandler());
        this.setConfigurationClasses((String[])LazyList.addToArray((Object[])this.getConfigurationClasses(), (Object)SIP_CONFIGURATION_CLASS, String.class));
        this._scontext = new Context();
        this.setSystemClasses((String[])LazyList.addToArray((Object[])this.getSystemClasses(), (Object)"org.cipango.", String.class));
    }

    public SipAppContext(String sipApp, String contextPath) {
        this();
        this.setWar(sipApp);
        this.setContextPath(contextPath);
    }

    public SipAppContext(SessionHandler sessionHandler, SecurityHandler securityHandler, ServletHandler servletHandler, ErrorHandler errorHandler) {
        super(sessionHandler, securityHandler, servletHandler, errorHandler);
        this._scontext = new Context();
        this.setSystemClasses((String[])LazyList.addToArray((Object[])this.getSystemClasses(), (Object)"org.cipango.", String.class));
    }

    public void addSipServlet(SipServletHolder servlet) {
        ((SipServletHandler)this._servletHandler).addSipServlet(servlet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(SipServletMessage message) throws ServletException, IOException {
        ClassLoader oldClassLoader = null;
        Thread currentThread = null;
        if (this.getClassLoader() != null) {
            currentThread = Thread.currentThread();
            oldClassLoader = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader(this.getClassLoader());
        }
        try {
            if (this._sipSecurityHandler != null) {
                this._sipSecurityHandler.handle(message);
            } else {
                this.getSipServletHandler().handle(message);
            }
        }
        finally {
            if (this.getClassLoader() != null) {
                currentThread.setContextClassLoader(oldClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serverStarted() {
        ClassLoader oldClassLoader = null;
        Thread currentThread = null;
        if (this.getClassLoader() != null) {
            currentThread = Thread.currentThread();
            oldClassLoader = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader(this.getClassLoader());
        }
        try {
            ArrayList<ReadOnlySipURI> outbounds = new ArrayList<ReadOnlySipURI>();
            ArrayList<ReadOnlySipURI> externals = new ArrayList<ReadOnlySipURI>();
            SipConnector[] connectors = this.getServer().getConnectorManager().getConnectors();
            if (connectors != null) {
                for (SipConnector connector : connectors) {
                    SipURIImpl uri = new SipURIImpl(null, connector.getAddr().getHostAddress(), connector.getLocalPort());
                    if (!outbounds.contains(uri)) {
                        outbounds.add(new ReadOnlySipURI(uri));
                    }
                    if (externals.contains(connector.getSipUri())) continue;
                    externals.add(new ReadOnlySipURI(connector.getSipUri()));
                }
            }
            this.setAttribute("javax.servlet.sip.outboundInterfaces", Collections.unmodifiableList(outbounds));
            this.setAttribute(EXTERNAL_INTERFACES, Collections.unmodifiableList(externals));
            SipServletHolder[] holders = this.getSipServletHandler().getSipServlets();
            if (holders != null) {
                for (SipServletHolder holder : holders) {
                    if (holder.getServletInstance() == null || !(holder.getServletInstance() instanceof SipServlet)) continue;
                    this.fireServletInitialized((SipServlet)holder.getServletInstance());
                }
            }
        }
        finally {
            if (this.getClassLoader() != null) {
                currentThread.setContextClassLoader(oldClassLoader);
            }
        }
    }

    public void fireServletInitialized(SipServlet servlet) {
        for (int i = 0; i < this._servletListeners.length; ++i) {
            try {
                this._servletListeners[i].servletInitialized(new SipServletContextEvent(servlet.getServletContext(), servlet));
                continue;
            }
            catch (Throwable t) {
                LOG.debug(t);
            }
        }
    }

    public SipApplicationSessionListener[] getSipApplicationSessionListeners() {
        return this._appSessionListeners;
    }

    public TimerListener[] getTimerListeners() {
        return this._timerListeners;
    }

    public SipErrorListener[] getSipErrorListeners() {
        return this._errorListeners;
    }

    public SipApplicationSessionAttributeListener[] getSipApplicationSessionAttributeListeners() {
        return this._appSessionAttributeListeners;
    }

    public SipSessionListener[] getSipSessionListeners() {
        return this._sessionListeners;
    }

    public SipSessionAttributeListener[] getSessionAttributeListeners() {
        return this._sessionAttributeListeners;
    }

    public void setProxyTimeout(int timeout) {
        this._proxyTimeout = timeout;
    }

    public int getProxyTimeout() {
        return this._proxyTimeout;
    }

    public void setEventListeners(EventListener[] eventListeners) {
        super.setEventListeners(eventListeners);
        Object timerListeners = null;
        Object appSessionListeners = null;
        Object errorListeners = null;
        Object appSessionAttributeListeners = null;
        Object sessionListeners = null;
        Object sessionAttributesListeners = null;
        Object servletListeners = null;
        for (int i = 0; eventListeners != null && i < eventListeners.length; ++i) {
            EventListener listener = eventListeners[i];
            if (listener instanceof TimerListener) {
                timerListeners = LazyList.add(timerListeners, (Object)listener);
            }
            if (listener instanceof SipApplicationSessionListener) {
                appSessionListeners = LazyList.add(appSessionListeners, (Object)listener);
            }
            if (listener instanceof SipErrorListener) {
                errorListeners = LazyList.add(errorListeners, (Object)listener);
            }
            if (listener instanceof SipApplicationSessionAttributeListener) {
                appSessionAttributeListeners = LazyList.add(appSessionAttributeListeners, (Object)listener);
            }
            if (listener instanceof SipSessionListener) {
                sessionListeners = LazyList.add(sessionListeners, (Object)listener);
            }
            if (listener instanceof SipSessionAttributeListener) {
                sessionAttributesListeners = LazyList.add(sessionAttributesListeners, (Object)listener);
            }
            if (!(listener instanceof SipServletListener)) continue;
            servletListeners = LazyList.add(servletListeners, (Object)listener);
        }
        this._timerListeners = (TimerListener[])LazyList.toArray(timerListeners, TimerListener.class);
        this._appSessionListeners = (SipApplicationSessionListener[])LazyList.toArray(appSessionListeners, SipApplicationSessionListener.class);
        this._errorListeners = (SipErrorListener[])LazyList.toArray(errorListeners, SipErrorListener.class);
        this._appSessionAttributeListeners = (SipApplicationSessionAttributeListener[])LazyList.toArray((Object)appSessionAttributeListeners, SipApplicationSessionAttributeListener.class);
        this._sessionListeners = (SipSessionListener[])LazyList.toArray((Object)sessionListeners, SipSessionListener.class);
        this._sessionAttributeListeners = (SipSessionAttributeListener[])LazyList.toArray((Object)sessionAttributesListeners, SipSessionAttributeListener.class);
        this._servletListeners = (SipServletListener[])LazyList.toArray((Object)servletListeners, SipServletListener.class);
    }

    public void fire(EventListener[] listeners, Method method, Object ... args) {
        ClassLoader oldClassLoader = null;
        Thread currentThread = null;
        if (this.getClassLoader() != null) {
            currentThread = Thread.currentThread();
            oldClassLoader = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader(this.getClassLoader());
        }
        for (int i = 0; i < listeners.length; ++i) {
            try {
                method.invoke((Object)listeners[i], args);
                continue;
            }
            catch (Throwable t) {
                LOG.debug(t);
            }
        }
        if (this.getClassLoader() != null) {
            currentThread.setContextClassLoader(oldClassLoader);
        }
    }

    protected void startContext() throws Exception {
        this.setAttribute("javax.servlet.sip.100rel", Boolean.TRUE);
        this.setAttribute("javax.servlet.sip.SipFactory", this.getSipFactory());
        this.setAttribute("javax.servlet.sip.TimerService", this.getTimerService());
        this.setAttribute("javax.servlet.sip.SipSessionsUtil", this.getSipSessionsUtil());
        this.setAttribute("javax.servlet.sip.supported", Collections.unmodifiableList(Arrays.asList(EXTENSIONS)));
        this.setAttribute("javax.servlet.sip.supportedRfcs", Collections.unmodifiableList(Arrays.asList(SUPPORTED_RFC)));
        super.startContext();
        SipHandler handler = this.getSipServletHandler();
        if (this._sipSecurityHandler != null) {
            this._sipSecurityHandler.setHandler(handler);
            handler = this._sipSecurityHandler;
            this._sipSecurityHandler.start();
        }
        if (this._servletHandler != null && this._servletHandler.isStarted()) {
            for (ServletContextHandler.Decorator decorator : this.getDecorators()) {
                if (this.getSipServletHandler().getSipServlets() == null) continue;
                for (SipServletHolder holder : this.getSipServletHandler().getSipServlets()) {
                    decorator.decorateServletHolder((ServletHolder)holder);
                }
            }
            ((SipServletHandler)this._servletHandler).initializeSip();
        }
    }

    public void configure() throws Exception {
        super.configure();
        this._sipMetaData.resolve(this);
    }

    public String getDefaultName() {
        String name = this.getContextPath();
        if (name != null && name.startsWith("/")) {
            name = name.substring(1);
        }
        return name;
    }

    protected void doStart() throws Exception {
        if (this.getSipSecurityHandler() != null) {
            this._sipSecurityHandler.setServer(this.getServer());
        }
        super.doStart();
        if (!this.isAvailable()) {
            if (this._name == null) {
                this._name = this.getDefaultName();
            }
            Events.fire(2, "Unable to deploy application " + this.getName() + ": " + this.getUnavailableException().getMessage());
        } else if (this.hasSipServlets()) {
            this.getServer().applicationStarted(this);
        }
    }

    protected void doStop() throws Exception {
        if (this.hasSipServlets() && this.isAvailable()) {
            this.getServer().applicationStopped(this);
        }
        if (this._sipMetaData != null) {
            this._sipMetaData.clear();
        }
        this._sipMetaData = new SipMetaData();
        if (this._sipSecurityHandler != null) {
            this._sipSecurityHandler.stop();
        }
        super.doStop();
    }

    public SipServletHandler getSipServletHandler() {
        return (SipServletHandler)this.getServletHandler();
    }

    public boolean hasSipServlets() {
        SipServletHolder[] holders = this.getSipServletHandler().getSipServlets();
        return holders != null && holders.length != 0;
    }

    public void incrementSessions() {
        this._sessionsStats.increment();
    }

    public void decrementSessions(long sessionLifetime) {
        this._sessionsStats.decrement();
        this._sessionTimeStats.set(Math.round((double)sessionLifetime / 1000.0));
    }

    public long getSessions() {
        return this._sessionsStats.getCurrent();
    }

    public long getSessionsTotal() {
        return this._sessionsStats.getTotal();
    }

    public long getSessionsMax() {
        return this._sessionsStats.getMax();
    }

    public long getSessionTimeMax() {
        return this._sessionTimeStats.getMax();
    }

    public void statsReset() {
        this._sessionsStats.reset(this.getSessions());
        this._sessionTimeStats.reset();
    }

    public long getSessionTimeTotal() {
        return this._sessionTimeStats.getTotal();
    }

    public double getSessionTimeMean() {
        return this._sessionTimeStats.getMean();
    }

    public double getSessionTimeStdDev() {
        return this._sessionTimeStats.getStdDev();
    }

    public void setDefaultsSipDescriptor(String defaultsDescriptor) {
        this._defaultsSipDescriptor = defaultsDescriptor;
    }

    public String getDefaultsSipDescriptor() {
        return this._defaultsSipDescriptor;
    }

    public void setOverrideSipDescriptor(String overrideDescriptor) {
        this._overrideSipDescriptors.clear();
        this._overrideSipDescriptors.add(overrideDescriptor);
    }

    public void setOverrideSipDescriptors(List<String> overrideDescriptors) {
        this._overrideSipDescriptors.clear();
        this._overrideSipDescriptors.addAll(overrideDescriptors);
    }

    public void addOverrideSipDescriptor(String overrideDescriptor) {
        this._overrideSipDescriptors.add(overrideDescriptor);
    }

    public String getOverrideSipDescriptor() {
        if (this._overrideSipDescriptors.size() != 1) {
            return null;
        }
        return this._overrideSipDescriptors.get(0);
    }

    public List<String> getOverrideSipDescriptors() {
        return Collections.unmodifiableList(this._overrideSipDescriptors);
    }

    public void setSessionTimeout(int minutes) {
        this._sessionTimeout = minutes <= 0 ? -1 : minutes;
    }

    public int getSessionTimeout() {
        return this._sessionTimeout;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public boolean isServerClass(String name) {
        name = name.replace('/', '.');
        while (name.startsWith(".")) {
            name = name.substring(1);
        }
        String[] server_classes = this.getServerClasses();
        if (server_classes != null) {
            for (int i = 0; i < server_classes.length; ++i) {
                boolean result = true;
                String c = server_classes[i];
                if (c.startsWith("-")) {
                    c = c.substring(1);
                    result = false;
                }
                if (!(c.endsWith(".") ? name.startsWith(c) : name.equals(c))) continue;
                return result;
            }
        }
        return false;
    }

    public boolean isSystemClass(String name) {
        name = name.replace('/', '.');
        while (name.startsWith(".")) {
            name = name.substring(1);
        }
        String[] system_classes = this.getSystemClasses();
        if (system_classes != null) {
            for (int i = 0; i < system_classes.length; ++i) {
                boolean result = true;
                String c = system_classes[i];
                if (c.startsWith("-")) {
                    c = c.substring(1);
                    result = false;
                }
                if (!(c.endsWith(".") ? name.startsWith(c) : name.equals(c))) continue;
                return result;
            }
        }
        return false;
    }

    public SipFactory getSipFactory() {
        return this._sipFactory;
    }

    public TimerService getTimerService() {
        return this._timerService;
    }

    public SipSessionsUtil getSipSessionsUtil() {
        return this._sipSessionsUtil;
    }

    public String getSipApplicationKey(SipServletRequest request) {
        if (this._sipApplicationKeyMethod == null) {
            return null;
        }
        try {
            return (String)this._sipApplicationKeyMethod.invoke(null, request);
        }
        catch (Throwable e) {
            LOG.debug("Fail to get SipApplicationKey", e);
            return null;
        }
    }

    public Method getSipApplicationKeyMethod() {
        return this._sipApplicationKeyMethod;
    }

    public void setSipApplicationKeyMethod(Method sipApplicationKeyMethod) {
        this._sipApplicationKeyMethod = sipApplicationKeyMethod;
    }

    public int getSpecVersion() {
        return this._specVersion;
    }

    public String getSpecVersionAsString() {
        switch (this._specVersion) {
            case 10: {
                return "1.0";
            }
            case 11: {
                return "1.1";
            }
        }
        return String.valueOf(this._specVersion);
    }

    public void setSpecVersion(int specVersion) {
        this._specVersion = specVersion;
    }

    @Override
    public Server getServer() {
        return (Server)super.getServer();
    }

    public SipMetaData getSipMetaData() {
        return this._sipMetaData;
    }

    public ConstraintSecurityHandler getSipSecurityHandler() {
        if (this._sipSecurityHandler == null && (this._options & 2) != 0 && !this.isStarted()) {
            this.setSipSecurityHandler(this.newSipSecurityHandler());
        }
        return this._sipSecurityHandler;
    }

    protected ConstraintSecurityHandler newSipSecurityHandler() {
        return new ConstraintSecurityHandler();
    }

    public void setSipSecurityHandler(ConstraintSecurityHandler sipSecurityHandler) {
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, (Object)this._sipSecurityHandler, (Object)sipSecurityHandler, "sipSecurityHandler");
        }
        this._sipSecurityHandler = sipSecurityHandler;
    }

    public String toString() {
        if (this._name != null) {
            return super.toString() + ", " + this._name;
        }
        return super.toString();
    }

    public boolean isUnavailable() {
        return this.getUnavailableException() != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class CLFireEvent<L extends EventListener, E> {
        CLFireEvent() {
        }

        public abstract void fireEvent(L var1, E var2);

        public abstract L[] getEventListeners();

        public boolean hasListeners() {
            EventListener[] listeners = this.getEventListeners();
            return listeners != null && listeners.length > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fire(E event) {
            EventListener[] listeners = this.getEventListeners();
            if (listeners != null && listeners.length > 0) {
                ClassLoader oldClassLoader = null;
                Thread currentThread = null;
                if (SipAppContext.this.getClassLoader() != null) {
                    currentThread = Thread.currentThread();
                    oldClassLoader = currentThread.getContextClassLoader();
                    currentThread.setContextClassLoader(SipAppContext.this.getClassLoader());
                }
                try {
                    for (int i = 0; i < listeners.length; ++i) {
                        this.fireEvent(listeners[i], event);
                    }
                }
                finally {
                    if (SipAppContext.this.getClassLoader() != null) {
                        currentThread.setContextClassLoader(oldClassLoader);
                    }
                }
            }
        }
    }

    public class Context
    extends WebAppContext.Context {
        public Context() {
            super((WebAppContext)SipAppContext.this);
        }

        public RequestDispatcher getNamedDispatcher(String name) {
            SipServletHolder holder;
            if (SipAppContext.this._servletHandler != null && (holder = ((SipServletHandler)SipAppContext.this._servletHandler).getHolder(name)) != null) {
                return new SipDispatcher(SipAppContext.this, holder);
            }
            return super.getNamedDispatcher(name);
        }

        public String getServerInfo() {
            return "cipango-2.0";
        }
    }

    class SessionUtil
    implements SipSessionsUtil {
        SessionUtil() {
        }

        public SipApplicationSession getApplicationSessionById(String applicationSessionId) {
            if (applicationSessionId == null) {
                throw new NullPointerException("applicationSessionId is null");
            }
            int i = applicationSessionId.indexOf(59);
            if (i < 0) {
                return null;
            }
            String id = applicationSessionId.substring(0, i);
            CallSession callSession = SipAppContext.this.getServer().getSessionManager().get(id);
            if (callSession == null) {
                return null;
            }
            AppSession appSession = callSession.getAppSession(applicationSessionId.substring(i + 1));
            if (appSession == null) {
                return null;
            }
            return new ScopedAppSession(appSession);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SipApplicationSession getApplicationSessionByKey(String key, boolean create) {
            if (key == null) {
                throw new NullPointerException("key is null");
            }
            String id = ID.getIdFromKey(SipAppContext.this.getName(), key);
            SessionManager.SessionScope tx = SipAppContext.this.getServer().getSessionManager().openScope(id);
            try {
                AppSession appSession = tx.getCallSession().getAppSession(id);
                if (appSession == null) {
                    if (create) {
                        appSession = tx.getCallSession().createAppSession(SipAppContext.this, id);
                    } else {
                        SipApplicationSession sipApplicationSession = null;
                        return sipApplicationSession;
                    }
                }
                ScopedAppSession scopedAppSession = new ScopedAppSession(appSession);
                return scopedAppSession;
            }
            finally {
                tx.close();
            }
        }

        public SipSession getCorrespondingSipSession(SipSession session, String headerName) {
            return null;
        }
    }

    public class Factory
    implements SipFactory {
        private Factory() {
        }

        public URI createURI(String uri) throws ServletParseException {
            return URIFactory.parseURI(uri);
        }

        public SipURI createSipURI(String user, String host) {
            return new SipURIImpl(user, host, -1);
        }

        public Address createAddress(String address) throws ServletParseException {
            return new NameAddr(address);
        }

        public Address createAddress(URI uri) {
            return new NameAddr(uri);
        }

        public Address createAddress(URI uri, String displayName) {
            return new NameAddr(uri, displayName);
        }

        public SipServletRequest createRequest(SipApplicationSession sipAppSession, String method, Address from, Address to) {
            if ("ACK".equalsIgnoreCase(method) || "CANCEL".equalsIgnoreCase(method)) {
                throw new IllegalArgumentException("Method cannot be ACK nor CANCEL");
            }
            NameAddr local = (NameAddr)from.clone();
            NameAddr remote = (NameAddr)to.clone();
            local.setParameter("tag", ID.newTag());
            remote.removeParameter("tag");
            AppSession appSession = ((AppSessionIf)sipAppSession).getAppSession();
            String cid = ID.newCallId(appSession.getCallSession().getId());
            Session session = appSession.createUacSession(cid, local, remote);
            session.setHandler(SipAppContext.this.getSipServletHandler().getDefaultServlet());
            SipRequest request = (SipRequest)session.createRequest(method);
            request.setInitial(true);
            request.setRoutingDirective(SipApplicationRoutingDirective.NEW, null);
            return request;
        }

        public SipServletRequest createRequest(SipApplicationSession appSession, String method, URI from, URI to) {
            return this.createRequest(appSession, method, this.createAddress(from), this.createAddress(to));
        }

        public SipServletRequest createRequest(SipApplicationSession appSession, String method, String from, String to) throws ServletParseException {
            return this.createRequest(appSession, method, this.createAddress(from), this.createAddress(to));
        }

        public SipServletRequest createRequest(SipServletRequest srcRequest, boolean sameCallId) {
            SipRequest origRequest = (SipRequest)srcRequest;
            NameAddr local = (NameAddr)origRequest.from().clone();
            local.setParameter("tag", ID.newTag());
            NameAddr remote = (NameAddr)origRequest.to().clone();
            remote.removeParameter("tag");
            String callId = null;
            callId = sameCallId ? origRequest.getCallId() : ID.newCallId(origRequest.getCallId());
            AppSession appSession = ((SipRequest)srcRequest).appSession();
            Session session = appSession.createUacSession(callId, local, remote);
            session.setHandler(SipAppContext.this.getSipServletHandler().getDefaultServlet());
            SipRequest request = session.getUA().createRequest((SipRequest)srcRequest);
            request.setRoutingDirective(SipApplicationRoutingDirective.CONTINUE, srcRequest);
            request.setInitial(true);
            return request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SipApplicationSession createApplicationSession() {
            Server server = SipAppContext.this.getServer();
            SessionManager.SessionScope scope = server.getSessionManager().openScope(ID.newCallId());
            try {
                AppSession session = scope.getCallSession().createAppSession(SipAppContext.this, ID.newAppSessionId());
                ScopedAppSession scopedAppSession = new ScopedAppSession(session);
                return scopedAppSession;
            }
            finally {
                scope.close();
            }
        }

        public SipApplicationSession createApplicationSessionByKey(String key) {
            return SipAppContext.this.getSipSessionsUtil().getApplicationSessionByKey(key, true);
        }

        public AuthInfo createAuthInfo() {
            return new AuthInfoImpl();
        }

        public Parameterable createParameterable(String s) throws ServletParseException {
            return new ParameterableImpl(s);
        }
    }

    public class Timer
    implements TimerService {
        public ServletTimer createTimer(SipApplicationSession session, long delay, boolean isPersistent, Serializable info) {
            return new ScopedTimer(((AppSessionIf)session).getAppSession(), delay, isPersistent, info);
        }

        public ServletTimer createTimer(SipApplicationSession session, long delay, long period, boolean fixedDelay, boolean isPersistent, Serializable info) {
            return new ScopedTimer(((AppSessionIf)session).getAppSession(), delay, period, fixedDelay, isPersistent, info);
        }
    }
}

