/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sip.security.authentication;

import java.io.IOException;
import java.security.MessageDigest;
import java.util.ListIterator;
import javax.servlet.sip.SipServletResponse;
import org.cipango.server.SipRequest;
import org.cipango.sip.SipHeaders;
import org.cipango.sip.security.Authenticate;
import org.cipango.sip.security.Authorization;
import org.cipango.sip.security.SipAuthenticator;
import org.cipango.util.HexString;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class DigestAuthenticator
implements SipAuthenticator {
    private static final Logger LOG = Log.getLogger(DigestAuthenticator.class);
    private SipAuthenticator.AuthConfiguration _authConfiguration;
    protected long nonceValidity = 5000L;
    protected long nonceSecret = System.currentTimeMillis();

    public UserIdentity authenticate(SipRequest request, boolean proxyMode, boolean authMandatory) {
        block6: {
            try {
                Authorization authorization = this.getAuthorization(request, proxyMode);
                if (authorization == null) {
                    LOG.debug("No authorization header found, send challenge", new Object[0]);
                    this.send401(request, proxyMode, false);
                    break block6;
                }
                if (!this.checkNonce(authorization.getNonce())) {
                    LOG.debug("Request is stale, nonce is too old", new Object[0]);
                    this.send401(request, proxyMode, true);
                    break block6;
                }
                authorization.setMethod(request.getMethod());
                UserIdentity user = this._authConfiguration.getLoginService().login(authorization.getUsername(), (Object)authorization);
                if (user == null) {
                    LOG.debug("Authentication failed or user unknown", new Object[0]);
                    SipServletResponse response = request.createResponse(403);
                    response.send();
                } else {
                    LOG.debug("Authentication succeed for {}", new Object[]{user});
                }
                return user;
            }
            catch (Exception e) {
                LOG.warn("Failed to authenticate", (Throwable)e);
            }
        }
        return null;
    }

    public void setAuthConfiguration(SipAuthenticator.AuthConfiguration configuration) {
        if (configuration.getLoginService() == null) {
            throw new IllegalStateException("No LoginService for " + this + " in " + configuration);
        }
        this._authConfiguration = configuration;
    }

    private void send401(SipRequest request, boolean proxyMode, boolean stale) throws IOException {
        SipServletResponse response;
        Authenticate authenticate = new Authenticate("Digest", this._authConfiguration.getRealmName(), this.newNonce(), stale, "md5");
        if (proxyMode) {
            response = request.createResponse(407);
            response.setHeader("Proxy-Authenticate", authenticate.toString());
        } else {
            response = request.createResponse(401);
            response.setHeader("WWW-Authenticate", authenticate.toString());
        }
        response.send();
    }

    private Authorization getAuthorization(SipRequest request, boolean proxyMode) {
        ListIterator<String> it = request.getFields().getValues(this.getAuthHeaderName(proxyMode));
        while (it.hasNext()) {
            Authorization authorization = new Authorization((String)it.next());
            if (!this._authConfiguration.getRealmName().equals(authorization.getRealm())) continue;
            return authorization;
        }
        return null;
    }

    private Buffer getAuthHeaderName(boolean proxyMode) {
        if (proxyMode) {
            return SipHeaders.PROXY_AUTHORIZATION_BUFFER;
        }
        return SipHeaders.AUTHORIZATION_BUFFER;
    }

    public synchronized boolean checkNonce(String nonce) {
        byte[] b = HexString.fromHexString(nonce);
        if (b.length != 24) {
            return false;
        }
        long time = 0L;
        long secret = this.nonceSecret;
        byte[] b2 = new byte[16];
        System.arraycopy(b, 0, b2, 0, 8);
        for (int i = 0; i < 8; ++i) {
            b2[8 + i] = (byte)(secret & 0xFFL);
            secret >>= 8;
            time = (time << 8) + (long)(b[7 - i] & 0xFF);
        }
        byte[] hash = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(b2, 0, 16);
            hash = md.digest();
        }
        catch (Exception e) {
            LOG.warn("Unexpected error", (Throwable)e);
        }
        for (int i = 0; i < 16; ++i) {
            if (b[i + 8] == hash[i]) continue;
            return false;
        }
        return System.currentTimeMillis() - time < this.nonceValidity;
    }

    protected synchronized String newNonce() {
        long time = System.currentTimeMillis();
        long secret = this.nonceSecret;
        byte[] nonce = new byte[24];
        for (int i = 0; i < 8; ++i) {
            nonce[i] = (byte)(time & 0xFFL);
            time >>= 8;
            nonce[8 + i] = (byte)(secret & 0xFFL);
            secret >>= 8;
        }
        byte[] hash = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            md.update(nonce, 0, 16);
            hash = md.digest();
        }
        catch (Exception e) {
            LOG.warn("Unexpected error", (Throwable)e);
        }
        for (int i = 0; i < hash.length; ++i) {
            nonce[8 + i] = hash[i];
        }
        return HexString.toHexString(nonce);
    }

    public String getAuthMethod() {
        return "DIGEST";
    }
}

