/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sip.security;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.cipango.server.SipConnector;
import org.cipango.server.SipRequest;
import org.cipango.servlet.SipServletHolder;
import org.cipango.sip.security.Constraint;
import org.cipango.sip.security.ConstraintMapping;
import org.cipango.sip.security.RoleInfo;
import org.cipango.sip.security.SipSecurityHandler;
import org.eclipse.jetty.security.UserDataConstraint;
import org.eclipse.jetty.server.UserIdentity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintSecurityHandler
extends SipSecurityHandler<RoleInfo> {
    private final List<ConstraintMapping> _constraintMappings = new CopyOnWriteArrayList<ConstraintMapping>();
    private final Set<String> _roles = new CopyOnWriteArraySet<String>();
    private boolean _strict = true;
    private Map<String, Map<String, RoleInfo>> _servletsMap = new HashMap<String, Map<String, RoleInfo>>();

    public boolean isStrict() {
        return this._strict;
    }

    public void setStrict(boolean strict) {
        this._strict = strict;
    }

    public List<ConstraintMapping> getConstraintMappings() {
        return this._constraintMappings;
    }

    public Set<String> getRoles() {
        return this._roles;
    }

    public void setConstraintMappings(List<ConstraintMapping> constraintMappings) {
        this.setConstraintMappings(constraintMappings, null);
    }

    public void setConstraintMappings(List<ConstraintMapping> constraintMappings, Set<String> roles) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this._constraintMappings.clear();
        this._constraintMappings.addAll(constraintMappings);
        if (roles == null) {
            roles = new HashSet<String>();
            for (ConstraintMapping cm : constraintMappings) {
                String[] cmr = cm.getConstraint().getRoles();
                if (cmr == null) continue;
                for (String r : cmr) {
                    if ("*".equals(r)) continue;
                    roles.add(r);
                }
            }
        }
        this.setRoles(roles);
    }

    public void setRoles(Set<String> roles) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this._roles.clear();
        this._roles.addAll(roles);
    }

    public void addConstraintMapping(ConstraintMapping mapping) {
        this._constraintMappings.add(mapping);
        if (mapping.getConstraint() != null && mapping.getConstraint().getRoles() != null) {
            for (String role : mapping.getConstraint().getRoles()) {
                this.addRole(role);
            }
        }
    }

    public void addRole(String role) {
        this._roles.add(role);
    }

    @Override
    protected void doStart() throws Exception {
        this._servletsMap.clear();
        if (this._constraintMappings != null) {
            for (ConstraintMapping mapping : this._constraintMappings) {
                this.processConstraintMapping(mapping);
            }
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        this._servletsMap.clear();
        this._constraintMappings.clear();
        this._roles.clear();
        super.doStop();
    }

    @Override
    protected RoleInfo prepareConstraintInfo(SipServletHolder holder, SipRequest request) {
        Map<String, RoleInfo> mappings = this._servletsMap.get(holder.getName());
        if (mappings != null) {
            String method = request.getMethod();
            RoleInfo roleInfo = mappings.get(method);
            if (roleInfo == null) {
                roleInfo = mappings.get(null);
            }
            return roleInfo;
        }
        mappings = this._servletsMap.get(null);
        if (mappings != null) {
            return mappings.get(request.getMethod());
        }
        return null;
    }

    @Override
    protected boolean checkUserDataPermissions(SipServletHolder holder, SipRequest request, RoleInfo constraintInfo) throws IOException {
        if (constraintInfo == null) {
            return true;
        }
        if (constraintInfo.isForbidden()) {
            return false;
        }
        UserDataConstraint dataConstraint = constraintInfo.getUserDataConstraint();
        if (dataConstraint == null || dataConstraint == UserDataConstraint.None) {
            return true;
        }
        SipConnector connector = null;
        if (request.getConnection() != null) {
            connector = request.getConnection().getConnector();
        }
        return true;
    }

    @Override
    protected boolean isAuthMandatory(SipRequest baseRequest, RoleInfo constraintInfo) {
        if (constraintInfo == null) {
            return false;
        }
        return constraintInfo.isChecked();
    }

    @Override
    protected boolean checkSipResourcePermissions(SipServletHolder holder, SipRequest request, RoleInfo constraintInfo, UserIdentity userIdentity) throws IOException {
        if (constraintInfo == null) {
            return true;
        }
        if (!constraintInfo.isChecked()) {
            return true;
        }
        if (constraintInfo.isAnyRole()) {
            return true;
        }
        for (String role : constraintInfo.getRoles()) {
            if (!userIdentity.isUserInRole(role, null)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isProxyMode(SipRequest baseRequest, RoleInfo constraintInfo) {
        if (constraintInfo == null) {
            return true;
        }
        return constraintInfo.isProxyMode();
    }

    protected void processConstraintMapping(ConstraintMapping mapping) {
        if (mapping.getServletNames() == null) {
            for (String method : mapping.getMethods()) {
                this.processMapping(null, method, mapping.getConstraint());
            }
        } else {
            for (String servletName : mapping.getServletNames()) {
                if (mapping.getMethods() == null) {
                    this.processMapping(servletName, null, mapping.getConstraint());
                    continue;
                }
                for (String method : mapping.getMethods()) {
                    this.processMapping(servletName, method, mapping.getConstraint());
                }
            }
        }
    }

    private void processMapping(String servletName, String method, Constraint constraint) {
        RoleInfo allMethodsRoleInfo;
        Map<String, RoleInfo> mappings = this._servletsMap.get(servletName);
        if (mappings == null) {
            mappings = new HashMap<String, RoleInfo>();
            this._servletsMap.put(servletName, mappings);
        }
        if ((allMethodsRoleInfo = mappings.get(null)) != null && allMethodsRoleInfo.isForbidden()) {
            return;
        }
        RoleInfo roleInfo = mappings.get(method);
        if (roleInfo == null) {
            roleInfo = new RoleInfo();
            mappings.put(method, roleInfo);
            if (allMethodsRoleInfo != null) {
                roleInfo.combine(allMethodsRoleInfo);
            }
        }
        if (roleInfo.isForbidden()) {
            return;
        }
        boolean forbidden = constraint.isForbidden();
        roleInfo.setForbidden(forbidden);
        if (forbidden) {
            if (method == null) {
                mappings.clear();
                mappings.put(null, roleInfo);
            }
        } else {
            UserDataConstraint userDataConstraint = UserDataConstraint.get((int)constraint.getDataConstraint());
            roleInfo.setUserDataConstraint(userDataConstraint);
            roleInfo.setProxyMode(constraint.isProxyMode());
            boolean checked = constraint.getAuthenticate();
            roleInfo.setChecked(checked);
            if (roleInfo.isChecked()) {
                if (constraint.isAnyRole()) {
                    if (this._strict) {
                        for (String string : this._roles) {
                            roleInfo.addRole(string);
                        }
                    } else {
                        roleInfo.setAnyRole(true);
                    }
                } else {
                    String[] newRoles;
                    for (String role : newRoles = constraint.getRoles()) {
                        if (this._strict && !this._roles.contains(role)) {
                            throw new IllegalArgumentException("Attempt to use undeclared role: " + role + ", known roles: " + this._roles);
                        }
                        roleInfo.addRole(role);
                    }
                }
            }
            if (method == null) {
                for (Map.Entry entry : mappings.entrySet()) {
                    if (entry.getKey() == null) continue;
                    RoleInfo specific = (RoleInfo)((Object)entry.getValue());
                    specific.combine(roleInfo);
                }
            }
        }
    }

    public void dump(Appendable out, String indent) throws IOException {
        this.dumpThis(out);
        ConstraintSecurityHandler.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{Arrays.asList(this.getBeans(), Collections.singleton(this._roles), this._servletsMap.entrySet())});
    }
}

