/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sip.security;

import java.util.HashMap;
import java.util.StringTokenizer;
import org.cipango.server.ID;
import org.cipango.sip.security.Authenticate;
import org.cipango.util.DigestAuthenticator;
import org.eclipse.jetty.http.security.Credential;
import org.eclipse.jetty.io.BufferCache;

public class Authorization
extends Credential {
    public static BufferCache CACHE = new BufferCache();
    public static final String USERNAME = "username";
    public static final String REALM = "realm";
    public static final String NONCE = "nonce";
    public static final String DIGEST_URI = "uri";
    public static final String RESPONSE = "response";
    public static final String ALGORITHM = "algorithm";
    public static final String CNONCE = "cnonce";
    public static final String OPAQUE = "opaque";
    public static final String QOP = "qop";
    public static final String NONCE_COUNT = "nc";
    public static final int USERNAME_ORDINAL = 0;
    public static final int REALM_ORDINAL = 1;
    public static final int NONCE_ORDINAL = 2;
    public static final int DIGEST_URI_ORDINAL = 3;
    public static final int RESPONSE_ORDINAL = 4;
    public static final int ALGORITHM_ORDINAL = 5;
    public static final int CNONCE_ORDINAL = 6;
    public static final int OPAQUE_ORDINAL = 7;
    public static final int QOP_ORDINAL = 8;
    public static final int NONCE_COUNT_ORDINAL = 9;
    public static final BufferCache.CachedBuffer USERNAME_BUFFER = CACHE.add("username", 0);
    public static final BufferCache.CachedBuffer REALM_BUFFER = CACHE.add("realm", 1);
    public static final BufferCache.CachedBuffer NONCE_BUFFER = CACHE.add("nonce", 2);
    public static final BufferCache.CachedBuffer DIGEST_URI_BUFFER = CACHE.add("uri", 3);
    public static final BufferCache.CachedBuffer RESPONSE_BUFFER = CACHE.add("response", 4);
    public static final BufferCache.CachedBuffer ALGORITHM_BUFFER = CACHE.add("algorithm", 5);
    public static final BufferCache.CachedBuffer CNONCE_BUFFER = CACHE.add("cnonce", 6);
    public static final BufferCache.CachedBuffer OPAQUE_BUFFER = CACHE.add("opaque", 7);
    public static final BufferCache.CachedBuffer QOP_BUFFER = CACHE.add("qop", 8);
    public static final BufferCache.CachedBuffer NONCE_COUNT_BUFFER = CACHE.add("nc", 9);
    private String[] _params = new String[10];
    private String _scheme;
    private HashMap<String, String> _unknwonParams;
    private String _method;

    public Authorization(Authenticate authenticate, String username, String password, String uri, String method) {
        this._params[0] = username;
        this._params[1] = authenticate.getRealm();
        this._params[2] = authenticate.getNonce();
        this._params[5] = authenticate.getAlgorithm();
        this._scheme = authenticate.getScheme();
        if (authenticate.getQop() != null) {
            this._params[6] = ID.newCNonce();
            StringTokenizer st = new StringTokenizer(authenticate.getQop(), ",");
            boolean first = true;
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (!first && !token.equalsIgnoreCase("auth")) continue;
                this._params[8] = token;
                first = false;
            }
            this._params[9] = "00000001";
        }
        this._params[7] = authenticate.getOpaque();
        this._params[3] = uri;
        this._params[4] = this.getCalculatedResponse(password, method);
    }

    public Authorization(String auth) {
        int beginIndex = auth.indexOf(32);
        this._scheme = auth.substring(0, beginIndex).trim();
        while (beginIndex > 0) {
            int endIndex = auth.indexOf(61, beginIndex);
            String name = auth.substring(beginIndex, endIndex).trim();
            if (auth.charAt(endIndex + 1) == '\"') {
                beginIndex = endIndex + 2;
                endIndex = auth.indexOf(34, beginIndex);
            } else {
                beginIndex = endIndex + 1;
                if ((endIndex = auth.indexOf(44, beginIndex)) == -1) {
                    endIndex = auth.length();
                }
            }
            String value = auth.substring(beginIndex, endIndex);
            this.setParameter(name, value);
            beginIndex = auth.indexOf(44, endIndex) + 1;
        }
    }

    public String getCalculatedResponse(String password, String method) {
        return new DigestAuthenticator().calculateResponse(this, password, method);
    }

    public void setParameter(String name, String value) {
        BufferCache.CachedBuffer buffer = CACHE.get(name);
        if (buffer == null) {
            if (this._unknwonParams == null) {
                this._unknwonParams = new HashMap();
            }
            this._unknwonParams.put(name, value);
        } else {
            this._params[buffer.getOrdinal()] = value;
        }
    }

    public String getScheme() {
        return this._scheme;
    }

    public String getUsername() {
        return this._params[0];
    }

    public String getUri() {
        return this._params[3];
    }

    public String getNonceCount() {
        return this._params[9];
    }

    public String getRealm() {
        return this._params[1];
    }

    public String getResponse() {
        return this._params[4];
    }

    public void setRealm(String realm) {
        this._params[1] = realm;
    }

    public String getNonce() {
        return this._params[2];
    }

    public String getCNonce() {
        return this._params[6];
    }

    public void setNonce(String nonce) {
        this._params[2] = nonce;
    }

    public String getOpaque() {
        return this._params[7];
    }

    public void setOpaque(String opaque) {
        this._params[7] = opaque;
    }

    public String getAlgorithm() {
        return this._params[5];
    }

    public String getQop() {
        return this._params[8];
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getScheme()).append(' ');
        boolean first = true;
        for (int i = 0; i < this._params.length; ++i) {
            if (this._params[i] == null) continue;
            if (!first) {
                sb.append(',');
            } else {
                first = false;
            }
            sb.append(CACHE.get(i).buffer().toString());
            sb.append("=\"").append(this._params[i]).append('\"');
        }
        return sb.toString();
    }

    public boolean check(Object credentials) {
        if (credentials instanceof char[]) {
            credentials = new String((char[])credentials);
        }
        String password = credentials instanceof String ? (String)credentials : credentials.toString();
        return this.getResponse().equals(this.getCalculatedResponse(password, this._method));
    }

    public String getMethod() {
        return this._method;
    }

    public void setMethod(String method) {
        this._method = method;
    }
}

