/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sip.security;

import java.util.HashMap;
import org.cipango.sip.LazyParsingException;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.BufferCache;

public class Authenticate {
    public static BufferCache CACHE = new BufferCache();
    public static final String REALM = "realm";
    public static final String DOMAIN = "domain";
    public static final String NONCE = "nonce";
    public static final String OPAQUE = "opaque";
    public static final String STALE = "stale";
    public static final String ALGORITHM = "algorithm";
    public static final String QOP = "qop";
    public static final int REALM_ORDINAL = 0;
    public static final int DOMAIN_ORDINAL = 1;
    public static final int NONCE_ORDINAL = 2;
    public static final int OPAQUE_ORDINAL = 3;
    public static final int STALE_ORDINAL = 4;
    public static final int ALGORITHM_ORDINAL = 5;
    public static final int QOP_ORDINAL = 6;
    public static final BufferCache.CachedBuffer REALM_BUFFER = CACHE.add("realm", 0);
    public static final BufferCache.CachedBuffer DOMAIN_BUFFER = CACHE.add("domain", 1);
    public static final BufferCache.CachedBuffer NONCE_BUFFER = CACHE.add("nonce", 2);
    public static final BufferCache.CachedBuffer OPAQUE_BUFFER = CACHE.add("opaque", 3);
    public static final BufferCache.CachedBuffer STALE_BUFFER = CACHE.add("stale", 4);
    public static final BufferCache.CachedBuffer ALGORITHM_BUFFER = CACHE.add("algorithm", 5);
    public static final BufferCache.CachedBuffer QOP_BUFFER = CACHE.add("qop", 6);
    private String[] _params = new String[7];
    private String _scheme;
    private HashMap<String, String> _unknwonParams;

    public Authenticate(String auth) throws LazyParsingException {
        int beginIndex = auth.indexOf(32);
        this._scheme = auth.substring(0, beginIndex).trim();
        while (beginIndex > 0) {
            int endIndex = auth.indexOf(61, beginIndex);
            String name = auth.substring(beginIndex, endIndex).trim();
            if (auth.charAt(endIndex + 1) == '\"') {
                beginIndex = endIndex + 2;
                endIndex = auth.indexOf(34, beginIndex);
            } else {
                beginIndex = endIndex + 1;
                if ((endIndex = auth.indexOf(44, beginIndex)) == -1) {
                    endIndex = auth.length();
                }
            }
            String value = auth.substring(beginIndex, endIndex);
            this.setParameter(name, value);
            beginIndex = auth.indexOf(44, endIndex) + 1;
        }
    }

    public Authenticate(String scheme, String realm, String nonce, boolean stale, String algorithm) {
        this._scheme = scheme;
        this._params[0] = realm;
        this._params[2] = nonce;
        this._params[5] = algorithm;
        if (stale) {
            this._params[4] = "true";
        }
    }

    public String getParameter(String name) {
        BufferCache.CachedBuffer buffer = CACHE.get(name);
        if (buffer == null) {
            if (this._unknwonParams == null) {
                return null;
            }
            return this._unknwonParams.get(name);
        }
        return this._params[buffer.getOrdinal()];
    }

    public void setParameter(String name, String value) {
        BufferCache.CachedBuffer buffer = CACHE.get(name);
        if (buffer == null) {
            if (this._unknwonParams == null) {
                this._unknwonParams = new HashMap();
            }
            this._unknwonParams.put(name, value);
        } else {
            this._params[buffer.getOrdinal()] = value;
        }
    }

    public String getScheme() {
        return this._scheme;
    }

    public String getParameter(BufferCache.CachedBuffer buffer) {
        return this._params[CACHE.getOrdinal((Buffer)buffer)];
    }

    public String getRealm() {
        return this._params[0];
    }

    public String getDomain() {
        return this._params[1];
    }

    public String getNonce() {
        return this._params[2];
    }

    public String getOpaque() {
        return this._params[3];
    }

    public boolean isStale() {
        return "true".equalsIgnoreCase(this._params[4]);
    }

    public String getAlgorithm() {
        return this._params[5];
    }

    public String getQop() {
        return this._params[6];
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getScheme()).append(' ');
        boolean first = true;
        for (int i = 0; i < this._params.length; ++i) {
            if (this._params[i] == null) continue;
            if (!first) {
                sb.append(',');
            } else {
                first = false;
            }
            sb.append(CACHE.get(i).buffer().toString());
            sb.append("=\"").append(this._params[i]).append('\"');
        }
        if (this._unknwonParams != null) {
            for (String key : this._unknwonParams.keySet()) {
                sb.append(',');
                sb.append(key).append("=\"").append(this._unknwonParams.get(key)).append('\"');
            }
        }
        return sb.toString();
    }
}

