/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sip;

import java.io.Serializable;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.servlet.sip.ServletParseException;
import org.cipango.sip.SipGrammar;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;

public class Via
implements Serializable,
Cloneable {
    static final long serialVersionUID = 406731255735133275L;
    public static final String MAGIC_COOKIE = "z9hG4bK";
    private static final String BRANCH_PARAM = "branch";
    private static final String MADDR_PARAM = "maddr";
    private static final String RECEIVED_PARAM = "received";
    private static final String RPORT_PARAM = "rport";
    private String _via;
    private String _protocol;
    private String _transport;
    private String _host;
    private int _port = -1;
    private HashMap<String, String> _params = new HashMap();

    public Via(String via) throws ServletParseException {
        this._via = via;
        this.parse();
    }

    public int getType() {
        return 3;
    }

    private void parse() throws ServletParseException {
        int indexSp = this._via.indexOf(32);
        String s = this._via.substring(0, indexSp);
        int indexTransport = s.lastIndexOf(47);
        this._protocol = s.substring(0, indexTransport);
        this._transport = s.substring(indexTransport + 1);
        while (SipGrammar.isLWS(this._via.charAt(indexSp))) {
            ++indexSp;
        }
        int indexPort = -1;
        if (this._via.charAt(indexSp) == '[') {
            int i = this._via.indexOf(93, indexSp);
            if (i < 0) {
                throw new ServletParseException("Invalid IPv6 in " + this._via);
            }
            indexPort = this._via.indexOf(58, i);
        } else {
            indexPort = this._via.indexOf(58, indexSp);
        }
        int indexParams = this._via.indexOf(59, indexSp);
        if (indexPort > -1 && (indexPort < indexParams || indexParams < 0)) {
            this._host = this._via.substring(indexSp, indexPort);
            String sPort = indexParams < 0 ? this._via.substring(indexPort + 1) : this._via.substring(indexPort + 1, indexParams).trim();
            try {
                this._port = Integer.parseInt(sPort);
            }
            catch (NumberFormatException _) {
                throw new ServletParseException("Invalid port [" + sPort + "] in [" + this._via + "]");
            }
        } else {
            this._port = -1;
            this._host = indexParams < 0 ? this._via.substring(indexSp) : this._via.substring(indexSp, indexParams).trim();
        }
        if (indexParams > 0) {
            this.parseParams(this._via.substring(indexParams + 1));
        }
    }

    private void parseParams(String sParams) throws ServletParseException {
        StringTokenizer st = new StringTokenizer(sParams, ";");
        while (st.hasMoreTokens()) {
            String value;
            String name;
            String param = st.nextToken();
            int index = param.indexOf(61);
            if (index < 0) {
                name = param.trim();
                value = "";
            } else {
                name = param.substring(0, index).trim();
                value = param.substring(index + 1).trim();
            }
            if (!SipGrammar.__param.containsAll(name)) {
                throw new ServletParseException("Invalid parameter name [" + name + "] in [" + this._via + "]");
            }
            if (!SipGrammar.__param.containsAll(value) && !SipGrammar.isToken(value)) {
                throw new ServletParseException("Invalid parameter value [" + value + "] in [" + this._via + "]");
            }
            this._params.put(name.toLowerCase(), value);
        }
    }

    public Via(String protocol, String transport, String host) {
        this(protocol, transport, host, -1);
    }

    public Via(String protocol, String transport, String host, int port) {
        this._protocol = protocol;
        this._transport = transport;
        this._host = host;
        this._port = port;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public String getTransport() {
        return this._transport;
    }

    public void setTransport(String transport) {
        this._transport = transport;
    }

    public String getHost() {
        return this._host;
    }

    public void setHost(String host) {
        this._host = host;
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public String getBranch() {
        return this.getParameter(BRANCH_PARAM);
    }

    public void setBranch(String branch) {
        this.addParameter(BRANCH_PARAM, branch);
    }

    public String getMAddr() {
        return this.getParameter(MADDR_PARAM);
    }

    public String getReceived() {
        return this.getParameter(RECEIVED_PARAM);
    }

    public void setReceived(String received) {
        this.addParameter(RECEIVED_PARAM, received);
    }

    public String getRport() {
        return this.getParameter(RPORT_PARAM);
    }

    public void setRport(String rport) {
        this.addParameter(RPORT_PARAM, rport);
    }

    public void addParameter(String name, String value) {
        this._params.put(name, value);
    }

    public void addParameter(String name) {
        this.addParameter(name, "");
    }

    public String getParameter(String name) {
        return this._params.get(name);
    }

    public Object clone() {
        try {
            Via clone = (Via)super.clone();
            if (this._params != null) {
                clone._params = (HashMap)this._params.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException _) {
            throw new RuntimeException("!cloneable: " + this);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._protocol);
        sb.append('/');
        sb.append(this._transport);
        sb.append(' ');
        sb.append(this._host);
        if (this._port > -1) {
            sb.append(':');
            sb.append(this._port);
        }
        for (String name : this._params.keySet()) {
            String value = this.getParameter(name);
            sb.append(';');
            sb.append(name);
            if (value == null || value.length() <= 0) continue;
            sb.append('=');
            sb.append(value);
        }
        return sb.toString();
    }

    public Buffer toBuffer() {
        return new ByteArrayBuffer(this.toString());
    }
}

