/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sip;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.URI;
import org.cipango.sip.SipGrammar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIImpl
implements URI,
Serializable {
    static final long serialVersionUID = -8927516108461106171L;
    private String _uri;
    private String _scheme;
    private String _file;
    private HashMap<String, String> _params = new HashMap();

    protected URIImpl() {
    }

    public URIImpl(String uri) throws ServletParseException {
        this._uri = uri;
        this.parse();
    }

    private void parse() throws ServletParseException {
        int indexScheme = this._uri.indexOf(58);
        if (indexScheme < 0) {
            throw new ServletParseException("Missing scheme in uri [" + this._uri + "]");
        }
        this._scheme = this._uri.substring(0, indexScheme);
        if (!SipGrammar.isURIScheme(this._scheme)) {
            throw new ServletParseException("Invalid scheme [" + this._scheme + "] in uri [" + this._uri + "]");
        }
        int indexParam = this._uri.indexOf(59, indexScheme);
        if (indexParam < 0) {
            this._file = this._uri.substring(indexScheme + 1);
        } else {
            this._file = this._uri.substring(indexScheme + 1, indexParam);
            String sParams = this._uri.substring(indexParam + 1);
            this.parseParams(sParams);
        }
    }

    private void parseParams(String sParams) throws ServletParseException {
        StringTokenizer st = new StringTokenizer(sParams, ";");
        while (st.hasMoreTokens()) {
            String value;
            String name;
            String param = st.nextToken();
            int index = param.indexOf(61);
            if (index < 0) {
                name = param.trim();
                value = "";
            } else {
                name = param.substring(0, index).trim();
                value = param.substring(index + 1).trim();
            }
            if (!SipGrammar.__param.containsAll(name)) {
                throw new ServletParseException("Invalid parameter name [" + name + "] in [" + this._uri + "]");
            }
            if (!SipGrammar.__param.containsAll(value)) {
                throw new ServletParseException("Invalid parameter value [" + value + "] in [" + this._uri + "]");
            }
            this._params.put(SipGrammar.unescape(name.toLowerCase()), SipGrammar.unescape(value));
        }
    }

    public boolean isSipURI() {
        return false;
    }

    public String getScheme() {
        return this._scheme;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof URI)) {
            return false;
        }
        URI uri = (URI)o;
        if (!this._scheme.equals(uri.getScheme())) {
            return false;
        }
        return this.toString().equals(uri.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public URI clone() {
        try {
            return (URI)super.clone();
        }
        catch (CloneNotSupportedException _) {
            throw new RuntimeException();
        }
    }

    public String toString() {
        if (this._uri != null) {
            return this._uri;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this._scheme).append(":");
        sb.append(this._file);
        Iterator<String> it = this.getParameterNames();
        while (it.hasNext()) {
            String name = it.next();
            String value = this.getParameter(name);
            sb.append(';');
            sb.append(SipGrammar.escape(name, SipGrammar.__param));
            if (value == null || value.length() <= 0) continue;
            sb.append('=');
            sb.append(SipGrammar.escape(value, SipGrammar.__param));
        }
        return sb.toString();
    }

    public String getParameter(String name) {
        return this._params.get(name.toLowerCase());
    }

    public void removeParameter(String name) {
        this._uri = null;
        this._params.remove(name);
    }

    public void setParameter(String name, String value) {
        if (name == null || value == null) {
            throw new NullPointerException("Null value or name");
        }
        this._uri = null;
        this._params.put(name, value);
    }

    public synchronized Iterator<String> getParameterNames() {
        return this._params.keySet().iterator();
    }
}

