/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sip;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.TelURL;
import org.cipango.sip.SipGrammar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TelURLImpl
implements TelURL,
Serializable {
    static final long serialVersionUID = 5887052588082246867L;
    private String _uri;
    private String _scheme;
    private String _number;
    private HashMap<String, String> _params = new HashMap();
    public static final String PHONE_CONTEXT = "phone-context";

    public TelURLImpl(String uri) throws ServletParseException {
        this._uri = uri;
        this.parse();
    }

    private void parse() throws ServletParseException {
        int indexScheme = this._uri.indexOf(58);
        if (indexScheme < 0) {
            throw new ServletParseException("Missing TelURL scheme in [" + this._uri + "]");
        }
        this._scheme = this._uri.substring(0, indexScheme);
        if (!"tel".equals(this._scheme) && !"fax".equals(this._scheme)) {
            throw new ServletParseException("Invalid TelURL scheme [" + this._scheme + "] in [" + this._uri + "]");
        }
        int indexParam = this._uri.indexOf(59, indexScheme);
        if (indexParam < 0) {
            this._number = this._uri.substring(indexScheme + 1);
        } else {
            this._number = this._uri.substring(indexScheme + 1, indexParam);
            if (!SipGrammar.__phoneDigits.containsAll(this.getPhoneNumber())) {
                throw new ServletParseException("Invalid phone number [" + this._number + "] in URI [" + this._uri + "]");
            }
            String sParams = this._uri.substring(indexParam + 1);
            this.parseParams(sParams);
        }
    }

    private void parseParams(String sParams) throws ServletParseException {
        StringTokenizer st = new StringTokenizer(sParams, ";");
        while (st.hasMoreTokens()) {
            String value;
            String name;
            String param = st.nextToken();
            int index = param.indexOf(61);
            if (index < 0) {
                name = param.trim();
                value = "";
            } else {
                name = param.substring(0, index).trim();
                value = param.substring(index + 1).trim();
            }
            if (!SipGrammar.__param.containsAll(name)) {
                throw new ServletParseException("Invalid parameter name [" + name + "] in [" + this._uri + "]");
            }
            if (!SipGrammar.__param.containsAll(value)) {
                throw new ServletParseException("Invalid parameter value [" + value + "] in [" + this._uri + "]");
            }
            this._params.put(SipGrammar.unescape(name.toLowerCase()), SipGrammar.unescape(value));
        }
    }

    public boolean isSipURI() {
        return false;
    }

    public boolean isGlobal() {
        return this._number.startsWith("+");
    }

    public String getPhoneNumber() {
        if (this._number == null) {
            return null;
        }
        if (this.isGlobal()) {
            return this._number.substring(1);
        }
        return this._number;
    }

    public void setPhoneNumber(String number) {
        String n;
        if (!number.startsWith("+")) {
            throw new IllegalArgumentException("Not a global number: " + number);
        }
        String string = n = number.startsWith("+") ? number.substring(1) : number;
        if (!SipGrammar.__phoneDigits.containsAll(n)) {
            throw new IllegalArgumentException("Invalid phone number [" + number + "]");
        }
        this._number = number;
    }

    public void setPhoneNumber(String number, String phoneContext) {
        if (number.startsWith("+")) {
            throw new IllegalArgumentException("Not a local number: " + number);
        }
        if (!SipGrammar.__phoneDigits.containsAll(number)) {
            throw new IllegalArgumentException("Invalid phone number [" + number + "]");
        }
        this._number = number;
        this.setParameter(PHONE_CONTEXT, phoneContext);
    }

    public String getPhoneContext() {
        return this.getParameter(PHONE_CONTEXT);
    }

    public String getScheme() {
        return this._scheme;
    }

    public String getParameter(String name) {
        return this._params.get(name.toLowerCase());
    }

    public void removeParameter(String name) {
        this._params.remove(name);
    }

    public void setParameter(String name, String value) {
        if (name == null || value == null) {
            throw new NullPointerException("Null value or name");
        }
        this._params.put(name, value);
    }

    public synchronized Iterator<String> getParameterNames() {
        return this._params.keySet().iterator();
    }

    public TelURL clone() {
        TelURLImpl other;
        try {
            other = (TelURLImpl)super.clone();
        }
        catch (CloneNotSupportedException _) {
            throw new RuntimeException("!cloneable " + this);
        }
        other._params = (HashMap)this._params.clone();
        return other;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._scheme);
        sb.append(':');
        sb.append(this._number);
        Iterator<String> it = this.getParameterNames();
        while (it.hasNext()) {
            String name = it.next();
            String value = this.getParameter(name);
            sb.append(';');
            sb.append(SipGrammar.escape(name, SipGrammar.__param));
            if (value == null || value.length() <= 0) continue;
            sb.append('=');
            sb.append(SipGrammar.escape(value, SipGrammar.__param));
        }
        return sb.toString();
    }

    protected String removeVisualChar(String number) {
        return number.replaceAll("[-\\.\\(\\)]", "");
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof TelURL)) {
            return false;
        }
        TelURL other = (TelURL)o;
        if (!this._scheme.equals(other.getScheme())) {
            return false;
        }
        if (!this.removeVisualChar(this.getPhoneNumber()).equals(this.removeVisualChar(other.getPhoneNumber()))) {
            return false;
        }
        if (this.isGlobal() != other.isGlobal()) {
            return false;
        }
        for (String key : this._params.keySet()) {
            String otherValue = other.getParameter(key);
            if (otherValue == null || this.getParameter(key).equalsIgnoreCase(otherValue)) continue;
            return false;
        }
        return true;
    }
}

