/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sip;

import java.io.IOException;
import org.cipango.sip.BufferOverflowException;
import org.cipango.sip.SipException;
import org.cipango.sip.SipHeaders;
import org.cipango.sip.SipMethods;
import org.cipango.sip.SipVersions;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.BufferCache;
import org.eclipse.jetty.io.BufferUtil;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.View;
import org.eclipse.jetty.util.log.Log;

public class SipParser {
    private static final int STATE_START = -9;
    private static final int STATE_CR = -10;
    private static final int STATE_FIELD0 = -8;
    private static final int STATE_SPACE0 = -7;
    private static final int STATE_FIELD1 = -6;
    private static final int STATE_SPACE1 = -5;
    private static final int STATE_FIELD2 = -4;
    private static final int STATE_HEADER = -3;
    private static final int STATE_HEADER_NAME = -2;
    private static final int STATE_HEADER_VALUE = -1;
    private static final int STATE_END = 0;
    private static final int STATE_EOF_CONTENT = 1;
    private static final int STATE_CONTENT = 2;
    private static final int UNKNOWN_CONTENT = -1;
    private static final int NO_CONTENT = 0;
    private Buffer _buffer;
    private Buffer _header;
    private Buffer _body;
    private BufferCache.CachedBuffer _cached;
    private EndPoint _endpoint;
    private int _state = -9;
    private byte _eol;
    private EventHandler _handler;
    private View _token0;
    private View _token1;
    private View contentView = new View();
    private int _length;
    private boolean _response;
    private int headerBufferSize = 10240;
    private int contentBufferSize = 10240;
    private String _multiline;
    private int _contentLength;
    private int _contentPosition;
    private int _streamDefaultHeaderSize = 5120;
    private int _streamMaxHeaderSize = 512000;

    public SipParser(Buffer buffer, EventHandler handler) {
        this._buffer = buffer;
        this._handler = handler;
        if (buffer != null) {
            this._token0 = new View(buffer);
            this._token1 = new View(buffer);
            this._token0.setPutIndex(this._token0.getIndex());
            this._token1.setPutIndex(this._token1.getIndex());
        }
    }

    public SipParser(Buffer buffer, EndPoint endpoint, EventHandler handler) {
        this._buffer = buffer;
        this._token0 = new View(this._buffer);
        this._token1 = new View(this._buffer);
        this._token0.setPutIndex(this._token0.getIndex());
        this._token1.setPutIndex(this._token1.getIndex());
        this._endpoint = endpoint;
        this._handler = handler;
    }

    public int getState() {
        return this._state;
    }

    public void parse() throws IOException {
        if (this._state == 0) {
            this.setBuffer(this._buffer);
        }
        if (this._state != -9) {
            throw new IllegalStateException("!STATE_START (" + this._state + ")");
        }
        while (this._state != 0) {
            this.parseNext();
        }
    }

    public int parseNext() throws IOException {
        int totalFilled = -1;
        if (this._buffer == null) {
            throw new IOException("No buffer");
        }
        if (this._state == 0) {
            throw new IllegalStateException("STATE_END");
        }
        if (this._state == 2 && this._contentPosition == this._contentLength) {
            this._state = 0;
            return totalFilled;
        }
        int length = this._buffer.length();
        if (length == 0) {
            int filled = -1;
            if (this._buffer.markIndex() == 0 && this._buffer.putIndex() == this._buffer.capacity()) {
                throw new BufferOverflowException("FULL");
            }
            if (this._endpoint != null && filled <= 0) {
                if (this._buffer.space() == 0) {
                    throw new BufferOverflowException("FULL");
                }
                try {
                    if (totalFilled < 0) {
                        totalFilled = 0;
                    }
                    if ((filled = this._endpoint.fill(this._buffer)) > 0) {
                        totalFilled += filled;
                    }
                }
                catch (IOException e) {
                    Log.debug((Throwable)e);
                    throw e instanceof EofException ? e : new EofException((Throwable)e);
                }
            }
            if (filled < 0) {
                if (this._state == 1) {
                    this._state = 0;
                    this._handler.content(this._buffer.sliceFromMark(this._contentPosition));
                    return totalFilled;
                }
                throw new EofException();
            }
            length = this._buffer.length();
        }
        byte[] array = this._buffer.array();
        while (this._state < 0 && length-- > 0) {
            byte b = this._buffer.get();
            if (this._eol == 13 && b == 10) {
                this._eol = (byte)10;
                continue;
            }
            this._eol = 0;
            switch (this._state) {
                case -9: {
                    this._contentLength = -1;
                    this._cached = null;
                    if (b == 13 && this._endpoint != null) {
                        this._state = -10;
                    }
                    if (b >= 0 && b <= 32) break;
                    this._buffer.mark();
                    this._state = -8;
                    break;
                }
                case -10: {
                    if (b == 10) {
                        this._handler.keepAlive();
                        this._state = 0;
                        break;
                    }
                    this._state = -9;
                    break;
                }
                case -8: {
                    if (b == 32) {
                        this._token0.update(this._buffer.markIndex(), this._buffer.getIndex() - 1);
                        this._state = -7;
                        break;
                    }
                    if (b < 0 || b >= 32) break;
                    throw new SipException(400);
                }
                case -7: {
                    if (b < 0 || b > 32) {
                        this._buffer.mark();
                        this._state = -6;
                        this._response = b >= 49 && b <= 54;
                        break;
                    }
                    if (b >= 32) break;
                    throw new SipException(400);
                }
                case -6: {
                    if (b != 32) break;
                    this._token1.update(this._buffer.markIndex(), this._buffer.getIndex() - 1);
                    this._state = -5;
                    break;
                }
                case -5: {
                    if (b < 0 || b > 32) {
                        this._buffer.mark();
                        this._state = -4;
                        break;
                    }
                    if (b >= 32) break;
                    this._state = -4;
                    this._buffer.mark(0);
                    break;
                }
                case -4: {
                    if (b != 13 && b != 10) break;
                    if (this._response) {
                        this._handler.startResponse(SipVersions.CACHE.lookup((Buffer)this._token0), BufferUtil.toInt((Buffer)this._token1), this._buffer.sliceFromMark());
                    } else {
                        this._handler.startRequest(SipMethods.CACHE.lookup((Buffer)this._token0), (Buffer)this._token1, SipVersions.CACHE.lookup(this._buffer.sliceFromMark()));
                    }
                    this._eol = b;
                    this._state = -3;
                    this._token0.setPutIndex(this._token0.getIndex());
                    this._token1.setPutIndex(this._token1.getIndex());
                    this._multiline = null;
                    return totalFilled;
                }
                case -3: {
                    if (b == 58 || b == 32 || b == 9) {
                        this._length = -1;
                        this._state = -1;
                        break;
                    }
                    if (this._cached != null || this._token0.length() > 0 || this._token1.length() > 0 || this._multiline != null) {
                        BufferCache.CachedBuffer name = null;
                        if (this._cached != null) {
                            name = this._cached;
                            this._cached = null;
                        } else if (this._token0.length() == 1) {
                            name = SipHeaders.getCompact(this._token0.peek());
                            if (name == null) {
                                name = SipHeaders.CACHE.lookup((Buffer)this._token0);
                            }
                        } else {
                            name = SipHeaders.CACHE.lookup((Buffer)this._token0);
                        }
                        View value = this._multiline == null ? this._token1 : new ByteArrayBuffer(this._multiline);
                        int ho = SipHeaders.CACHE.getOrdinal((Buffer)name);
                        if (ho == 17) {
                            this._contentLength = BufferUtil.toInt((Buffer)value);
                            if (this._contentLength <= 0) {
                                this._contentLength = 0;
                            }
                        }
                        this._handler.header((Buffer)name, (Buffer)value);
                        this._token0.setPutIndex(this._token0.getIndex());
                        this._token1.setPutIndex(this._token1.getIndex());
                        this._multiline = null;
                    }
                    if (b == 13 || b == 10) {
                        this._eol = b;
                        this._contentPosition = 0;
                        this._buffer.mark(0);
                        if (this._contentLength == -1) {
                            if (this._endpoint != null) {
                                throw new IOException("No Content-Length");
                            }
                            this._state = 1;
                        } else {
                            this._state = this._contentLength == 0 ? 0 : 2;
                        }
                        return totalFilled;
                    }
                    this._buffer.mark();
                    this._length = 1;
                    this._state = -2;
                    if (array != null) {
                        this._cached = SipHeaders.CACHE.getBest(array, this._buffer.markIndex(), length + 1);
                    }
                    if (this._cached == null) break;
                    this._length = this._cached.length();
                    this._buffer.setGetIndex(this._buffer.markIndex() + this._length);
                    length = this._buffer.length();
                    break;
                }
                case -2: {
                    if (b == 13 || b == 10) {
                        if (this._length > 0) {
                            this._token0.update(this._buffer.markIndex(), this._buffer.markIndex() + this._length);
                        }
                        this._eol = b;
                        this._state = -3;
                    }
                    if (b == 58) {
                        if (this._length > 0) {
                            this._token0.update(this._buffer.markIndex(), this._buffer.markIndex() + this._length);
                        }
                        this._length = -1;
                        this._state = -1;
                        break;
                    }
                    if (b == 32 || b == 9) break;
                    if (this._length == -1) {
                        this._buffer.mark();
                    }
                    this._length = this._buffer.getIndex() - this._buffer.markIndex();
                    break;
                }
                case -1: {
                    if (b == 13 || b == 10) {
                        if (this._length > 0) {
                            if (this._token1.length() == 0) {
                                this._token1.update(this._buffer.markIndex(), this._buffer.markIndex() + this._length);
                            } else {
                                if (this._multiline == null) {
                                    this._multiline = this._token1.toString();
                                }
                                this._token1.update(this._buffer.markIndex(), this._buffer.markIndex() + this._length);
                                this._multiline = this._multiline + " " + this._token1.toString();
                            }
                        }
                        this._eol = b;
                        this._state = -3;
                        break;
                    }
                    if (b == 32 || b == 9) break;
                    if (this._length == -1) {
                        this._buffer.mark();
                    }
                    this._length = this._buffer.getIndex() - this._buffer.markIndex();
                }
            }
        }
        length = this._buffer.length();
        while (this._state > 0 && length > 0) {
            if (this._eol == 13 && this._buffer.peek() == 10) {
                this._eol = this._buffer.get();
                length = this._buffer.length();
                this._contentPosition = 0;
                this._buffer.mark(0);
                continue;
            }
            this._eol = 0;
            switch (this._state) {
                case 1: {
                    Buffer chunk = this._buffer.get(this._buffer.length());
                    this._contentPosition += chunk.length();
                    return totalFilled;
                }
                case 2: {
                    int remaining = this._contentLength - this._contentPosition;
                    if (remaining == 0) {
                        this._state = 0;
                    } else if (length >= remaining) {
                        length = remaining;
                        this._state = 0;
                    }
                    this._contentPosition += length;
                    this._buffer.get(length);
                    if (this._state == 0) {
                        this._handler.content(this._buffer.sliceFromMark(this._contentPosition));
                    }
                    return totalFilled;
                }
            }
        }
        return totalFilled;
    }

    public void setBuffer(Buffer buffer) {
        this.setBuffer(buffer, false);
    }

    public void setBuffer(Buffer buffer, boolean all) {
        this._state = -9;
        this._contentLength = -1;
        this._contentPosition = 0;
        this._length = 0;
        this._response = false;
        if (this._buffer != null && this._buffer.length() > 0 && this._eol == 13 && this._buffer.peek() == 10) {
            this._buffer.skip(1);
            this._eol = (byte)10;
        }
        if (this._endpoint != null && this._buffer != null) {
            if (all) {
                this._buffer.setGetIndex(0);
            }
            buffer.put(this._buffer);
        }
        this._buffer = buffer;
        if (this._token0 == null) {
            this._token0 = new View(this._buffer);
        }
        this._token0.update(this._buffer);
        this._token0.update(0, 0);
        if (this._token1 == null) {
            this._token1 = new View(this._buffer);
        }
        this._token1.update(this._buffer);
        this._token1.update(0, 0);
    }

    public static class EventHandler {
        public void startRequest(Buffer method, Buffer uri, Buffer version) throws IOException {
        }

        public void startResponse(Buffer version, int status, Buffer reason) throws IOException {
        }

        public void header(Buffer name, Buffer value) throws IOException {
        }

        public void content(Buffer content) throws IOException {
        }

        public void keepAlive() throws IOException {
        }
    }
}

