/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sip;

import org.cipango.sip.SipCharset;
import org.cipango.util.HexString;

public class SipGrammar {
    public static final byte CR = 13;
    public static final byte LF = 10;
    public static final byte TAB = 9;
    public static final byte SPACE = 32;
    public static final byte COLON = 58;
    public static final byte[] CRLF = new byte[]{13, 10};
    public static final String MAGIC_COOKIE = "z9hG4bK";
    private static final String ALPHA = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String DIGITS = "0123456789";
    private static final String HNV_UNRESERVED = "[]/?:+$";
    private static final String LWS = " \r\n\t";
    private static final String MARK = "-_.!~*'()";
    private static final String PARAM_UNRESERVED = "[]/:&+$";
    private static final String PASSWD_UNRESERVED = "&=+$,";
    private static final String TOKEN = "-.!%*_+`'~";
    private static final String UNRESERVED = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.!~*'()";
    private static final String USER_UNRESERVED = "&=+$,;?/";
    public static final SipCharset __alpha = new SipCharset("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ");
    public static final SipCharset __alphaNum = new SipCharset("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789");
    public static final SipCharset __scheme = new SipCharset("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+-.");
    public static final SipCharset __token = new SipCharset("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-.!%*_+`'~");
    public static final SipCharset __lws = new SipCharset(" \r\n\t");
    public static final SipCharset __param = new SipCharset("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.!~*'()[]/:&+$%");
    public static final SipCharset __header = new SipCharset("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.!~*'()[]/?:+$%");
    public static final SipCharset __user = new SipCharset("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.!~*'()&=+$,;?/%");
    public static final SipCharset __host = new SipCharset("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.-[]:");
    public static final SipCharset __passwd = new SipCharset("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.!~*'()&=+$,%");
    public static final SipCharset __phoneDigits = new SipCharset("0123456789-.()");

    public static final boolean isURIScheme(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        if (!__alpha.contains(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            if (__scheme.contains(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static final boolean isToken(String s) {
        if (s.length() == 0) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (__token.contains(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static final boolean isTokens(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (__token.contains(c) || __lws.contains(c)) continue;
            return false;
        }
        return true;
    }

    public static final boolean isLWS(int c) {
        return __lws.contains(c);
    }

    public static final String escape(String s, SipCharset charset) {
        StringBuffer escaped = null;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (charset.contains(c) && c != '%') {
                if (escaped == null) continue;
                escaped.append(c);
                continue;
            }
            if (escaped == null) {
                escaped = new StringBuffer(s.length() + 6);
                escaped.append(s.substring(0, i));
            }
            escaped.append('%');
            escaped.append(SipGrammar.toHex(c));
        }
        return escaped != null ? escaped.toString() : s;
    }

    private static String toHex(int c) {
        String s = Integer.toString(c, 16).toUpperCase();
        if (c > 15) {
            return s;
        }
        return "0" + s;
    }

    public static String unescape(String s) {
        StringBuffer unescaped = null;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '%') {
                int c2;
                try {
                    c2 = Integer.parseInt(s.substring(i + 1, i + 3), 16);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid escaped char at " + i + "in [" + s + "]");
                }
                if (unescaped == null) {
                    unescaped = new StringBuffer(s.length() - 2);
                    unescaped.append(s.substring(0, i));
                }
                unescaped.append((char)c2);
                i += 2;
                continue;
            }
            if (unescaped == null) continue;
            unescaped.append(c);
        }
        return unescaped != null ? unescaped.toString() : s;
    }

    public static String escapeQuoted(String s) {
        StringBuffer escaped = null;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"' || c == '\\') {
                if (escaped == null) {
                    escaped = new StringBuffer(s.length() + 2);
                    escaped.append(s.substring(0, i));
                }
                escaped.append('\\');
            }
            if (escaped == null) continue;
            escaped.append(c);
        }
        return escaped != null ? escaped.toString() : s;
    }

    public static String unquote(String s) {
        if (s != null && s.startsWith("\"") && s.endsWith("\"")) {
            s = s.substring(1, s.length() - 1);
            StringBuffer unescaped = null;
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == '\\') {
                    char c2;
                    try {
                        c2 = s.charAt(i + 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Invalid escaped char at " + i + "in [" + s + "]");
                    }
                    if (unescaped == null) {
                        unescaped = new StringBuffer(s.length() - 1);
                        unescaped.append(s.substring(0, i));
                    }
                    unescaped.append(c2);
                    ++i;
                    continue;
                }
                if (unescaped == null) continue;
                unescaped.append(c);
            }
            return unescaped != null ? unescaped.toString() : s;
        }
        return s;
    }

    public static String toHexString(int c) {
        StringBuffer buf = new StringBuffer();
        HexString.appendHex(buf, c);
        return buf.toString();
    }
}

