/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sip;

import java.util.Iterator;
import javax.servlet.sip.SipServletMessage;
import org.cipango.server.SipMessage;
import org.cipango.server.SipRequest;
import org.cipango.server.SipResponse;
import org.cipango.sip.SipFields;
import org.cipango.sip.SipGrammar;
import org.cipango.sip.SipHeaders;
import org.cipango.sip.SipMethods;
import org.cipango.sip.SipStatus;
import org.cipango.sip.SipVersions;
import org.eclipse.jetty.io.Buffer;

public class SipGenerator {
    public static final int STATE_START_LINE = 0;
    public static final int STATE_HEADER = 1;
    public static final int STATE_CONTENT = 2;
    public static final String UNKNOWN_REASON = "Unknown";
    private static byte[] SERVER = "Server: cipango(2.0.x)\r\n".getBytes();
    private static byte[] USER_AGENT = "User-Agent: cipango(2.0.x)\r\n".getBytes();
    private static byte[] CONTENT_LENGTH_0 = "Content-Length: 0\r\n".getBytes();
    private static byte[] CONTENT_LENGTH_0_COMPACT = "l: 0\r\n".getBytes();

    public static void setServerVersion(String version) {
        SERVER = new String("Server: cipango(" + version + ")\r\n").getBytes();
        USER_AGENT = new String("User-Agent: cipango(" + version + ")\r\n").getBytes();
    }

    public void generate(Buffer buffer, SipMessage message) {
        if (message.isRequest()) {
            this.generateRequest(buffer, (SipRequest)message);
        } else {
            this.generateResponse(buffer, (SipResponse)message);
        }
    }

    public void generateRequest(Buffer buffer, SipRequest request) {
        buffer.put(SipMethods.CACHE.lookup(request.getMethod()));
        buffer.put((byte)32);
        byte[] b = request.getRequestURIAsString().getBytes();
        buffer.put(b, 0, b.length);
        buffer.put((byte)32);
        buffer.put((Buffer)SipVersions.SIP_2_0_BUFFER);
        buffer.put(SipGrammar.CRLF);
        this.generateHeader(buffer, request.getFields(), false, request.getHeaderForm());
        if (request.getRawContent() != null) {
            buffer.put(request.getRawContent());
        }
    }

    public void generateResponse(Buffer buffer, SipResponse response) {
        int status = response.getStatus();
        String reason = response.getReason();
        Buffer line = SipStatus.getResponseLine(status);
        if (line != null && reason == null) {
            buffer.put(line);
        } else {
            if (reason == null) {
                reason = UNKNOWN_REASON;
            }
            if (line == null) {
                buffer.put((Buffer)SipVersions.SIP_2_0_BUFFER);
                buffer.put((byte)32);
                buffer.put((byte)(48 + status / 100));
                buffer.put((byte)(48 + status % 100 / 10));
                buffer.put((byte)(48 + status % 10));
                buffer.put((byte)32);
                byte[] r = reason.getBytes();
                buffer.put(r, 0, r.length);
                buffer.put(SipGrammar.CRLF);
            } else {
                buffer.put(line.array(), 0, SipVersions.SIP_2_0_BUFFER.length() + 5);
                byte[] r = reason.getBytes();
                buffer.put(r, 0, r.length);
                buffer.put(SipGrammar.CRLF);
            }
        }
        this.generateHeader(buffer, response.getFields(), true, response.getHeaderForm());
        if (response.getRawContent() != null) {
            buffer.put(response.getRawContent());
        }
    }

    protected void generateHeader(Buffer buffer, SipFields fields, boolean response, SipServletMessage.HeaderForm form) {
        long contentLength = -1L;
        if (fields != null) {
            Iterator<SipFields.Field> it = fields.getFields();
            while (it.hasNext()) {
                SipFields.Field field = it.next();
                switch (field.getNameOrdinal()) {
                    case 17: {
                        contentLength = field.getLong();
                    }
                }
                boolean merge = false;
                if (field.getNameOrdinal() != -1) {
                    merge = SipHeaders.__types[field.getNameOrdinal()].isMerge();
                }
                SipFields.put(field, buffer, form, merge);
            }
        }
        if (contentLength == -1L) {
            if (form == SipServletMessage.HeaderForm.COMPACT) {
                buffer.put(CONTENT_LENGTH_0_COMPACT);
            } else {
                buffer.put(CONTENT_LENGTH_0);
            }
        }
        buffer.put(SipGrammar.CRLF);
    }
}

