/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sip;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.servlet.sip.Address;
import javax.servlet.sip.Parameterable;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipServletMessage;
import org.cipango.sip.CSeq;
import org.cipango.sip.LazyParsingException;
import org.cipango.sip.NameAddr;
import org.cipango.sip.ParameterableImpl;
import org.cipango.sip.SipHeaders;
import org.cipango.sip.Via;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.BufferCache;
import org.eclipse.jetty.io.BufferUtil;
import org.eclipse.jetty.io.View;
import org.eclipse.jetty.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SipFields
implements Cloneable {
    private Map<Buffer, Field> _fields = new LinkedHashMap<Buffer, Field>();

    public static List qualityList(final Iterator it) {
        return HttpFields.qualityList((Enumeration)new Enumeration(){

            public boolean hasMoreElements() {
                return it.hasNext();
            }

            public Object nextElement() {
                return it.next();
            }
        });
    }

    public void addAddress(Buffer name, Address value, boolean first) {
        this.add(name, value, first);
    }

    public void addAddress(String name, Address value, boolean first) {
        this.addAddress(SipHeaders.CACHE.lookup(name), value, first);
    }

    public void addParameterable(Buffer name, Parameterable value, boolean first) {
        this.add(name, value, first);
    }

    public void addParameterable(String name, Parameterable value, boolean first) {
        this.addParameterable(SipHeaders.CACHE.lookup(name), value, first);
    }

    public void addString(Buffer name, String value) {
        this.add(name, value, false);
    }

    public void addString(String name, String value) {
        this.add(SipHeaders.CACHE.lookup(name), value, false);
    }

    public void addVia(Via via, boolean first) {
        this.add((Buffer)SipHeaders.VIA_BUFFER, via, first);
    }

    public void addBuffer(Buffer name, Buffer value) {
        if (!(name instanceof BufferCache.CachedBuffer)) {
            name = SipHeaders.CACHE.lookup(name);
        }
        Field field = this._fields.get(name);
        Field f = new Field(name, value);
        if (field == null) {
            this._fields.put(f.getName(), f);
        } else {
            while (field._next != null) {
                field = field._next;
            }
            field._next = f;
        }
    }

    protected void add(Buffer name, Object value, boolean first) {
        if (!(name instanceof BufferCache.CachedBuffer)) {
            name = SipHeaders.CACHE.lookup(name);
        }
        Field field = this._fields.get(name);
        Field f = new Field(name, value, 0);
        if (field == null) {
            this._fields.put(f.getName(), f);
        } else if (first) {
            f._next = field;
            this._fields.put(f.getName(), f);
        } else {
            while (field._next != null) {
                field = field._next;
            }
            field._next = f;
        }
    }

    protected Field getField(Buffer name) {
        return this._fields.get(name);
    }

    public Address getAddress(Buffer name) {
        Field field = this.getField(name);
        if (field != null) {
            return field.getAddress();
        }
        return null;
    }

    public Address getAddress(String name) {
        return this.getAddress(SipHeaders.CACHE.lookup(name));
    }

    public long getLong(Buffer name) {
        Field field = this.getField(name);
        if (field != null) {
            return field.getLong();
        }
        return -1L;
    }

    public long getLong(String name) {
        return this.getLong(SipHeaders.CACHE.lookup(name));
    }

    public Parameterable getParameterable(Buffer name) {
        Field field = this.getField(name);
        if (field != null) {
            return field.getParameterable();
        }
        return null;
    }

    public Parameterable getParameterable(String name) {
        return this.getParameterable(SipHeaders.CACHE.lookup(name));
    }

    public String getString(String name) {
        return this.getString(SipHeaders.CACHE.lookup(name));
    }

    public String getString(Buffer name) {
        Field field = this.getField(name);
        if (field != null) {
            return field.getString();
        }
        return null;
    }

    public Via getVia() {
        Field field = this._fields.get(SipHeaders.VIA_BUFFER);
        if (field != null) {
            return field.getVia();
        }
        return null;
    }

    public CSeq getCSeq() throws ServletParseException {
        Field field = this._fields.get(SipHeaders.CSEQ_BUFFER);
        if (field != null) {
            return new CSeq(field.getString());
        }
        return null;
    }

    public ListIterator<String> getValues(Buffer name) {
        Field field = this.getField(name);
        return new FieldIterator<String>(field){

            @Override
            public String getValue() {
                return this._f.getString();
            }
        };
    }

    public ListIterator<String> getValues(String name) {
        return this.getValues(SipHeaders.CACHE.lookup(name));
    }

    public ListIterator<Address> getAddressValues(Buffer name) {
        Field field = this.getField(name);
        return new FieldIterator<Address>(field){

            @Override
            public Address getValue() {
                return this._f.getAddress();
            }
        };
    }

    public ListIterator<Address> getAddressValues(String name) {
        return this.getAddressValues(SipHeaders.CACHE.lookup(name));
    }

    public ListIterator<Parameterable> getParameterableValues(Buffer name) {
        Field field = this.getField(name);
        return new FieldIterator<Parameterable>(field){

            @Override
            public Parameterable getValue() {
                return this._f.getParameterable();
            }
        };
    }

    public Iterator<Parameterable> getParameterableValues(String name) {
        return this.getParameterableValues(SipHeaders.CACHE.lookup(name));
    }

    public Iterator<String> getNames() {
        final Iterator<Buffer> it = this._fields.keySet().iterator();
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public String next() {
                return ((Buffer)it.next()).toString();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void remove(Buffer name) {
        this._fields.remove(name);
    }

    public void remove(String name) {
        this._fields.remove(SipHeaders.CACHE.lookup(name));
    }

    public void removeFirst(Buffer name) {
        Field f = this.getField(name);
        if (f == null) {
            return;
        }
        Field next = f._next;
        if (next != null) {
            this._fields.put(next.getName(), next);
        } else {
            this._fields.remove(f.getName());
        }
    }

    public void setAddress(Buffer name, Address value) {
        this.set(name, value);
    }

    public void setAddress(String name, Address value) {
        this.set(SipHeaders.CACHE.lookup(name), value);
    }

    public void setParameterable(Buffer name, Parameterable parameterable) {
        this.set(name, parameterable);
    }

    public void setParameterable(String name, Parameterable parameterable) {
        this.set(SipHeaders.CACHE.lookup(name), parameterable);
    }

    public void setString(Buffer name, String value) {
        this.set(name, value);
    }

    public void setString(String name, String value) {
        this.set(SipHeaders.CACHE.lookup(name), value);
    }

    protected void set(Buffer name, Object value) {
        if (!(name instanceof BufferCache.CachedBuffer)) {
            name = SipHeaders.CACHE.lookup(name);
        }
        Field field = new Field(name, value, 0);
        this._fields.put(field.getName(), field);
    }

    public SipFields clone() {
        SipFields clone = null;
        try {
            clone = (SipFields)super.clone();
        }
        catch (CloneNotSupportedException _) {
            // empty catch block
        }
        clone._fields = new HashMap<Buffer, Field>();
        for (Field field : this._fields.values()) {
            Field f = SipFields.clone(field);
            clone._fields.put(f.getName(), f);
        }
        return clone;
    }

    public void copy(SipFields other, Buffer name) {
        Field field = other.getField(name);
        if (field != null) {
            Field f = SipFields.clone(field);
            this._fields.put(f._name, f);
        }
    }

    private static Field clone(Field field) {
        Field first = null;
        Field previous = null;
        while (field != null) {
            Field f = new Field(field._name);
            f._bvalue = field._bvalue;
            Object value = field._value;
            if (value != null) {
                if (value instanceof Address) {
                    f._value = ((Address)value).clone();
                } else if (value instanceof Via) {
                    f._value = ((Via)value).clone();
                } else if (value instanceof Parameterable) {
                    f._value = ((Parameterable)value).clone();
                } else if (value instanceof String) {
                    f._value = value;
                } else {
                    throw new RuntimeException("unexpected type: " + value.getClass());
                }
            }
            if (previous != null) {
                previous._next = f;
            } else {
                first = f;
            }
            field = field._next;
            previous = f;
        }
        return first;
    }

    public static void put(Field field, Buffer buffer, SipServletMessage.HeaderForm form, boolean merge) {
        Buffer name;
        switch (form) {
            case COMPACT: {
                name = SipHeaders.getCompact(field.getName());
                break;
            }
            default: {
                name = field.getName();
            }
        }
        buffer.put(name);
        buffer.put((byte)58);
        buffer.put((byte)32);
        boolean first = true;
        while (field != null) {
            if (first) {
                first = false;
            } else if (merge) {
                buffer.put((byte)44);
            } else {
                BufferUtil.putCRLF((Buffer)buffer);
                buffer.put(name);
                buffer.put((byte)58);
                buffer.put((byte)32);
            }
            if (field._bvalue != null) {
                buffer.put(field._bvalue);
            } else {
                try {
                    buffer.put(field._value.toString().getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException _) {
                    // empty catch block
                }
            }
            field = field._next;
        }
        BufferUtil.putCRLF((Buffer)buffer);
    }

    public Iterator<Field> getFields() {
        return this._fields.values().iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class FieldIterator<E>
    implements ListIterator<E> {
        Field _f;
        Field _first;
        int _index = 0;

        public FieldIterator(Field field) {
            this._f = field;
            this._first = field;
        }

        @Override
        public boolean hasNext() {
            return this._f != null;
        }

        @Override
        public E next() {
            if (this._f == null) {
                throw new NoSuchElementException();
            }
            E value = this.getValue();
            this._f = this._f._next;
            ++this._index;
            return value;
        }

        public abstract E getValue();

        @Override
        public boolean hasPrevious() {
            return this._index > 0;
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            --this._index;
            this._f = this._first;
            for (int i = 0; i < this._index; ++i) {
                this._f = this._f._next;
            }
            return this.getValue();
        }

        @Override
        public int nextIndex() {
            return this._index;
        }

        @Override
        public int previousIndex() {
            return this._index - 1;
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class Field {
        private Field _next;
        private Buffer _name;
        private Buffer _bvalue;
        private Object _value;

        public Field(Buffer name, Buffer value) {
            this._name = name;
            this._bvalue = value.isReadOnly() ? value : new View(value);
        }

        public Field(Buffer name, Object value, int type) {
            this._name = name;
            this._value = value;
        }

        private Field(Buffer name) {
            this._name = name;
        }

        public Buffer getName() {
            return this._name;
        }

        public int getNameOrdinal() {
            return SipHeaders.CACHE.getOrdinal(this._name);
        }

        public String getString() {
            if (this._value == null) {
                this._value = StringUtil.toUTF8String((byte[])this._bvalue.array(), (int)this._bvalue.getIndex(), (int)this._bvalue.length());
            }
            return this._value.toString();
        }

        public Address getAddress() {
            if (!(this._value instanceof Address)) {
                try {
                    this._value = new NameAddr(this.getString());
                    this._bvalue = null;
                }
                catch (ServletParseException e) {
                    throw new LazyParsingException((Exception)((Object)e));
                }
            }
            return (Address)this._value;
        }

        public Parameterable getParameterable() {
            if (!(this._value instanceof Parameterable)) {
                try {
                    this._value = new ParameterableImpl(this.getString());
                    this._bvalue = null;
                }
                catch (ServletParseException e) {
                    throw new LazyParsingException((Exception)((Object)e));
                }
            }
            return (Parameterable)this._value;
        }

        public Via getVia() {
            if (!(this._value instanceof Via)) {
                try {
                    this._value = new Via(this.getString());
                    this._bvalue = null;
                }
                catch (ServletParseException e) {
                    throw new LazyParsingException((Exception)((Object)e));
                }
            }
            return (Via)this._value;
        }

        public long getLong() {
            if (this._bvalue != null) {
                return BufferUtil.toLong((Buffer)this._bvalue);
            }
            return Long.parseLong(this._value.toString());
        }
    }
}

