/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sip;

public class SipCharset {
    private long[] _charset = new long[4];

    public SipCharset() {
    }

    public SipCharset(String charset) {
        this.set(charset);
    }

    public void set(int c) {
        int n = c >> 6;
        this._charset[n] = this._charset[n] | this.bit(c);
    }

    public void set(int start, int end) {
        for (int i = start; i <= end; ++i) {
            this.set(i);
        }
    }

    public void set(String s) {
        for (int i = 0; i < s.length(); ++i) {
            this.set(s.charAt(i));
        }
    }

    private final long bit(int c) {
        return 1L << (c & 0x3F);
    }

    public final boolean contains(int c) {
        int index = c >> 6;
        if (index > 3) {
            return false;
        }
        return (this._charset[index] & this.bit(c)) != 0L;
    }

    public final boolean containsAll(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (this.contains(s.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

