/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sip;

import javax.servlet.sip.ServletParseException;
import org.cipango.sip.SipGrammar;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;

public class RAck
implements Cloneable {
    private long _rseq;
    private long _number;
    private String _method;
    private String _rack;

    public RAck(String rack) throws ServletParseException {
        this._rack = rack;
        this.parse();
    }

    private void parse() throws ServletParseException {
        int index = this.skipSpaces(0);
        int index2 = this._rack.indexOf(32, index);
        if (index2 < 0) {
            throw new ServletParseException("Invalid RAck header: " + this._rack);
        }
        String s = this._rack.substring(index, index2);
        try {
            this._rseq = Long.parseLong(s);
        }
        catch (NumberFormatException _) {
            throw new ServletParseException("Invalid RSeq number: " + s);
        }
        index = this.skipSpaces(index2);
        index2 = this._rack.indexOf(32, index);
        if (index2 < 0) {
            throw new ServletParseException("Invalid RAck header: " + this._rack);
        }
        s = this._rack.substring(index, index2);
        try {
            this._number = Long.parseLong(s);
        }
        catch (NumberFormatException _) {
            throw new ServletParseException("Invalid CSeq number: " + s);
        }
        index = this.skipSpaces(index2);
        this._method = this._rack.substring(index).trim();
        if (!SipGrammar.isToken(this._method)) {
            throw new ServletParseException("Invalid RAck method: " + this._method);
        }
    }

    private int skipSpaces(int start) {
        int i = start;
        while (this._rack.charAt(i) == ' ') {
            ++i;
        }
        return i;
    }

    public Buffer toBuffer() {
        return new ByteArrayBuffer(this._rack);
    }

    public long getCSeq() {
        return this._number;
    }

    public String getMethod() {
        return this._method;
    }

    public long getRSeq() {
        return this._rseq;
    }

    public String toString() {
        return this._rack;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

