/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sip;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.sip.Parameterable;
import javax.servlet.sip.ServletParseException;
import org.cipango.sip.SipGrammar;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterableImpl
implements Parameterable,
Serializable {
    private String _value;
    private HashMap<String, String> _parameters = new HashMap();

    public ParameterableImpl(String s) throws ServletParseException {
        String parameters = null;
        int indexParams = s.indexOf(59);
        if (indexParams > -1) {
            this._value = s.substring(0, indexParams).trim();
            parameters = s.substring(indexParams + 1);
        } else {
            this._value = s;
        }
        if (parameters != null) {
            this.parseParams(parameters);
        }
    }

    private void parseParams(String sParams) throws ServletParseException {
        StringTokenizer st = new StringTokenizer(sParams, ";");
        while (st.hasMoreTokens()) {
            String value;
            String name;
            String param = st.nextToken();
            int index = param.indexOf(61);
            if (index < 0) {
                name = param.trim();
                value = "";
            } else {
                name = param.substring(0, index).trim();
                value = SipGrammar.unquote(param.substring(index + 1).trim());
            }
            if (!SipGrammar.isToken(name)) {
                throw new ServletParseException("Invalid parameter name [" + name + "] in [" + sParams + "]");
            }
            this._parameters.put(name.toLowerCase(), value);
        }
    }

    public String getParameter(String name) {
        return this._parameters.get(name.toLowerCase());
    }

    public Iterator<String> getParameterNames() {
        return this._parameters.keySet().iterator();
    }

    public Set<Map.Entry<String, String>> getParameters() {
        return this._parameters.entrySet();
    }

    public String getValue() {
        return this._value;
    }

    public void removeParameter(String name) {
        this._parameters.remove(name.toLowerCase());
    }

    public void setParameter(String name, String value) {
        this._parameters.put(name.toLowerCase(), value);
    }

    public void setValue(String value) {
        this._value = value;
    }

    public int getType() {
        return 1;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(this._value);
        Iterator<String> it = this.getParameterNames();
        while (it.hasNext()) {
            String name = it.next();
            String value = this.getParameter(name);
            sb.append(';');
            sb.append(name);
            if (value.length() <= 0) continue;
            if (SipGrammar.isToken(value)) {
                sb.append('=');
                sb.append(value);
                continue;
            }
            sb.append('=');
            sb.append('\"');
            sb.append(SipGrammar.escapeQuoted(value));
            sb.append('\"');
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Parameterable)) {
            return false;
        }
        Parameterable p = (Parameterable)o;
        if (!this._value.equals(p.getValue())) {
            return false;
        }
        for (String key : this._parameters.keySet()) {
            String otherValue = p.getParameter(key);
            if (otherValue == null || this.getParameter(key).equalsIgnoreCase(otherValue)) continue;
            return false;
        }
        return true;
    }

    public Buffer toBuffer() {
        return new ByteArrayBuffer(this.toString());
    }

    public Object clone() {
        return this;
    }
}

