/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sip;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.sip.Address;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.URI;
import org.cipango.sip.LazyParsingException;
import org.cipango.sip.SipGrammar;
import org.cipango.sip.URIFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameAddr
implements Address,
Serializable {
    static final long serialVersionUID = -6854832441383110449L;
    private String _nameAddr;
    private String _displayName;
    private URI _uri;
    private HashMap<String, String> _params = new HashMap();
    private boolean _wildcard;
    private static final int PARAM_NAME = 0;
    private static final int PARAM_VALUE = 1;
    private static final int PARAM_VALUE_LEFT_QUOTE = 2;
    private static final int PARAM_VALUE_RIGHT_QUOTE = 3;

    public NameAddr(String address) throws ServletParseException {
        this._nameAddr = address;
        this.parse(this._nameAddr, true);
    }

    public NameAddr(URI uri) {
        this(uri, null);
    }

    public NameAddr(URI uri, String displayName) {
        this._uri = uri;
        this._displayName = displayName;
    }

    public int getType() {
        return 2;
    }

    private void parse(String address, boolean parseParam) throws ServletParseException {
        String sURI = null;
        String sParams = null;
        if ("*".equals(address = address.trim())) {
            this._wildcard = true;
            return;
        }
        if (address.startsWith("\"")) {
            int rQuote = this.indexRQuote(address, 1);
            if (rQuote == -1) {
                throw new ServletParseException("Missing terminating \" in [" + address + "]");
            }
            String s = address.substring(0, rQuote + 1);
            this._displayName = SipGrammar.unquote(s);
            int laqIndex = address.indexOf(60, rQuote + 1);
            if (laqIndex == -1) {
                throw new ServletParseException("Missing < in address [" + address + "]");
            }
            int raqIndex = address.indexOf(62);
            if (raqIndex == -1) {
                throw new ServletParseException("Missing > in address [" + address + "]");
            }
            sURI = address.substring(laqIndex + 1, raqIndex);
            int indexParams = address.indexOf(59, raqIndex + 1);
            if (indexParams > -1) {
                sParams = address.substring(indexParams + 1);
            }
        } else {
            int indexLAQuote = address.indexOf(60);
            if (indexLAQuote > -1) {
                int indexRAQuote;
                String s;
                if (indexLAQuote > 0 && (s = address.substring(0, indexLAQuote).trim()).length() > 0) {
                    if (!SipGrammar.isTokens(s)) {
                        throw new ServletParseException("Not token or LWS char in [" + s + "] in address [" + address + "]");
                    }
                    this._displayName = s;
                }
                if ((indexRAQuote = address.indexOf(62, indexLAQuote)) == -1) {
                    throw new ServletParseException("Missing > in address [" + address + "]");
                }
                sURI = address.substring(indexLAQuote + 1, indexRAQuote);
                int indexParams = address.indexOf(59, indexRAQuote + 1);
                if (indexParams > -1) {
                    sParams = address.substring(indexParams + 1);
                }
            } else {
                int indexParams = address.indexOf(59);
                if (indexParams > -1) {
                    sURI = address.substring(0, indexParams);
                    sParams = address.substring(indexParams + 1);
                } else {
                    sURI = address;
                }
            }
        }
        this._uri = URIFactory.parseURI(sURI);
        if (sParams != null && parseParam) {
            this.parseParams2(sParams);
        }
    }

    private void parseParams2(String sParams) throws ServletParseException {
        String value;
        int state = 0;
        String name = null;
        int pos = 0;
        block11: for (int i = 0; i < sParams.length(); ++i) {
            char c = sParams.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '=') {
                        name = sParams.substring(pos, i).trim().toLowerCase();
                        if (!SipGrammar.isToken(name)) {
                            throw new ServletParseException("Invalid parameter name [" + name + "] in [" + this._nameAddr + "]");
                        }
                        pos = i + 1;
                        state = 1;
                        continue block11;
                    }
                    if (c != ';') continue block11;
                    name = sParams.substring(pos, i).trim().toLowerCase();
                    if (!SipGrammar.isToken(name)) {
                        throw new ServletParseException("Invalid parameter name [" + name + "] in [" + this._nameAddr + "]");
                    }
                    this._params.put(name, "");
                    pos = i + 1;
                    continue block11;
                }
                case 1: {
                    if (c == ';') {
                        value = sParams.substring(pos, i).trim();
                        this._params.put(name, value);
                        pos = i + 1;
                        state = 0;
                        continue block11;
                    }
                    if (c != '\"') continue block11;
                    pos = i;
                    state = 2;
                    continue block11;
                }
                case 2: {
                    if (c != '\"' || sParams.charAt(i - 1) == '\\') continue block11;
                    value = SipGrammar.unquote(sParams.substring(pos, i + 1).trim());
                    this._params.put(name, value);
                    pos = i + 1;
                    state = 3;
                    continue block11;
                }
                case 3: {
                    if (c != ';') continue block11;
                    pos = i + 1;
                    state = 0;
                    continue block11;
                }
            }
        }
        switch (state) {
            case 0: {
                name = sParams.substring(pos).trim().toLowerCase();
                if (!SipGrammar.isToken(name)) {
                    throw new ServletParseException("Invalid parameter name [" + name + "] in [" + this._nameAddr + "]");
                }
                this._params.put(name, "");
                break;
            }
            case 1: {
                value = sParams.substring(pos).trim();
                this._params.put(name, value);
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new ServletParseException("Invalid parameter value [" + sParams.substring(pos).trim() + "] in [" + this._nameAddr + "]");
            }
        }
    }

    private void parseParams(String sParams) throws ServletParseException {
        int endIndex;
        int beginIndex = 0;
        do {
            String value;
            String name;
            endIndex = sParams.indexOf(61, beginIndex);
            int indexSemi = sParams.indexOf(59, beginIndex);
            if (endIndex == -1 || indexSemi < endIndex && indexSemi != -1) {
                endIndex = indexSemi;
            }
            if (endIndex == -1) {
                name = sParams.substring(beginIndex).trim();
                value = "";
            } else if (endIndex == indexSemi) {
                name = sParams.substring(beginIndex, endIndex).trim();
                value = "";
            } else {
                name = sParams.substring(beginIndex, endIndex).trim();
                int quoteIndex = sParams.indexOf(34, endIndex);
                if (quoteIndex != -1 && (quoteIndex < indexSemi || indexSemi == -1)) {
                    beginIndex = quoteIndex + 1;
                    endIndex = sParams.indexOf(34, beginIndex);
                    value = SipGrammar.unquote(sParams.substring(beginIndex, endIndex).trim());
                } else {
                    beginIndex = endIndex + 1;
                    endIndex = indexSemi;
                    if (endIndex == -1) {
                        endIndex = sParams.length();
                    }
                    value = sParams.substring(beginIndex, endIndex);
                }
            }
            if (!SipGrammar.isToken(name)) {
                throw new ServletParseException("Invalid parameter name [" + name + "] in [" + this._nameAddr + "]");
            }
            this._params.put(name.trim().toLowerCase(), value.trim());
        } while ((beginIndex = endIndex == -1 ? -1 : sParams.indexOf(59, endIndex) + 1) > 0);
    }

    private int indexRQuote(String s, int start) {
        int index = start;
        while (index < s.length()) {
            if (s.charAt(index) == '\"' && s.charAt(index - 1) != '\\') {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public Iterator<String> getParameterNames() {
        return this._params.keySet().iterator();
    }

    public URI getURI() {
        return this._uri;
    }

    public void setURI(URI uri) {
        if (uri == null) {
            throw new NullPointerException("null uri");
        }
        this._uri = uri;
    }

    public String getParameter(String name) {
        return this._params.get(name.toLowerCase());
    }

    public void setParameter(String name, String value) {
        if (value == null) {
            this.removeParameter(name);
        } else {
            this._params.put(name.toLowerCase(), value);
        }
    }

    public void removeParameter(String name) {
        this._params.remove(name.toLowerCase());
    }

    public boolean isWildcard() {
        return this._wildcard;
    }

    public float getQ() {
        String q = this.getParameter("q");
        if (q != null) {
            try {
                return Float.parseFloat(q);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1.0f;
    }

    public void setQ(float q) {
        if (q == -1.0f) {
            this._params.remove("q");
        } else {
            if (q < 0.0f || q > 1.0f) {
                throw new IllegalArgumentException("Invalid q value:" + q);
            }
            this.setParameter("q", String.valueOf(q));
        }
    }

    public int getExpires() {
        String expires = this.getParameter("expires");
        if (expires != null) {
            try {
                return Integer.parseInt(expires);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public void setExpires(int seconds) {
        if (seconds < 0) {
            this.removeParameter("expires");
        } else {
            this.setParameter("expires", Integer.toString(seconds));
        }
    }

    public String toString() {
        StringBuffer sb = this.getValueBuffer();
        if (this.isWildcard()) {
            return sb.toString();
        }
        Iterator<String> it = this.getParameterNames();
        while (it.hasNext()) {
            String name = it.next();
            String value = this.getParameter(name);
            sb.append(';');
            sb.append(name);
            if (value.length() <= 0) continue;
            if (SipGrammar.isToken(value)) {
                sb.append('=');
                sb.append(value);
                continue;
            }
            sb.append('=');
            sb.append('\"');
            sb.append(SipGrammar.escapeQuoted(value));
            sb.append('\"');
        }
        return sb.toString();
    }

    public Object clone() {
        NameAddr clone;
        try {
            clone = (NameAddr)super.clone();
        }
        catch (CloneNotSupportedException _) {
            throw new RuntimeException("!cloneable " + this);
        }
        if (this._params != null) {
            clone._params = (HashMap)this._params.clone();
        }
        if (this._uri != null) {
            clone._uri = this._uri.clone();
        }
        return clone;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Address)) {
            return false;
        }
        Address other = (Address)o;
        if (!this._uri.equals(other.getURI())) {
            return false;
        }
        for (String key : this._params.keySet()) {
            String otherValue = other.getParameter(key);
            if (otherValue == null || this.getParameter(key).equals(otherValue)) continue;
            return false;
        }
        return true;
    }

    public Set<Map.Entry<String, String>> getParameters() {
        return this._params.entrySet();
    }

    public String getValue() {
        return this.getValueBuffer().toString();
    }

    public StringBuffer getValueBuffer() {
        StringBuffer sb = new StringBuffer(64);
        if (this.isWildcard()) {
            return sb.append("*");
        }
        if (this._displayName != null) {
            if (SipGrammar.isTokens(this._displayName)) {
                sb.append(this._displayName);
            } else {
                sb.append('\"');
                sb.append(SipGrammar.escapeQuoted(this._displayName));
                sb.append('\"');
            }
            sb.append(' ');
        }
        sb.append('<');
        sb.append(this._uri.toString());
        sb.append('>');
        return sb;
    }

    public void setValue(String value) {
        if (value == null) {
            throw new NullPointerException("Null value");
        }
        try {
            this._displayName = null;
            this._wildcard = false;
            this._nameAddr = null;
            this.parse(value, false);
        }
        catch (ServletParseException e) {
            throw new LazyParsingException((Exception)((Object)e));
        }
    }
}

