/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.servlet;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import org.cipango.servlet.SipServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SipServletHolder
extends ServletHolder {
    private static final Logger LOG = Log.getLogger(SipServletHandler.class);
    private transient long _unavailable;
    private transient UnavailableException _unavailableEx;

    public SipServletHolder() {
    }

    public SipServletHolder(Servlet servlet) {
        super(servlet);
    }

    public SipServletHolder(Class<? extends Servlet> servlet) {
        super(servlet);
    }

    public synchronized Servlet getServlet() throws ServletException {
        if (this._unavailable != 0L) {
            if (this._unavailable < 0L || this._unavailable > 0L && System.currentTimeMillis() < this._unavailable) {
                throw this._unavailableEx;
            }
            this._unavailable = 0L;
            this._unavailableEx = null;
        }
        return super.getServlet();
    }

    public boolean isAvailable() {
        if (this.isStarted() && this._unavailable == 0L) {
            return super.isAvailable();
        }
        try {
            this.getServlet();
        }
        catch (Exception e) {
            LOG.ignore((Throwable)e);
        }
        return this.isStarted() && this._unavailable == 0L && super.isAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(ServletRequest request, ServletResponse response) throws ServletException, UnavailableException, IOException {
        if (this._class == null) {
            throw new UnavailableException("Servlet Not Initialized");
        }
        Servlet servlet = this.getServletInstance();
        SipServletHolder sipServletHolder = this;
        synchronized (sipServletHolder) {
            if (!this.isAvailable() || !this.isSetInitOrder()) {
                servlet = this.getServlet();
            }
            if (servlet == null) {
                throw new UnavailableException("Could not instantiate " + this._class);
            }
        }
        boolean servlet_error = true;
        try {
            servlet.service(request, response);
            servlet_error = false;
        }
        catch (UnavailableException e) {
            this.makeUnavailable(e);
            throw this.getUnavailableException();
        }
        finally {
            if (servlet_error && request != null) {
                request.setAttribute("javax.servlet.error.servlet_name", (Object)this.getName());
            }
        }
    }

    private void makeUnavailable(UnavailableException e) {
        if (this._unavailableEx == e && this._unavailable != 0L) {
            return;
        }
        this._servletHandler.getServletContext().log("unavailable", (Throwable)e);
        this._unavailableEx = e;
        this._unavailable = -1L;
        this._unavailable = e.isPermanent() ? -1L : (this._unavailableEx.getUnavailableSeconds() > 0 ? System.currentTimeMillis() + (long)(1000 * this._unavailableEx.getUnavailableSeconds()) : System.currentTimeMillis() + 5000L);
    }

    public UnavailableException getUnavailableException() {
        if (this._unavailableEx != null) {
            return this._unavailableEx;
        }
        return super.getUnavailableException();
    }
}

