/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.servlet;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import org.cipango.http.servlet.ConvergedSessionManager;
import org.cipango.server.SipHandler;
import org.cipango.server.SipMessage;
import org.cipango.servlet.SipServletHolder;
import org.cipango.sipapp.SipAppContext;
import org.cipango.sipapp.SipServletMapping;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SipServletHandler
extends ServletHandler
implements SipHandler {
    private static final Logger LOG = Log.getLogger(SipServletHandler.class);
    private SipServletHolder _defaultServlet;
    private SipServletHolder _mainServlet;
    private SipServletHolder[] _sipServlets;
    private SipServletMapping[] _sipServletMappings;
    private Map<String, SipServletHolder> _sipServletNameMap;
    private SipAppContext _context;

    @Override
    public void handle(SipServletMessage message) throws IOException, ServletException {
        if (!this.isStarted()) {
            return;
        }
        SipMessage baseMessage = (SipMessage)message;
        SipServletHolder holder = baseMessage.getHandler();
        if (holder == null) {
            throw new IllegalStateException("No holder for session " + baseMessage.session());
        }
        if (baseMessage.isRequest()) {
            holder.handle((ServletRequest)baseMessage, null);
        } else {
            holder.handle(null, (ServletResponse)baseMessage);
        }
    }

    public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        int semi = request.getRequestURI().lastIndexOf(59);
        if (semi >= 0) {
            ((ConvergedSessionManager.Session)request.getSession(true)).updateSession(request);
        }
        super.doHandle(target, baseRequest, request, response);
    }

    protected void doStart() throws Exception {
        super.doStart();
        ContextHandler.Context servletContext = ContextHandler.getCurrentContext();
        SipAppContext sipAppContext = this._context = servletContext == null ? null : (SipAppContext)servletContext.getContextHandler();
        if (this._context == null) {
            LOG.warn("Null context for sip handler: " + this, new Object[0]);
        }
        if (this._sipServlets != null && this._sipServlets.length > 0) {
            this._defaultServlet = this._sipServlets[0];
        }
        this.updateSipMappings();
        if (this._mainServlet == null && this._sipServlets != null && (this._sipServletMappings == null || this._sipServletMappings.length == 0)) {
            if (this._sipServlets.length == 1) {
                this._mainServlet = this._sipServlets[0];
            } else if (this._sipServlets.length != 0) {
                throw new IllegalStateException("Multiple servlets and no SIP servlet mappping defined.");
            }
        }
    }

    protected void doStop() throws Exception {
        MultiException mx = new MultiException();
        try {
            super.doStop();
        }
        catch (Exception e) {
            mx.add((Throwable)e);
        }
        if (this._sipServlets != null) {
            int i = this._sipServlets.length;
            while (i-- > 0) {
                try {
                    this._sipServlets[i].stop();
                }
                catch (Exception e) {
                    LOG.warn("EXCEPTION ", (Throwable)e);
                }
            }
        }
        mx.ifExceptionThrow();
    }

    @Override
    public void setServer(Server server) {
        if (this.getServer() != null && this.getServer() != server) {
            this.getServer().getContainer().update((Object)this, (Object[])this._sipServlets, null, "sipServlets", true);
            this.getServer().getContainer().update((Object)this, (Object[])this._sipServletMappings, null, "sipServletMappings", true);
            this.getServer().getContainer().update((Object)this, (Object)this._mainServlet, null, "mainServlet", true);
        }
        if (server != null && this.getServer() != server) {
            server.getContainer().update((Object)this, null, (Object[])this._sipServlets, "sipServlets", true);
            server.getContainer().update((Object)this, null, (Object[])this._sipServletMappings, "sipServletMappings", true);
            server.getContainer().update((Object)this, null, (Object)this._mainServlet, "mainServlet", true);
        }
        super.setServer(server);
    }

    public SipServletHolder getDefaultServlet() {
        if (this._mainServlet == null) {
            return this._defaultServlet;
        }
        return this._mainServlet;
    }

    public SipServletHolder getMainServlet() {
        return this._mainServlet;
    }

    protected void updateSipMappings() throws ServletException {
        if (this._sipServlets == null) {
            this._sipServletNameMap = null;
        } else {
            HashMap<String, SipServletHolder> nm = new HashMap<String, SipServletHolder>();
            for (int i = 0; i < this._sipServlets.length; ++i) {
                if (nm.containsKey(this._sipServlets[i].getName())) {
                    throw new ServletException("A servlet with name " + this._sipServlets[i].getName() + " is already registered");
                }
                nm.put(this._sipServlets[i].getName(), this._sipServlets[i]);
                this._sipServlets[i].setServletHandler(this);
            }
            this._sipServletNameMap = nm;
        }
    }

    public void initializeSip() throws Exception {
        MultiException mx = new MultiException();
        if (this._sipServlets != null) {
            SipServletHolder[] servlets = (SipServletHolder[])this._sipServlets.clone();
            Arrays.sort((Object[])servlets);
            for (int i = 0; i < servlets.length; ++i) {
                try {
                    servlets[i].start();
                    continue;
                }
                catch (Exception e) {
                    LOG.debug("EXCEPTION ", (Throwable)e);
                    mx.add((Throwable)e);
                }
            }
            mx.ifExceptionThrow();
        }
    }

    public SipServletHolder findHolder(SipServletRequest request) {
        if (this._mainServlet != null) {
            return this._mainServlet;
        }
        if (this._sipServletMappings != null) {
            for (int i = 0; i < this._sipServletMappings.length; ++i) {
                SipServletMapping mapping = this._sipServletMappings[i];
                if (!mapping.getMatchingRule().matches(request)) continue;
                return this._sipServletNameMap.get(mapping.getServletName());
            }
        }
        return null;
    }

    public SipServletHolder getHolder(String name) {
        return this._sipServletNameMap.get(name);
    }

    public SipServletHolder[] getSipServlets() {
        return this._sipServlets;
    }

    public SipServletHolder newSipServletHolder(Class<SipServlet> servlet) {
        return new SipServletHolder(servlet);
    }

    public void addSipServlet(SipServletHolder servlet) {
        SipServletHolder[] holders = this.getSipServlets();
        if (holders != null) {
            holders = (SipServletHolder[])holders.clone();
        }
        this.setSipServlets((SipServletHolder[])LazyList.addToArray((Object[])holders, (Object)((Object)servlet), SipServletHolder.class));
    }

    public void addSipServletWithMapping(SipServletHolder servlet, SipServletMapping mapping) {
        SipServletHolder[] holders = this.getSipServlets();
        if (holders != null) {
            holders = (SipServletHolder[])holders.clone();
        }
        try {
            this.setSipServlets((SipServletHolder[])LazyList.addToArray((Object[])holders, (Object)((Object)servlet), SipServletHolder.class));
            this.setSipServletMappings((SipServletMapping[])LazyList.addToArray((Object[])this.getSipServletMappings(), (Object)mapping, SipServletMapping.class));
            if (this._defaultServlet == null) {
                this._defaultServlet = servlet;
            }
            servlet.start();
        }
        catch (Exception e) {
            this.setSipServlets(holders);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public void addSipServletMapping(SipServletMapping mapping) {
        this.setSipServletMappings((SipServletMapping[])LazyList.addToArray((Object[])this.getSipServletMappings(), (Object)mapping, SipServletMapping.class));
    }

    public SipServletHolder getSipServlet(String name) {
        return this._sipServletNameMap.get(name);
    }

    public SipServletHolder removeSipServlet(String servletName) {
        SipServletHolder holder = this.getSipServlet(servletName);
        this.setSipServlets((SipServletHolder[])LazyList.removeFromArray((Object[])this.getSipServlets(), (Object)((Object)holder)));
        SipServletMapping[] mappings = this.getSipServletMappings();
        for (int i = 0; mappings != null && i < mappings.length; ++i) {
            String name;
            if (mappings[i] == null || !servletName.equals(name = mappings[i].getServletName())) continue;
            this.setSipServletMappings((SipServletMapping[])LazyList.removeFromArray((Object[])this.getSipServletMappings(), (Object)mappings[i]));
        }
        return holder;
    }

    public void setSipServlets(SipServletHolder[] holders) {
        SipServletHolder[] oldHolders = this.getSipServlets();
        if (oldHolders != null) {
            oldHolders = (SipServletHolder[])oldHolders.clone();
        }
        try {
            this._sipServlets = holders;
            this.updateSipMappings();
            if (this.getServer() != null) {
                this.getServer().getContainer().update((Object)this, (Object[])oldHolders, (Object[])this._sipServlets, "sipServlets", true);
            }
        }
        catch (Exception e) {
            this._sipServlets = oldHolders;
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public void setSipServletMappings(SipServletMapping[] sipServletMappings) {
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, (Object[])this._sipServletMappings, (Object[])sipServletMappings, "sipServletMapping", true);
        }
        this._sipServletMappings = sipServletMappings;
    }

    public void setMainServletName(String name) {
        SipServletHolder previous = this._mainServlet;
        this._mainServlet = this.getSipServlet(name);
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, (Object)previous, (Object)this._mainServlet, "mainServlet", true);
        }
    }

    public SipServletMapping[] getSipServletMappings() {
        return this._sipServletMappings;
    }

    protected void destroySipServlet(Servlet servlet) {
        for (ServletContextHandler.Decorator decorator : this._context.getDecorators()) {
            decorator.destroyServletInstance(servlet);
        }
    }

    public void dump(Appendable out, String indent) throws IOException {
        super.dump(out, indent);
        out.append(indent).append(" |\n");
        Collection<Object> c = this._mainServlet != null ? Collections.singleton("Main servlet=" + this._mainServlet.getName()) : TypeUtil.asList((Object[])this.getSipServletMappings());
        SipServletHandler.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{c, TypeUtil.asList((Object[])this.getSipServlets())});
    }
}

