/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.transaction;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.sip.SipServletMessage;
import org.cipango.server.SipHandler;
import org.cipango.server.SipMessage;
import org.cipango.server.SipProxy;
import org.cipango.server.SipRequest;
import org.cipango.server.SipResponse;
import org.cipango.server.transaction.ClientTransaction;
import org.cipango.server.transaction.ClientTransactionListener;
import org.cipango.server.transaction.ServerTransaction;
import org.cipango.server.transaction.Transaction;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.statistic.CounterStatistic;

public class TransactionManager
extends HandlerWrapper
implements SipHandler {
    private static final Logger LOG = Log.getLogger(TransactionManager.class);
    private CounterStatistic _retransStats = new CounterStatistic();
    private CounterStatistic _notFoundStats = new CounterStatistic();

    public void handle(SipServletMessage message) throws ServletException, IOException {
        if (((SipMessage)message).isRequest()) {
            this.handleRequest((SipRequest)message);
        } else {
            this.handleResponse((SipResponse)message);
        }
    }

    public void handleRequest(SipRequest request) throws ServletException, IOException {
        ServerTransaction transaction;
        String branch = request.getTopVia().getBranch();
        if (!(branch != null && branch.startsWith("z9hG4bK") || "0".equals(branch) && request.isAck())) {
            LOG.debug("Not 3261 branch: {}. Dropping request", new Object[]{branch});
            return;
        }
        if (request.isCancel()) {
            branch = "cancel-" + branch;
        }
        if ((transaction = request.getCallSession().getServerTransaction(branch)) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("request {} in transaction {}", new Object[]{request.getRequestLine(), transaction});
            }
            request.setTransaction(transaction);
            if (request.isAck()) {
                transaction.handleAck(request);
            } else {
                this.retransReceived();
                transaction.handleRetransmission(request);
            }
        } else {
            transaction = new ServerTransaction(request);
            if (!request.isAck()) {
                request.getCallSession().addServerTransaction(transaction);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("new transaction {} for request {}", new Object[]{transaction, request.getRequestLine()});
            }
            if (request.isCancel()) {
                String txBranch = request.getTopVia().getBranch();
                ServerTransaction stx = request.getCallSession().getServerTransaction(txBranch);
                if (stx == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("No transaction for cancelled branch {}", new Object[]{txBranch, null});
                    }
                    SipResponse unknown = (SipResponse)request.createResponse(481);
                    transaction.send(unknown);
                } else {
                    SipResponse ok = (SipResponse)request.createResponse(200);
                    transaction.send(ok);
                    stx.cancel(request);
                }
            } else {
                ((SipHandler)this.getHandler()).handle(request);
            }
        }
    }

    public void handleResponse(SipResponse response) throws ServletException, IOException {
        ClientTransaction ctx;
        String branch = response.getTopVia().getBranch();
        if (response.isCancel()) {
            branch = "cancel-" + branch;
        }
        if ((ctx = response.getCallSession().getClientTransaction(branch)) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("did not find client transaction for response {}", new Object[]{response});
            }
            this.transactionNotFound();
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("response {} for transaction {}", new Object[]{response, ctx});
        }
        response.setTransaction(ctx);
        ctx.handleResponse(response);
    }

    public ClientTransaction sendRequest(SipRequest request, ClientTransactionListener listener) {
        ClientTransaction ctx = new ClientTransaction(request, listener);
        if (!request.isAck()) {
            request.getCallSession().addClientTransaction(ctx);
        }
        try {
            ctx.start();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        return ctx;
    }

    public int getT1() {
        return Transaction.__T1;
    }

    public int getT2() {
        return Transaction.__T2;
    }

    public int getT4() {
        return Transaction.__T4;
    }

    public int getTD() {
        return Transaction.__TD;
    }

    public int getTimerC() {
        return SipProxy.__timerC;
    }

    public void setT1(int millis) {
        if (millis < 0) {
            throw new IllegalArgumentException("SIP Timers must be positive");
        }
        Transaction.__T1 = millis;
    }

    public void setT2(int millis) {
        if (millis < 0) {
            throw new IllegalArgumentException("SIP Timers must be positive");
        }
        Transaction.__T2 = millis;
    }

    public void setT4(int millis) {
        if (millis < 0) {
            throw new IllegalArgumentException("SIP Timers must be positive");
        }
        Transaction.__T4 = millis;
    }

    public void setTD(int millis) {
        if (millis < 0) {
            throw new IllegalArgumentException("SIP Timers must be positive");
        }
        Transaction.__TD = millis;
    }

    public void setTimerC(int millis) {
        if (millis < 0) {
            throw new IllegalArgumentException("SIP Timers must be positive");
        }
        SipProxy.__timerC = millis;
    }

    protected void retransReceived() {
        this._retransStats.increment();
    }

    protected void transactionNotFound() {
        this._notFoundStats.increment();
    }

    public long getRetransmissions() {
        return this._retransStats.getCurrent();
    }

    public long getNotFoundTransactions() {
        return this._notFoundStats.getCurrent();
    }

    public void statsReset() {
        this._retransStats.reset();
        this._notFoundStats.reset();
    }
}

