/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.transaction;

import org.cipango.server.Server;
import org.cipango.server.SipConnection;
import org.cipango.server.SipRequest;
import org.cipango.server.session.CallSession;
import org.cipango.util.TimerTask;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class Transaction {
    private static final Logger LOG = Log.getLogger(Transaction.class);
    public static final int STATE_UNDEFINED = 0;
    public static final int STATE_CALLING = 1;
    public static final int STATE_TRYING = 2;
    public static final int STATE_PROCEEDING = 3;
    public static final int STATE_COMPLETED = 4;
    public static final int STATE_CONFIRMED = 5;
    public static final int STATE_ACCEPTED = 6;
    public static final int STATE_TERMINATED = 7;
    public static final String[] STATES = new String[]{"Undefined", "Calling", "Trying", "Proceeding", "Completed", "Confirmed", "Accepted", "Terminated"};
    public static final int DEFAULT_T1 = 500;
    public static final int DEFAULT_T2 = 4000;
    public static final int DEFAULT_T4 = 5000;
    public static final int DEFAULT_TD = 32000;
    public static int __T1 = 500;
    public static int __T2 = 4000;
    public static int __T4 = 5000;
    public static int __TD = 32000;
    protected TimerTask[] _timers;
    protected int _state;
    private String _branch;
    private String _key;
    protected SipRequest _request;
    protected CallSession _callSession;
    protected boolean _cancel;
    private SipConnection _connection;

    public Transaction(SipRequest request, String branch) {
        this._request = request;
        this._callSession = request.getCallSession();
        this._branch = branch;
        this._cancel = request.isCancel();
        this._key = this._cancel ? "cancel-" + branch : branch;
        request.setTransaction(this);
    }

    public SipConnection getConnection() {
        return this._connection;
    }

    public void setConnection(SipConnection connection) {
        this._connection = connection;
    }

    public boolean isInvite() {
        return this._request.isInvite();
    }

    public boolean isAck() {
        return this._request.isAck();
    }

    public String getKey() {
        return this._key;
    }

    public SipRequest getRequest() {
        return this._request;
    }

    public int getState() {
        return this._state;
    }

    public boolean isCompleted() {
        return this._state >= 4;
    }

    public abstract boolean isServer();

    public void setState(int state) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} -> {}", new Object[]{this, STATES[state]});
        }
        this._state = state;
    }

    public String getStateAsString() {
        return STATES[this._state];
    }

    public void startTimer(int timer, long delay) {
        TimerTask timerTask = this._timers[timer];
        if (timerTask != null) {
            this._callSession.cancel(timerTask);
        }
        this._timers[timer] = this._callSession.schedule(new Timer(timer), delay);
    }

    public void cancelTimer(int timer) {
        TimerTask timerTask = this._timers[timer];
        if (timerTask != null) {
            this._callSession.cancel(timerTask);
        }
        this._timers[timer] = null;
    }

    public abstract String asString(int var1);

    public boolean isTransportReliable() {
        return this.getConnection().getConnector().isReliable();
    }

    public Server getServer() {
        return this.getCallSession().getServer();
    }

    public String getBranch() {
        return this._branch;
    }

    public CallSession getCallSession() {
        return this._callSession;
    }

    public abstract void timeout(int var1);

    public String toString() {
        return this._branch + "/" + this._request.getMethod() + "/" + STATES[this._state];
    }

    class Timer
    implements Runnable {
        private int _timer;

        public Timer(int timer) {
            this._timer = timer;
        }

        public void run() {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("timeout {} for transaction {}", new Object[]{this, Transaction.this});
                }
                Transaction.this.timeout(this._timer);
            }
            catch (Throwable t) {
                LOG.warn(t);
            }
        }

        public String toString() {
            return Transaction.this.asString(this._timer);
        }
    }
}

