/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.transaction;

import java.io.IOException;
import org.cipango.server.SipRequest;
import org.cipango.server.SipResponse;
import org.cipango.server.transaction.ServerTransactionListener;
import org.cipango.server.transaction.Transaction;
import org.cipango.util.TimerTask;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ServerTransaction
extends Transaction {
    private static final Logger LOG = Log.getLogger(ServerTransaction.class);
    private static final int TIMER_G = 0;
    private static final int TIMER_H = 1;
    private static final int TIMER_I = 2;
    private static final int TIMER_J = 3;
    private static final int TIMER_L = 4;
    private static final char[] TIMERS = new char[]{'G', 'H', 'I', 'J', 'L'};
    private SipResponse _provisionalResponse;
    private SipResponse _finalResponse;
    private ServerTransactionListener _listener;
    private long gDelay = __T1;

    public ServerTransaction(SipRequest request) {
        super(request, request.getTopVia().getBranch());
        this._timers = new TimerTask[5];
        this.setConnection(request.getConnection());
        if (this.isInvite()) {
            this.setState(3);
        } else {
            this.setState(2);
        }
    }

    public void setListener(ServerTransactionListener listener) {
        if (this._listener == null) {
            this._listener = listener;
        }
    }

    public void cancel(SipRequest cancel) throws IOException {
        this._listener.handleCancel(this, cancel);
    }

    public void handleAck(SipRequest ack) {
        if (this.isInvite()) {
            if (this._state != 4) {
                LOG.info("ACK in state {} for transaction {}", new Object[]{this.getStateAsString(), this});
                return;
            }
            this.setState(5);
            this.cancelTimer(1);
            this.cancelTimer(0);
            if (this.isTransportReliable()) {
                this.terminate();
            } else {
                this.startTimer(2, __T4);
            }
        } else {
            LOG.info("ACK for non-INVITE: {}", new Object[]{this});
        }
    }

    public void handleRetransmission(SipRequest request) {
        SipResponse response = null;
        if (this._state == 3) {
            response = this._provisionalResponse;
        } else if (this._state == 4) {
            response = this._finalResponse;
        }
        if (response != null) {
            try {
                this.doSend(response);
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
            }
        }
    }

    public boolean isServer() {
        return true;
    }

    public void send(SipResponse response) {
        block19: {
            block18: {
                int status = response.getStatus();
                if (!this.isInvite()) break block18;
                switch (this._state) {
                    case 3: {
                        if (status < 200) {
                            this._provisionalResponse = response;
                        } else if (status >= 300) {
                            this.setState(4);
                            this._finalResponse = response;
                            if (!this.isTransportReliable()) {
                                this.startTimer(0, this.gDelay);
                            }
                            this.startTimer(1, 64 * __T1);
                        } else if (status >= 200) {
                            this.setState(6);
                            this.startTimer(4, 64 * __T1);
                        }
                        break block19;
                    }
                    case 6: {
                        if (status < 200 || status >= 300) {
                            throw new IllegalStateException("!2xx && Accepted");
                        }
                        break block19;
                    }
                    default: {
                        throw new IllegalStateException("sendInvite && !Proceeding");
                    }
                }
            }
            switch (this._state) {
                case 2: 
                case 3: {
                    if (response.getStatus() < 200) {
                        this._provisionalResponse = response;
                        if (this._state != 2) break;
                        this.setState(3);
                        break;
                    }
                    if (response.getStatus() < 200) break;
                    this.setState(4);
                    this._finalResponse = response;
                    if (this.isTransportReliable()) {
                        this.terminate();
                        break;
                    }
                    this.startTimer(3, 64 * __T1);
                    break;
                }
                default: {
                    throw new IllegalStateException("sendNonInvite && !(state == Trying || state == Proceeding)");
                }
            }
        }
        try {
            this.doSend(response);
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
        }
    }

    private void doSend(SipResponse response) throws IOException {
        this.getServer().getConnectorManager().sendResponse(response, this.getConnection());
    }

    public void timeout(int id) {
        switch (id) {
            case 0: {
                try {
                    this.doSend(this._finalResponse);
                }
                catch (IOException e) {
                    LOG.debug("failed to retransmit response on timer G expiry", (Throwable)e);
                }
                this.gDelay *= 2L;
                this.startTimer(0, Math.min(this.gDelay, (long)__T2));
                break;
            }
            case 1: {
                this.cancelTimer(0);
                this.terminate();
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.terminate();
                break;
            }
            default: {
                throw new RuntimeException("unknown timeout id " + id);
            }
        }
    }

    public void terminate() {
        this._finalResponse = null;
        this._provisionalResponse = null;
        this.setState(7);
        this.getCallSession().removeServerTransaction(this);
        if (this._listener != null) {
            this._listener.transactionTerminated(this);
        }
    }

    public String asString(int timer) {
        return "Timer" + TIMERS[timer];
    }
}

