/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.transaction;

import java.io.IOException;
import java.net.InetAddress;
import javax.servlet.sip.Address;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import org.cipango.server.ID;
import org.cipango.server.SipConnection;
import org.cipango.server.SipConnector;
import org.cipango.server.SipConnectors;
import org.cipango.server.SipRequest;
import org.cipango.server.SipResponse;
import org.cipango.server.log.AccessLog;
import org.cipango.server.transaction.ClientTransactionListener;
import org.cipango.server.transaction.Transaction;
import org.cipango.sip.Via;
import org.cipango.util.TimerTask;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ClientTransaction
extends Transaction {
    private static final Logger LOG = Log.getLogger(ClientTransaction.class);
    private static final int TIMER_A = 0;
    private static final int TIMER_B = 1;
    private static final int TIMER_D = 2;
    private static final int TIMER_E = 3;
    private static final int TIMER_F = 4;
    private static final int TIMER_K = 5;
    private static final int TIMER_M = 6;
    private static final char[] TIMERS = new char[]{'A', 'B', 'D', 'E', 'F', 'K', 'M'};
    private long _aDelay = __T1;
    private long _eDelay = __T1;
    private ClientTransactionListener _listener;
    private SipRequest _pendingCancel;
    private boolean _canceled = false;

    public ClientTransaction(SipRequest request, ClientTransactionListener listener) {
        this(request, listener, ID.newBranch());
    }

    public ClientTransaction(SipRequest request, ClientTransactionListener listener, String branch) {
        super(request, branch);
        this._listener = listener;
        this._timers = new TimerTask[7];
    }

    public ClientTransactionListener getListener() {
        return this._listener;
    }

    private void ack(SipResponse response) {
        String tag;
        SipRequest ack = this.getRequest().createRequest("ACK");
        if (ack.to().getParameter("tag") == null && (tag = response.to().getParameter("tag")) != null) {
            ack.to().setParameter("tag", tag);
        }
        try {
            this.getServer().getConnectorManager().send(ack, this.getConnection());
        }
        catch (IOException e) {
            LOG.ignore((Throwable)e);
        }
    }

    public void cancel(SipRequest cancel) {
        if (this._canceled) {
            return;
        }
        this._canceled = true;
        if (this._state <= 2) {
            this._pendingCancel = cancel;
            return;
        }
        this.doCancel(cancel);
    }

    public void cancel() {
        this.cancel((SipRequest)this.getRequest().createCancel());
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    private ClientTransaction doCancel(SipRequest cancel) {
        ClientTransaction cancelTx = new ClientTransaction(cancel, this._listener, cancel.getTopVia().getBranch());
        cancelTx.setConnection(this.getConnection());
        cancel.getCallSession().addClientTransaction(cancelTx);
        try {
            cancelTx.start();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        return cancelTx;
    }

    private void doSend() throws IOException {
        if (this.getConnection() != null) {
            if (this.getConnection().isOpen()) {
                this.getServer().getConnectorManager().send(this._request, this.getConnection());
            } else {
                LOG.debug("Could not sent request {} as the connection {} is closed", new Object[]{this._request, this.getConnection()});
            }
        } else {
            int port;
            URI uri = null;
            Address route = this._request.getTopRoute();
            uri = route != null && !this._request.isNextHopStrictRouting() ? route.getURI() : this._request.getRequestURI();
            if (!uri.isSipURI()) {
                throw new IOException("Cannot route on URI: " + uri);
            }
            SipURI target = (SipURI)uri;
            InetAddress address = InetAddress.getByName(target.getHost());
            int transport = SipConnectors.getOrdinal(target.getTransportParam());
            if (transport == -1) {
                transport = 1;
            }
            if ((port = target.getPort()) == -1) {
                port = SipConnectors.getDefaultPort(transport);
            }
            Via via = new Via("SIP/2.0", null, null);
            via.setBranch(this.getBranch());
            this.customizeVia(via);
            this._request.pushVia(via);
            SipConnection connection = this.getServer().getConnectorManager().getConnection(this._request, transport, address, port);
            this.setConnection(connection);
            this._listener.customizeRequest(this._request, connection);
            this.getServer().getConnectorManager().send(this._request, connection);
        }
    }

    protected void customizeVia(Via via) {
        if (ID.isKey(this._callSession.getId())) {
            via.addParameter("app-session-id", this._request.appSession().getAppId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        if (this._state != 0) {
            throw new IllegalStateException("!undefined: " + this._state);
        }
        if (this.isInvite()) {
            this.setState(1);
            try {
                this.doSend();
            }
            finally {
                this.startTimer(1, 64L * (long)__T1);
            }
            if (!this.isTransportReliable()) {
                this.startTimer(0, this._aDelay);
            }
        } else if (this.isAck()) {
            this.setState(2);
            this.doSend();
        } else {
            this.setState(2);
            try {
                this.doSend();
            }
            finally {
                this.startTimer(4, 64L * (long)__T1);
            }
            if (!this.isTransportReliable()) {
                this.startTimer(3, this._eDelay);
            }
        }
    }

    public void handleResponse(SipResponse response) {
        int status = response.getStatus();
        if (response.isInvite()) {
            switch (this._state) {
                case 1: {
                    this.cancelTimer(0);
                    this.cancelTimer(1);
                    if (status < 200) {
                        this.setState(3);
                        if (this._pendingCancel != null) {
                            this.doCancel(this._pendingCancel);
                        }
                    } else if (200 <= status && status < 300) {
                        this.setState(6);
                        this.startTimer(6, 64L * (long)__T1);
                    } else {
                        this.setState(4);
                        this.ack(response);
                        if (this.isTransportReliable()) {
                            this.terminate();
                        } else {
                            this.startTimer(2, __TD);
                        }
                    }
                    this._listener.handleResponse(response);
                    break;
                }
                case 3: {
                    if (200 <= status && status < 300) {
                        this.setState(6);
                        this.startTimer(6, 64L * (long)__T1);
                    } else if (status >= 300) {
                        this.setState(4);
                        this.ack(response);
                        if (this.isTransportReliable()) {
                            this.terminate();
                        } else {
                            this.startTimer(2, __TD);
                        }
                    }
                    this._listener.handleResponse(response);
                    break;
                }
                case 4: {
                    this.ack(response);
                    response.setHandled(true);
                    break;
                }
                case 6: {
                    if (200 > status || status >= 300) {
                        LOG.debug("non 2xx response {} in Accepted state", new Object[]{response});
                        response.setHandled(true);
                        break;
                    }
                    this._listener.handleResponse(response);
                    break;
                }
                default: {
                    LOG.debug("handleResponse (invite) && state ==" + this._state, new Object[0]);
                    response.setHandled(true);
                    break;
                }
            }
        } else {
            switch (this._state) {
                case 2: {
                    if (status < 200) {
                        this.setState(3);
                    } else {
                        this.cancelTimer(3);
                        this.cancelTimer(4);
                        this.setState(4);
                        if (this.isTransportReliable()) {
                            this.terminate();
                        } else {
                            this.startTimer(5, __T4);
                        }
                    }
                    if (this._cancel) break;
                    this._listener.handleResponse(response);
                    break;
                }
                case 3: {
                    if (status < 200) break;
                    this.cancelTimer(3);
                    this.cancelTimer(4);
                    this.setState(4);
                    if (this.isTransportReliable()) {
                        this.terminate();
                    } else {
                        this.startTimer(5, __T4);
                    }
                    if (this._cancel) break;
                    this._listener.handleResponse(response);
                    break;
                }
                case 4: {
                    response.setHandled(true);
                    break;
                }
                default: {
                    LOG.warn("handleResponse (non-invite) && state ==" + this._state, new Object[0]);
                    response.setHandled(true);
                }
            }
        }
    }

    public boolean isServer() {
        return false;
    }

    public void terminate() {
        this.setState(7);
        this.getCallSession().removeClientTransaction(this);
    }

    public String asString(int timer) {
        return "Timer" + TIMERS[timer];
    }

    public void timeout(int id) {
        switch (id) {
            case 0: {
                try {
                    this.doSend();
                }
                catch (IOException e) {
                    LOG.debug("Failed to (re)send request " + this._request, new Object[0]);
                }
                this._aDelay *= 2L;
                this.startTimer(0, this._aDelay);
                break;
            }
            case 1: {
                this.cancelTimer(0);
                SipResponse responseB = this.create408();
                if (!this._cancel) {
                    this._listener.handleResponse(responseB);
                }
                this.terminate();
                break;
            }
            case 2: {
                this.terminate();
                break;
            }
            case 3: {
                try {
                    this.doSend();
                }
                catch (IOException e) {
                    LOG.debug("Failed to (re)send request " + this._request, new Object[0]);
                }
                this._eDelay = this._state == 2 ? Math.min(this._eDelay * 2L, (long)__T2) : (long)__T2;
                this.startTimer(3, this._eDelay);
                break;
            }
            case 4: {
                this.cancelTimer(3);
                SipResponse responseF = this.create408();
                if (!this._cancel) {
                    this._listener.handleResponse(responseF);
                }
                this.terminate();
                break;
            }
            case 5: {
                this.terminate();
                break;
            }
            case 6: {
                this.terminate();
                break;
            }
            default: {
                throw new RuntimeException("unknown timeout id " + id);
            }
        }
    }

    public SipResponse create408() {
        AccessLog accessLog;
        SipResponse responseB = new SipResponse(this._request, 408, null);
        if (responseB.getTo().getParameter("tag") == null) {
            responseB.setToTag(ID.newTag());
        }
        if ((accessLog = this.getServer().getConnectorManager().getAccessLog()) != null) {
            accessLog.messageReceived(responseB, new TimeoutConnection());
        }
        return responseB;
    }

    class TimeoutConnection
    implements SipConnection {
        private SipConnector _connector;

        public TimeoutConnection() {
            this._connector = ClientTransaction.this.getConnection() == null ? ClientTransaction.this.getServer().getConnectorManager().getDefaultConnector() : ClientTransaction.this.getConnection().getConnector();
        }

        public SipConnector getConnector() {
            return this._connector;
        }

        public InetAddress getLocalAddress() {
            return this._connector.getAddr();
        }

        public int getLocalPort() {
            return this._connector.getPort();
        }

        public InetAddress getRemoteAddress() {
            return this._connector.getAddr();
        }

        public int getRemotePort() {
            return this._connector.getPort();
        }

        public void write(Buffer buffer) throws IOException {
            throw new UnsupportedOperationException();
        }

        public boolean isOpen() {
            return false;
        }
    }
}

