/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.session.scope;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.sip.Address;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.URI;
import javax.servlet.sip.ar.SipApplicationRoutingRegion;
import org.cipango.server.session.CallSession;
import org.cipango.server.session.Session;
import org.cipango.server.session.SessionIf;
import org.cipango.server.session.SessionManager;
import org.cipango.server.session.scope.ScopedAppSession;
import org.cipango.server.session.scope.ScopedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopedSession
extends ScopedObject
implements SessionIf {
    private Session _session;

    public ScopedSession(Session session) {
        this._session = session;
    }

    public SipServletRequest createRequest(String method) {
        return this._session.createRequest(method);
    }

    public SipApplicationSession getApplicationSession() {
        return new ScopedAppSession(this._session.appSession());
    }

    public Object getAttribute(String name) {
        return this._session.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this._session.getAttributeNames();
    }

    public String getCallId() {
        return this._session.getCallId();
    }

    public long getCreationTime() {
        return this._session.getCreationTime();
    }

    public String getId() {
        return this._session.getId();
    }

    public boolean getInvalidateWhenReady() {
        return this._session.getInvalidateWhenReady();
    }

    public long getLastAccessedTime() {
        return this._session.getLastAccessedTime();
    }

    public Address getLocalParty() {
        return this._session.getLocalParty();
    }

    public SipApplicationRoutingRegion getRegion() {
        return this._session.getRegion();
    }

    public Address getRemoteParty() {
        return this._session.getRemoteParty();
    }

    public ServletContext getServletContext() {
        return this._session.getServletContext();
    }

    public SipSession.State getState() {
        return this._session.getState();
    }

    public URI getSubscriberURI() {
        return this._session.getSubscriberURI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        SessionManager.SessionScope scope = this.openScope();
        try {
            this._session.invalidate();
        }
        finally {
            scope.close();
        }
    }

    public boolean isReadyToInvalidate() {
        return this._session.isReadyToInvalidate();
    }

    public boolean isValid() {
        return this._session.isValid();
    }

    public void removeAttribute(String name) {
        this._session.removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this._session.setAttribute(name, value);
    }

    public void setHandler(String name) throws ServletException {
        this._session.setHandler(name);
    }

    public void setInvalidateWhenReady(boolean invalidateWhenReady) {
        this._session.setInvalidateWhenReady(invalidateWhenReady);
    }

    public void setOutboundInterface(InetAddress address) {
        this._session.setOutboundInterface(address);
    }

    public void setOutboundInterface(InetSocketAddress address) {
        this._session.setOutboundInterface(address);
    }

    @Override
    public Session getSession() {
        return this._session;
    }

    @Override
    protected CallSession getCallSession() {
        return this._session.getCallSession();
    }

    public String toString() {
        return this._session.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof SessionIf)) {
            return false;
        }
        return this._session.equals(((SessionIf)o).getSession());
    }

    public int hashCode() {
        return this._session.hashCode();
    }
}

