/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.session.scope;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.servlet.sip.ServletTimer;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.URI;
import org.cipango.server.session.AppSession;
import org.cipango.server.session.AppSessionIf;
import org.cipango.server.session.CallSession;
import org.cipango.server.session.Session;
import org.cipango.server.session.SessionManager;
import org.cipango.server.session.scope.ScopedObject;
import org.cipango.server.session.scope.ScopedSession;
import org.cipango.server.session.scope.ScopedTimer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopedAppSession
extends ScopedObject
implements AppSessionIf {
    protected AppSession _appSession;

    public ScopedAppSession(AppSession appSession) {
        this._appSession = appSession;
    }

    @Override
    public CallSession getCallSession() {
        return this._appSession.getCallSession();
    }

    public void encodeURI(URI uri) {
        this._appSession.encodeURI(uri);
    }

    public URL encodeURL(URL url) {
        return this._appSession.encodeURL(url);
    }

    public String getApplicationName() {
        return this._appSession.getApplicationName();
    }

    public Object getAttribute(String name) {
        return this._appSession.getAttribute(name);
    }

    public Iterator<String> getAttributeNames() {
        return this._appSession.getAttributeNames();
    }

    public long getCreationTime() {
        return this._appSession.getCreationTime();
    }

    public long getExpirationTime() {
        return this._appSession.getExpirationTime();
    }

    public String getId() {
        return this._appSession.getId();
    }

    public boolean getInvalidateWhenReady() {
        return this._appSession.getInvalidateWhenReady();
    }

    public long getLastAccessedTime() {
        return this._appSession.getLastAccessedTime();
    }

    public Object getSession(String id, SipApplicationSession.Protocol protocol) {
        Object session = this._appSession.getSession(id, protocol);
        if (session instanceof Session) {
            return new ScopedSession((Session)session);
        }
        return session;
    }

    public Iterator<?> getSessions() {
        ArrayList<ScopedSession> list = new ArrayList<ScopedSession>();
        Iterator<?> it = this._appSession.getSessions();
        while (it.hasNext()) {
            Object session = it.next();
            if (session instanceof Session) {
                list.add(new ScopedSession((Session)session));
                continue;
            }
            list.add((ScopedSession)session);
        }
        return list.iterator();
    }

    public Iterator<?> getSessions(String protocol) {
        Iterator<?> it = this._appSession.getSessions(protocol);
        if (SipApplicationSession.Protocol.SIP.toString().equalsIgnoreCase(protocol)) {
            ArrayList<ScopedSession> list = new ArrayList<ScopedSession>();
            while (it.hasNext()) {
                Session session = (Session)it.next();
                list.add(new ScopedSession(session));
            }
            return list.iterator();
        }
        return it;
    }

    public SipSession getSipSession(String id) {
        Session session = (Session)this._appSession.getSipSession(id);
        if (session != null) {
            return new ScopedSession(session);
        }
        return null;
    }

    public ServletTimer getTimer(String id) {
        ServletTimer timer = this._appSession.getTimer(id);
        if (timer != null) {
            return new ScopedTimer(timer);
        }
        return null;
    }

    public Collection<ServletTimer> getTimers() {
        Iterator<ServletTimer> it = this._appSession.getTimers().iterator();
        if (!it.hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<ServletTimer> timers = new ArrayList<ServletTimer>();
        while (it.hasNext()) {
            timers.add(new ScopedTimer(it.next()));
        }
        return timers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        SessionManager.SessionScope scope = this.openScope();
        try {
            this._appSession.invalidate();
        }
        finally {
            scope.close();
        }
    }

    public boolean isReadyToInvalidate() {
        return this._appSession.isReadyToInvalidate();
    }

    public boolean isValid() {
        return this._appSession.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        SessionManager.SessionScope scope = this.openScope();
        try {
            this._appSession.removeAttribute(name);
        }
        finally {
            scope.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        SessionManager.SessionScope scope = this.openScope();
        try {
            this._appSession.setAttribute(name, value);
        }
        finally {
            scope.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setExpires(int deltaMinutes) {
        SessionManager.SessionScope scope = this.openScope();
        try {
            int n = this._appSession.setExpires(deltaMinutes);
            return n;
        }
        finally {
            scope.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInvalidateWhenReady(boolean invalidateWhenReady) {
        SessionManager.SessionScope scope = this.openScope();
        try {
            this._appSession.setInvalidateWhenReady(invalidateWhenReady);
        }
        finally {
            scope.close();
        }
    }

    @Override
    public AppSession getAppSession() {
        return this._appSession;
    }

    public String toString() {
        return this._appSession.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof AppSessionIf)) {
            return false;
        }
        return this._appSession.equals(((AppSessionIf)o).getAppSession());
    }

    public int hashCode() {
        return this._appSession.hashCode();
    }
}

