/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.session;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletResponse;
import org.cipango.server.ID;
import org.cipango.server.SipHandler;
import org.cipango.server.SipMessage;
import org.cipango.server.SipRequest;
import org.cipango.server.SipResponse;
import org.cipango.server.session.AppSession;
import org.cipango.server.session.Session;
import org.cipango.server.transaction.ServerTransaction;
import org.cipango.servlet.SipServletHandler;
import org.cipango.servlet.SipServletHolder;
import org.cipango.sip.SipException;
import org.cipango.sipapp.SipAppContext;
import org.cipango.util.ExceptionUtil;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class SipSessionHandler
extends AbstractHandler
implements SipHandler {
    private static final Logger LOG = Log.getLogger(SipSessionHandler.class);

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        throw new UnsupportedOperationException("sip-only handler");
    }

    public void handle(SipServletMessage message) throws IOException, ServletException {
        if (((SipMessage)message).isRequest()) {
            this.handleRequest((SipRequest)message);
        }
    }

    public void handleRequest(SipRequest request) throws IOException, ServletException {
        Session session = null;
        if (request.isInitial()) {
            AppSession appSession;
            SipAppContext appContext = (SipAppContext)request.getHandlerAttribute("context");
            SipServletHolder handler = ((SipServletHandler)appContext.getServletHandler()).findHolder(request);
            if (handler == null) {
                LOG.debug("SIP application {} has no matching servlet for {}", new Object[]{appContext.getName(), request.getMethod()});
                if (!request.isAck()) {
                    SipResponse response = (SipResponse)request.createResponse(404);
                    response.to().setParameter("tag", ID.newTag());
                    ((ServerTransaction)request.getTransaction()).send(response);
                }
                return;
            }
            String key = (String)request.getHandlerAttribute("session.key");
            if (key != null) {
                String id = ID.getIdFromKey(appContext.getName(), key);
                appSession = request.getCallSession().getAppSession(id);
                if (appSession == null) {
                    appSession = request.getCallSession().createAppSession(appContext, id);
                }
            } else {
                appSession = request.getCallSession().createAppSession(appContext, ID.newAppSessionId());
            }
            session = appSession.createSession();
            session.setHandler(handler);
            session.setSubscriberURI(request.getSubscriberURI());
            session.setRegion(request.getRegion());
            if (LOG.isDebugEnabled()) {
                LOG.debug("new session {}", new Object[]{session});
            }
        } else {
            session = request.getCallSession().findSession(request);
            if (session == null) {
                if (!request.isAck()) {
                    SipResponse response = (SipResponse)request.createResponse(481);
                    ((ServerTransaction)request.getTransaction()).send(response);
                }
                return;
            }
        }
        if (request.isInvite()) {
            SipResponse response = (SipResponse)request.createResponse(100);
            ((ServerTransaction)request.getTransaction()).send(response);
        }
        request.setSession(session);
        try {
            session.handleRequest(request);
        }
        catch (Exception e) {
            if (!request.isAck() && !request.isCommitted()) {
                SipServletResponse response;
                int code = 500;
                if (e instanceof SipException) {
                    code = ((SipException)e).getCode();
                }
                if (code == 500) {
                    response = request.createResponse(500, "Error in handler: " + e.getMessage());
                    ExceptionUtil.fillStackTrace((SipServletMessage)response, e);
                } else {
                    response = request.createResponse(code);
                }
                response.send();
            }
            LOG.debug((Throwable)e);
        }
    }
}

