/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.session;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.sip.SipSession;
import org.cipango.log.event.Events;
import org.cipango.server.Server;
import org.cipango.server.SipRequest;
import org.cipango.server.SipResponse;
import org.cipango.server.session.AppSession;
import org.cipango.server.session.CallSession;
import org.cipango.server.session.Session;
import org.cipango.server.transaction.ClientTransaction;
import org.cipango.server.transaction.ServerTransaction;
import org.cipango.server.transaction.Transaction;
import org.cipango.sipapp.SipAppContext;
import org.cipango.util.TimerList;
import org.cipango.util.TimerQueue;
import org.cipango.util.TimerTask;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.statistic.CounterStatistic;
import org.eclipse.jetty.util.statistic.SampleStatistic;

public class SessionManager
extends AbstractLifeCycle {
    private static final Logger LOG = Log.getLogger(SessionManager.class);
    protected Map<String, CSession> _sessions = new HashMap<String, CSession>(1024);
    protected TimerQueue<CSession> _queue = new TimerQueue(1024);
    private Thread _scheduler;
    private int _priorityOffset;
    private File _storeDir;
    private Server _server;
    private CounterStatistic _sessionsStats = new CounterStatistic();
    private SampleStatistic _sessionTimeStats = new SampleStatistic();
    private int _callsThreshold = 0;

    protected void doStart() throws Exception {
        if (this._storeDir != null) {
            if (!this._storeDir.exists()) {
                this._storeDir.mkdir();
            }
            this.restoreSessions();
        }
        new Thread(new Scheduler()).start();
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this._scheduler != null) {
            this._scheduler.interrupt();
        }
        this._sessions.clear();
    }

    public void setPriorityOffset(int priorityOffset) {
        this._priorityOffset = priorityOffset;
    }

    public void setStoreDir(File storeDir) {
        this._storeDir = storeDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionScope openScope(String id) {
        CSession callSession = null;
        Map<String, CSession> map = this._sessions;
        synchronized (map) {
            callSession = this._sessions.get(id);
            if (callSession == null) {
                callSession = this.newSession(id);
                this._sessions.put(callSession.getId(), callSession);
                this._sessionsStats.increment();
                if (this._callsThreshold > 0 && this.getCallSessions() == this._callsThreshold) {
                    Events.fire(3, "Calls threshold reached: " + this.getCallSessions());
                }
            }
        }
        return new SessionScope(callSession._lock.tryLock() ? callSession : null);
    }

    public SessionScope openScope(CallSession callSession) {
        CSession csession = (CSession)callSession;
        csession._lock.lock();
        return new SessionScope(csession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(CSession callSession) {
        block12: {
            try {
                int holds = callSession._lock.getHoldCount();
                if (holds != 1) break block12;
                callSession.invalidateSessionsIfReady();
                long time = callSession.nextExecutionTime();
                if (time > 0L) {
                    while (time < System.currentTimeMillis()) {
                        callSession.runTimers();
                        time = callSession.nextExecutionTime();
                        if (time >= 0L) continue;
                    }
                    if (time > 0L) {
                        TimerQueue<CSession> timerQueue = this._queue;
                        synchronized (timerQueue) {
                            this._queue.offer(callSession, time);
                            this._queue.notifyAll();
                        }
                    }
                }
                if (callSession.isDone()) {
                    boolean removed = this.removeSession(callSession);
                    if (removed) {
                        this._sessionsStats.decrement();
                        this._sessionTimeStats.set(Math.round((double)(System.currentTimeMillis() - callSession.getCreationTime()) / 1000.0));
                    }
                } else {
                    this.saveSession(callSession);
                }
            }
            finally {
                callSession._lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeSession(CSession callSession) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("CallSession " + callSession.getId() + " is done.", new Object[0]);
        }
        Map<String, CSession> map = this._sessions;
        synchronized (map) {
            return this._sessions.remove(callSession.getId()) != null;
        }
    }

    protected CSession newSession(String id) {
        return new CSession(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallSession get(String callId) {
        Map<String, CSession> map = this._sessions;
        synchronized (map) {
            return this._sessions.get(callId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTimers(CSession csession) {
        csession._lock.lock();
        try {
            csession.runTimers();
        }
        finally {
            this.close(csession);
        }
    }

    public void saveSession(CSession session) {
        if (this._storeDir == null || !this._storeDir.exists()) {
            return;
        }
        if (!this._storeDir.canWrite()) {
            LOG.warn("Unable to save session. Session persistence storage directory " + this._storeDir.getAbsolutePath() + " is not writeable", new Object[0]);
            return;
        }
        try {
            File file = new File(this._storeDir, session.getId());
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            FileOutputStream fos = new FileOutputStream(file);
            session.save(fos);
            fos.close();
        }
        catch (Exception e) {
            LOG.warn("Problem persisting session " + session.getId(), (Throwable)e);
        }
    }

    public void restoreSessions() throws Exception {
        if (this._storeDir == null || !this._storeDir.exists()) {
            return;
        }
        if (!this._storeDir.canRead()) {
            LOG.warn("unable to restore sessions: cannot read from store directory " + this._storeDir.getAbsolutePath(), new Object[0]);
            return;
        }
        File[] files = this._storeDir.listFiles();
        for (int i = 0; files != null && i < files.length; ++i) {
            try {
                FileInputStream in = new FileInputStream(files[i]);
                CallSession session = this.restoreSession(in);
                in.close();
                files[i].delete();
                continue;
            }
            catch (Exception e) {
                LOG.warn("problem restoring session " + files[i].getName(), (Throwable)e);
            }
        }
    }

    public CallSession restoreSession(FileInputStream fis) throws Exception {
        DataInputStream in = new DataInputStream(fis);
        String id = in.readUTF();
        int nbAppSessions = in.readInt();
        for (int i = 0; i < nbAppSessions; ++i) {
            String appId = in.readUTF();
            System.out.println("read call: " + id + " / " + appId);
        }
        return null;
    }

    public void setServer(Server server) {
        this._server = server;
    }

    public Server getServer() {
        return this._server;
    }

    public void statsReset() {
        this._sessionsStats.reset((long)this.getCallSessions());
        this._sessionTimeStats.reset();
    }

    public int getCallSessions() {
        return (int)this._sessionsStats.getCurrent();
    }

    public int getCallSessionsMax() {
        return (int)this._sessionsStats.getMax();
    }

    public long getCallSessionsTotal() {
        return this._sessionsStats.getTotal();
    }

    public int getCallsThreshold() {
        return this._callsThreshold;
    }

    public void setCallsThreshold(int callsThreshold) {
        this._callsThreshold = callsThreshold;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CSession
    extends TimerQueue.Node
    implements CallSession {
        protected String _id;
        protected final long _created;
        protected TimerList _timers = new TimerList();
        protected List<ServerTransaction> _serverTransactions = new ArrayList<ServerTransaction>(1);
        protected List<ClientTransaction> _clientTransactions = new ArrayList<ClientTransaction>(1);
        protected List<AppSession> _appSessions = new ArrayList<AppSession>(1);
        private ReentrantLock _lock = new ReentrantLock();

        public CSession(String id) {
            this._id = id;
            this._created = System.currentTimeMillis();
        }

        @Override
        public String getId() {
            return this._id;
        }

        public long getCreationTime() {
            return this._created;
        }

        @Override
        public Server getServer() {
            return SessionManager.this.getServer();
        }

        @Override
        public TimerTask schedule(Runnable runnable, long delay) {
            this.assertLocked();
            TimerTask timer = new TimerTask(runnable, System.currentTimeMillis() + delay);
            this._timers.addTimer(timer);
            if (LOG.isDebugEnabled()) {
                LOG.debug("scheduled timer {} for call session: {}", new Object[]{timer, this._id});
            }
            return timer;
        }

        @Override
        public void cancel(TimerTask timer) {
            this.assertLocked();
            if (LOG.isDebugEnabled()) {
                LOG.debug("canceled timer {} for call session: {}", new Object[]{timer, this._id});
            }
            if (timer != null) {
                timer.cancel();
                this._timers.remove(timer);
            }
        }

        @Override
        public void addServerTransaction(ServerTransaction transaction) {
            this._serverTransactions.add(transaction);
        }

        @Override
        public ServerTransaction getServerTransaction(String id) {
            for (int i = 0; i < this._serverTransactions.size(); ++i) {
                ServerTransaction transaction = this._serverTransactions.get(i);
                if (!transaction.getKey().equals(id)) continue;
                return transaction;
            }
            return null;
        }

        @Override
        public void removeServerTransaction(ServerTransaction transaction) {
            this._serverTransactions.remove(transaction);
        }

        @Override
        public void addClientTransaction(ClientTransaction transaction) {
            this._clientTransactions.add(transaction);
        }

        @Override
        public ClientTransaction getClientTransaction(String id) {
            for (int i = 0; i < this._clientTransactions.size(); ++i) {
                ClientTransaction transaction = this._clientTransactions.get(i);
                if (!transaction.getKey().equals(id)) continue;
                return transaction;
            }
            return null;
        }

        @Override
        public void removeClientTransaction(ClientTransaction transaction) {
            this._clientTransactions.remove(transaction);
        }

        @Override
        public List<ClientTransaction> getClientTransactions(SipSession session) {
            ArrayList<ClientTransaction> list = new ArrayList<ClientTransaction>(this._clientTransactions.size());
            for (int i = 0; i < this._clientTransactions.size(); ++i) {
                ClientTransaction transaction = this._clientTransactions.get(i);
                if (!transaction.getRequest().session().equals(session)) continue;
                list.add(transaction);
            }
            return list;
        }

        @Override
        public List<ServerTransaction> getServerTransactions(SipSession session) {
            ArrayList<ServerTransaction> list = new ArrayList<ServerTransaction>(this._serverTransactions.size());
            for (int i = 0; i < this._serverTransactions.size(); ++i) {
                ServerTransaction transaction = this._serverTransactions.get(i);
                if (!transaction.getRequest().session().equals(session)) continue;
                list.add(transaction);
            }
            return list;
        }

        @Override
        public boolean hasActiveTransactions(SipSession session) {
            Transaction transaction;
            int i;
            for (i = 0; i < this._clientTransactions.size(); ++i) {
                transaction = this._clientTransactions.get(i);
                if (transaction.getState() >= 4 || !transaction.getRequest().session().equals(session)) continue;
                return true;
            }
            for (i = 0; i < this._serverTransactions.size(); ++i) {
                transaction = this._serverTransactions.get(i);
                if (transaction.getState() >= 4 || !transaction.getRequest().session().equals(session)) continue;
                return true;
            }
            return false;
        }

        @Override
        public AppSession createAppSession(SipAppContext context, String id) {
            AppSession appSession = this.newAppSession(this, id);
            appSession.setContext(context);
            this._appSessions.add(appSession);
            return appSession;
        }

        @Override
        public AppSession getAppSession(String id) {
            for (int i = 0; i < this._appSessions.size(); ++i) {
                AppSession appSession = this._appSessions.get(i);
                if (!appSession.getAppId().equals(id)) continue;
                return appSession;
            }
            return null;
        }

        @Override
        public void removeSession(AppSession appSession) {
            this._appSessions.remove(appSession);
        }

        @Override
        public Session findSession(SipRequest request) {
            String appSessionId = request.getParameter("app-session-id");
            if (appSessionId != null) {
                AppSession appSession = this.getAppSession(appSessionId);
                return appSession == null ? null : appSession.getSession(request);
            }
            for (int i = 0; i < this._appSessions.size(); ++i) {
                AppSession appSession = this._appSessions.get(i);
                Session session = appSession.getSession(request);
                if (session == null) continue;
                return session;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("could not find session for request {}", new Object[]{request.getRequestLine()});
            }
            return null;
        }

        @Override
        public Session findSession(SipResponse response) {
            for (int i = 0; i < this._appSessions.size(); ++i) {
                AppSession appSession = this._appSessions.get(i);
                Session session = appSession.getSession(response);
                if (session == null) continue;
                return session;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("could not find session for response {}", new Object[]{response.getRequestLine()});
            }
            return null;
        }

        protected AppSession newAppSession(CallSession callSession, String id) {
            return new AppSession(callSession, id);
        }

        protected boolean isDone() {
            return this._timers.isEmpty() && this._appSessions.isEmpty();
        }

        protected long nextExecutionTime() {
            TimerTask timer = this._timers.peek();
            return timer != null ? timer.getExecutionTime() : -1L;
        }

        protected void runTimers() {
            long now = System.currentTimeMillis();
            TimerTask timer = null;
            while ((timer = this._timers.getExpired(now)) != null) {
                if (timer.isCancelled()) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("running timer {} for call session {}", new Object[]{timer, this._id});
                }
                try {
                    timer.getRunnable().run();
                }
                catch (Throwable t) {
                    LOG.warn(t);
                }
            }
        }

        protected void invalidateSessionsIfReady() {
            int i = this._appSessions.size();
            while (i-- > 0) {
                this._appSessions.get(i).invalidateIfReady();
            }
        }

        protected void save(FileOutputStream fos) throws IOException {
        }

        private void assertLocked() {
            if (!this._lock.isHeldByCurrentThread()) {
                throw new IllegalStateException("CallSession " + this._id + " is not locked by thread " + Thread.currentThread());
            }
        }

        protected ReentrantLock getLock() {
            return this._lock;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this._id + "[stxs= " + new ArrayList<ServerTransaction>(this._serverTransactions) + ", ctxs=" + new ArrayList<ClientTransaction>(this._clientTransactions) + ", timers=" + new ArrayList<TimerTask>(this._timers) + ", sessions=" + new ArrayList<AppSession>(this._appSessions) + "]");
            return sb.toString();
        }
    }

    class Scheduler
    implements Runnable {
        Scheduler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            SessionManager.this._scheduler = Thread.currentThread();
            String name = SessionManager.this._scheduler.getName();
            SessionManager.this._scheduler.setName("session-scheduler");
            int priority = SessionManager.this._scheduler.getPriority();
            try {
                SessionManager.this._scheduler.setPriority(priority + SessionManager.this._priorityOffset);
                do {
                    try {
                        long timeout;
                        CSession csession;
                        TimerQueue<CSession> timerQueue = SessionManager.this._queue;
                        synchronized (timerQueue) {
                            csession = SessionManager.this._queue.peek();
                            long l = timeout = csession != null ? csession.nextExecutionTime() - System.currentTimeMillis() : Long.MAX_VALUE;
                            if (timeout > 0L) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("waiting {} ms for call session: {}", new Object[]{timeout, csession});
                                }
                                SessionManager.this._queue.wait(timeout);
                            } else {
                                SessionManager.this._queue.poll();
                            }
                        }
                        if (timeout > 0L) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("running timers for call session: {}", new Object[]{csession});
                        }
                        SessionManager.this.runTimers(csession);
                    }
                    catch (InterruptedException e) {
                    }
                    catch (Throwable t) {
                        LOG.warn(t);
                    }
                } while (SessionManager.this.isRunning());
            }
            finally {
                SessionManager.this._scheduler.setName(name);
                SessionManager.this._scheduler.setPriority(priority);
                SessionManager.this._scheduler = null;
                String exit = "session-scheduler exited";
                if (SessionManager.this.isStarted()) {
                    LOG.warn(exit, new Object[0]);
                } else {
                    LOG.debug(exit, new Object[0]);
                }
            }
        }
    }

    public class SessionScope {
        private CSession _csession;

        public SessionScope(CSession csession) {
            this._csession = csession;
        }

        public CallSession getCallSession() {
            return this._csession;
        }

        public void close() {
            if (this._csession != null) {
                SessionManager.this.close(this._csession);
            }
        }
    }
}

