/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.session;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.sip.Address;
import javax.servlet.sip.Proxy;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipSessionAttributeListener;
import javax.servlet.sip.SipSessionBindingEvent;
import javax.servlet.sip.SipSessionBindingListener;
import javax.servlet.sip.SipSessionEvent;
import javax.servlet.sip.SipSessionListener;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.TooManyHopsException;
import javax.servlet.sip.UAMode;
import javax.servlet.sip.URI;
import javax.servlet.sip.ar.SipApplicationRoutingRegion;
import org.cipango.server.ID;
import org.cipango.server.Server;
import org.cipango.server.SipConnection;
import org.cipango.server.SipConnector;
import org.cipango.server.SipMessage;
import org.cipango.server.SipRequest;
import org.cipango.server.SipResponse;
import org.cipango.server.session.AppSession;
import org.cipango.server.session.CallSession;
import org.cipango.server.session.SessionIf;
import org.cipango.server.session.scope.ScopedAppSession;
import org.cipango.server.transaction.ClientTransaction;
import org.cipango.server.transaction.ClientTransactionListener;
import org.cipango.server.transaction.ServerTransaction;
import org.cipango.server.transaction.ServerTransactionListener;
import org.cipango.server.transaction.Transaction;
import org.cipango.servlet.SipServletHolder;
import org.cipango.sip.NameAddr;
import org.cipango.sip.RAck;
import org.cipango.sip.SipException;
import org.cipango.sip.SipFields;
import org.cipango.sip.SipHeaders;
import org.cipango.sipapp.SipAppContext;
import org.cipango.util.ReadOnlyAddress;
import org.cipango.util.TimerTask;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Session
implements SessionIf {
    private static final Logger LOG = Log.getLogger(Session.class);
    protected String _id;
    private AppSession _appSession;
    protected boolean _invalidateWhenReady = true;
    protected SipSession.State _state = SipSession.State.INITIAL;
    private boolean _valid = true;
    protected long _created = System.currentTimeMillis();
    protected long _lastAccessed;
    private SipServletHolder _handler;
    protected SipApplicationRoutingRegion _region;
    protected URI _subscriberURI;
    protected Map<String, Object> _attributes;
    protected String _callId;
    protected NameAddr _localParty;
    protected NameAddr _remoteParty;
    protected Role _role = Role.UNDEFINED;
    protected UA _ua;
    protected String _linkedSessionId;

    public Session(AppSession appSession, String id) {
        this._appSession = appSession;
        this._id = id;
    }

    public Session(AppSession appSession, String id, String callId, NameAddr local, NameAddr remote) {
        this(appSession, id);
        this._callId = callId;
        this._localParty = local;
        this._remoteParty = remote;
    }

    public Session(String id, Session other) {
        this(other._appSession, id);
        this._invalidateWhenReady = other._invalidateWhenReady;
        this._handler = other._handler;
        this._callId = other._callId;
        this._localParty = (NameAddr)other._localParty.clone();
        this._remoteParty = (NameAddr)other._remoteParty.clone();
        this._role = other._role;
        if (this._role == Role.UAS) {
            this._localParty.removeParameter("tag");
        } else {
            this._remoteParty.removeParameter("tag");
        }
        if (other._ua != null) {
            this._ua = new UA(other._ua);
        }
        if (other._attributes != null) {
            this._attributes = this.newAttributeMap();
            this._attributes.putAll(other._attributes);
        }
    }

    @Override
    public Session getSession() {
        return this;
    }

    public SipServletRequest createRequest(String method) {
        this.checkValid();
        if (!this.isUA()) {
            throw new IllegalStateException("session is " + (Object)((Object)this._role));
        }
        return this._ua.createRequest(method);
    }

    public SipApplicationSession getApplicationSession() {
        return new ScopedAppSession(this._appSession);
    }

    public Object getAttribute(String name) {
        this.checkValid();
        if (name == null) {
            throw new NullPointerException("Attribute name is null");
        }
        if (this._attributes == null) {
            return null;
        }
        return this._attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        this.checkValid();
        List<Object> names = this._attributes == null ? Collections.emptyList() : new ArrayList<String>(this._attributes.keySet());
        return Collections.enumeration(names);
    }

    public String getCallId() {
        return this._callId;
    }

    public long getCreationTime() {
        this.checkValid();
        return this._created;
    }

    public String getId() {
        return this._id;
    }

    public boolean getInvalidateWhenReady() {
        this.checkValid();
        return this._invalidateWhenReady;
    }

    public long getLastAccessedTime() {
        return this._lastAccessed;
    }

    public Address getLocalParty() {
        return new ReadOnlyAddress(this._localParty);
    }

    public SipApplicationRoutingRegion getRegion() {
        this.checkValid();
        return this._region;
    }

    public Address getRemoteParty() {
        return new ReadOnlyAddress(this._remoteParty);
    }

    public ServletContext getServletContext() {
        return this._appSession.getContext().getServletContext();
    }

    public SipSession.State getState() {
        this.checkValid();
        return this._state;
    }

    public URI getSubscriberURI() {
        this.checkValid();
        return this._subscriberURI;
    }

    public void invalidate() {
        this.checkValid();
        if (LOG.isDebugEnabled()) {
            LOG.debug("invalidating SipSession " + this, new Object[0]);
        }
        this._valid = false;
        this._appSession.removeSession(this);
    }

    public boolean isReadyToInvalidate() {
        this.checkValid();
        if (this._lastAccessed == 0L) {
            return false;
        }
        if (this._state == SipSession.State.TERMINATED) {
            return true;
        }
        if (this.isUA() && this._state == SipSession.State.INITIAL) {
            return !this.hasTransactions();
        }
        return false;
    }

    public boolean isValid() {
        return this._valid;
    }

    public void removeAttribute(String name) {
        this.checkValid();
        if (this._attributes == null) {
            return;
        }
        Object oldValue = this._attributes.remove(name);
        if (oldValue != null) {
            this.unbindValue(name, oldValue);
            SipSessionAttributeListener[] listeners = this._appSession.getContext().getSessionAttributeListeners();
            if (listeners.length > 0) {
                SipSessionBindingEvent e = new SipSessionBindingEvent((SipSession)this, name);
                for (SipSessionAttributeListener listener : listeners) {
                    listener.attributeRemoved(e);
                }
            }
        }
    }

    public void setAttribute(String name, Object value) {
        Object oldValue;
        this.checkValid();
        if (name == null || value == null) {
            throw new NullPointerException("name or value is null");
        }
        if (this._attributes == null) {
            this._attributes = this.newAttributeMap();
        }
        if ((oldValue = this._attributes.put(name, value)) == null || !value.equals(oldValue)) {
            this.unbindValue(name, oldValue);
            this.bindValue(name, value);
            SipSessionAttributeListener[] listeners = this._appSession.getContext().getSessionAttributeListeners();
            if (listeners.length > 0) {
                SipSessionBindingEvent e = new SipSessionBindingEvent((SipSession)this, name);
                for (SipSessionAttributeListener listener : listeners) {
                    if (oldValue == null) {
                        listener.attributeAdded(e);
                        continue;
                    }
                    listener.attributeReplaced(e);
                }
            }
        }
    }

    public void setHandler(String name) throws ServletException {
        this.checkValid();
        SipAppContext context = this._appSession.getContext();
        SipServletHolder handler = context.getSipServletHandler().getHolder(name);
        if (handler == null) {
            throw new ServletException("No handler named " + name);
        }
        this.setHandler(handler);
    }

    public void setInvalidateWhenReady(boolean b) {
        this.checkValid();
        this._invalidateWhenReady = b;
    }

    public void setOutboundInterface(InetSocketAddress address) {
        this.checkValid();
        if (address == null) {
            throw new NullPointerException("Null address");
        }
    }

    public void setOutboundInterface(InetAddress address) {
        this.checkValid();
        if (address == null) {
            throw new NullPointerException("Null address");
        }
    }

    public void sendResponse(SipResponse response, ServerTransaction tx, boolean reliable) throws IOException {
        if (this._role == Role.UNDEFINED) {
            this.createUA(UAMode.UAS);
        }
        if (this.isUA()) {
            this._ua.sendResponse(response, reliable);
        } else {
            this.sendVirtual(response);
        }
    }

    public void sendVirtual(SipResponse response) throws IOException {
        this._role = Role.UAS;
        this._ua = new UA();
        NameAddr tmp = this._remoteParty;
        this._remoteParty = this._localParty;
        this._localParty = tmp;
        this._ua.sendResponse(response, false);
    }

    public void handleRequest(SipRequest request) throws SipException, IOException {
        this.accessed();
        Proxy proxy = null;
        if (request.isInitial()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("initial request {} for session {}", new Object[]{request.getRequestLine(), this});
            }
            this._localParty = (NameAddr)request.to().clone();
            this._remoteParty = (NameAddr)request.from().clone();
            this._callId = request.getCallId();
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("subsequent request {} for session {}", new Object[]{request.getRequestLine(), this});
            }
            if (this.isUA()) {
                this._ua.handleRequest(request);
                if (request.isHandled()) {
                    return;
                }
            } else if (this.isProxy()) {
                try {
                    proxy = request.getProxy();
                }
                catch (TooManyHopsException e) {
                    throw new SipException(483);
                }
            }
        }
        this.invokeServlet(request);
        if (proxy != null && !request.isCancel()) {
            proxy.proxyTo(request.getRequestURI());
        }
    }

    public ClientTransaction sendRequest(SipRequest request, ClientTransactionListener listener) throws IOException {
        this.accessed();
        Server server = this.getServer();
        server.customizeRequest(request);
        request.setCommitted(true);
        return server.getTransactionManager().sendRequest(request, listener);
    }

    public ClientTransaction sendRequest(SipRequest request) throws IOException {
        if (!this.isUA()) {
            throw new IllegalStateException("Session is not UA");
        }
        ClientTransaction tx = this.sendRequest(request, this._ua);
        this._ua.requestSent(request);
        return tx;
    }

    public void invokeServlet(SipRequest request) throws SipException {
        try {
            this._appSession.getContext().handle(request);
        }
        catch (TooManyHopsException e) {
            throw new SipException(483);
        }
        catch (Throwable t) {
            throw new SipException(500, t);
        }
    }

    public void invokeServlet(SipResponse response) {
        try {
            if (this.isValid()) {
                this._appSession.getContext().handle(response);
            }
        }
        catch (Throwable t) {
            LOG.debug(t);
        }
    }

    private void accessed() {
        this._lastAccessed = System.currentTimeMillis();
        this._appSession.access(this._lastAccessed);
    }

    public void setState(SipSession.State newState) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} -> {}", new Object[]{this, newState});
        }
        this._state = newState;
    }

    public void updateState(SipResponse response, boolean uac) {
        SipRequest request = (SipRequest)response.getRequest();
        int status = response.getStatus();
        if (request.isInitial() && (request.isInvite() || request.isSubscribe())) {
            switch (this._state) {
                case INITIAL: {
                    if (status < 300) {
                        if ((uac || !this.isUA()) && response.getTo().getParameter("tag") == null) break;
                        if (this._ua != null) {
                            this._ua.createDialog(response, uac);
                        } else if (this.isProxy()) {
                            this.createProxyDialog(response);
                        }
                        if (status < 200) {
                            this.setState(SipSession.State.EARLY);
                            break;
                        }
                        this.setState(SipSession.State.CONFIRMED);
                        break;
                    }
                    if (uac) {
                        this._ua.resetDialog();
                        this.setState(SipSession.State.INITIAL);
                        break;
                    }
                    this.setState(SipSession.State.TERMINATED);
                    break;
                }
                case EARLY: {
                    if (200 <= status && status < 300) {
                        this.setState(SipSession.State.CONFIRMED);
                        break;
                    }
                    if (status < 300) break;
                    if (uac) {
                        this.setState(SipSession.State.INITIAL);
                        break;
                    }
                    this.setState(SipSession.State.TERMINATED);
                }
            }
        } else if (request.isBye() && response.is2xx()) {
            this.setState(SipSession.State.TERMINATED);
        }
    }

    protected void createProxyDialog(SipResponse response) {
        String tag = response.to().getParameter("tag");
        this._remoteParty.setParameter("tag", tag);
    }

    public void invalidateIfReady() {
        if (this.isValid() && this.getInvalidateWhenReady() && this.isReadyToInvalidate()) {
            SipAppContext context = this._appSession.getContext();
            SipSessionListener[] listeners = context.getSipSessionListeners();
            if (listeners.length > 0) {
                context.fire((EventListener[])listeners, AppSession.__sessionReadyToInvalidate, new SipSessionEvent((SipSession)this));
            }
            if (this.isValid() && this.getInvalidateWhenReady()) {
                this.invalidate();
            }
        }
    }

    private void checkValid() {
        if (!this._valid) {
            throw new IllegalStateException("Session has been invalidated");
        }
    }

    public boolean isUA() {
        return this._ua != null;
    }

    public UA getUA() {
        return this._ua;
    }

    public void createUA(UAMode mode) {
        if (this._role != Role.UNDEFINED) {
            throw new IllegalStateException("Session is " + (Object)((Object)this._role));
        }
        this._role = mode == UAMode.UAC ? Role.UAC : Role.UAS;
        this._ua = new UA();
    }

    public boolean isProxy() {
        return this._role == Role.PROXY;
    }

    public void setProxy() {
        if (this.isUA()) {
            throw new IllegalStateException("session is " + (Object)((Object)this._role));
        }
        NameAddr tmp = this._remoteParty;
        this._remoteParty = this._localParty;
        this._localParty = tmp;
        this._role = Role.PROXY;
    }

    public boolean isDialog(String fromTag, String toTag) {
        String localTag = this._localParty.getParameter("tag");
        String remoteTag = this._remoteParty.getParameter("tag");
        if (fromTag.equals(localTag) && toTag.equals(remoteTag)) {
            return true;
        }
        return toTag.equals(localTag) && fromTag.equals(remoteTag);
    }

    public boolean isSameDialog(SipResponse response) {
        String responseTag;
        String remoteTag = this._remoteParty.getParameter("tag");
        return remoteTag == null || (responseTag = response.to().getParameter("tag")) == null || remoteTag.equalsIgnoreCase(responseTag);
    }

    public SipServletHolder getHandler() {
        return this._handler;
    }

    public void setHandler(SipServletHolder handler) {
        this._handler = handler;
    }

    public void setSubscriberURI(URI uri) {
        this._subscriberURI = uri;
    }

    public void setRegion(SipApplicationRoutingRegion region) {
        this._region = region;
    }

    protected HashMap<String, Object> newAttributeMap() {
        return new HashMap<String, Object>(3);
    }

    private void bindValue(String name, Object value) {
        if (value != null && value instanceof SipSessionBindingListener) {
            ((SipSessionBindingListener)value).valueBound(new SipSessionBindingEvent((SipSession)this, name));
        }
    }

    private void unbindValue(String name, Object value) {
        if (value != null && value instanceof SipSessionBindingListener) {
            ((SipSessionBindingListener)value).valueUnbound(new SipSessionBindingEvent((SipSession)this, name));
        }
    }

    public AppSession appSession() {
        return this._appSession;
    }

    public CallSession getCallSession() {
        return this._appSession.getCallSession();
    }

    public Server getServer() {
        return this._appSession.getCallSession().getServer();
    }

    private boolean hasTransactions() {
        return true;
    }

    public Address getContact() {
        return this.getContact(this.getServer().getConnectorManager().findConnector(2, null));
    }

    public Address getContact(SipConnector connector) {
        NameAddr address = new NameAddr(connector.getSipUri().clone());
        address.getURI().setParameter("app-session-id", this._appSession.getAppId());
        return address;
    }

    public Session clone() {
        return this;
    }

    public String toString() {
        return "[" + this._id + ",state=" + this._state + ", _role = " + (Object)((Object)this._role) + "]";
    }

    public boolean equals(Object o) {
        if (!(o instanceof SessionIf)) {
            return false;
        }
        return super.equals(((SessionIf)o).getSession());
    }

    public void setLinkedSession(Session session) {
        this._linkedSessionId = session != null ? session.getId() : null;
    }

    public Session getLinkedSession() {
        return this._linkedSessionId != null ? (Session)this._appSession.getSipSession(this._linkedSessionId) : null;
    }

    public boolean isTerminated() {
        return this._state == SipSession.State.TERMINATED || !this._valid;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class UA
    implements ClientTransactionListener,
    ServerTransactionListener {
        protected long _localCSeq = 1L;
        protected long _remoteCSeq = -1L;
        protected URI _remoteTarget;
        protected LinkedList<String> _routeSet;
        protected boolean _secure = false;
        private Object _serverInvites;
        private Object _clientInvites;
        protected long _remoteRSeq = -1L;
        protected long _localRSeq = 1L;

        protected UA() {
        }

        protected UA(UA other) {
            this._localCSeq = other._localCSeq;
        }

        public SipRequest createRequest(SipRequest srcRequest) {
            SipRequest request = (SipRequest)srcRequest.clone();
            request.getFields().remove((Buffer)SipHeaders.RECORD_ROUTE_BUFFER);
            request.getFields().remove((Buffer)SipHeaders.VIA_BUFFER);
            request.getFields().remove((Buffer)SipHeaders.CONTACT_BUFFER);
            this.setDialogHeaders(request, this._localCSeq++);
            request.setSession(Session.this);
            return request;
        }

        public SipServletRequest createRequest(String method) {
            if (method.equalsIgnoreCase("ACK") || method.equalsIgnoreCase("CANCEL")) {
                throw new IllegalArgumentException("Forbidden request method " + method);
            }
            if (Session.this._state == SipSession.State.TERMINATED) {
                throw new IllegalStateException("Cannot create request in TERMINATED state");
            }
            if (Session.this._state == SipSession.State.INITIAL && Session.this._role == Role.UAS) {
                throw new IllegalStateException("Cannot create request in INITIAL state and UAS mode");
            }
            return this.createRequest(method, this._localCSeq++);
        }

        public SipServletRequest createAck() {
            return this.createRequest("ACK", this._localCSeq);
        }

        public SipServletRequest createRequest(String method, long cseq) {
            SipRequest request = new SipRequest();
            request.setMethod(method.toUpperCase());
            this.setDialogHeaders(request, cseq);
            request.setSession(Session.this);
            if (Session.this._state == SipSession.State.INITIAL) {
                request.setInitial(true);
            }
            return request;
        }

        protected void setDialogHeaders(SipRequest request, long cseq) {
            SipFields fields = request.getFields();
            fields.setAddress((Buffer)SipHeaders.FROM_BUFFER, (Address)Session.this._localParty);
            fields.setAddress((Buffer)SipHeaders.TO_BUFFER, (Address)Session.this._remoteParty);
            if (this._remoteTarget != null) {
                request.setRequestURI(this._remoteTarget.clone());
            } else if (request.getRequestURI() == null) {
                request.setRequestURI(request.to().getURI());
            }
            if (this._routeSet != null) {
                fields.remove((Buffer)SipHeaders.ROUTE_BUFFER);
                for (String route : this._routeSet) {
                    fields.addString((Buffer)SipHeaders.ROUTE_BUFFER, route);
                }
            }
            fields.setString((Buffer)SipHeaders.CALL_ID_BUFFER, Session.this._callId);
            fields.setString((Buffer)SipHeaders.CSEQ_BUFFER, cseq + " " + request.getMethod());
            fields.setString((Buffer)SipHeaders.MAX_FORWARDS_BUFFER, "70");
            if (request.needsContact()) {
                fields.setAddress((Buffer)SipHeaders.CONTACT_BUFFER, Session.this.getContact());
            }
        }

        public void handleRequest(SipRequest request) throws IOException, SipException {
            if (request.getCSeq().getNumber() <= this._remoteCSeq && !request.isAck() && !request.isCancel()) {
                throw new SipException(500, "Out of order request");
            }
            this._remoteCSeq = request.getCSeq().getNumber();
            if (request.isInvite()) {
                this.setRemoteTarget(request);
            }
            if (request.isAck()) {
                ServerInvite invite = this.getServerInvite(this._remoteCSeq, false);
                if (invite == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("dropping ACK without INVITE context", new Object[0]);
                    }
                    request.setHandled(true);
                } else if (invite.getResponse() != null) {
                    invite.ack();
                } else {
                    request.setHandled(true);
                }
            } else if (request.isPrack()) {
                RAck rack = null;
                try {
                    rack = request.getRAck();
                }
                catch (Exception e) {
                    throw new SipException(400, e.getMessage());
                }
                ServerInvite invite = this.getServerInvite(rack.getCSeq(), false);
                if (invite == null || !invite.prack(rack.getRSeq())) {
                    throw new SipException(481, "No matching 100 rel for RAck " + rack);
                }
            }
        }

        @Override
        public void handleCancel(ServerTransaction transaction, SipRequest cancel) throws IOException {
            cancel.setSession(Session.this);
            if (transaction.isCompleted()) {
                LOG.debug("ignoring late cancel {}", new Object[]{transaction});
            } else {
                try {
                    transaction.getRequest().createResponse(487).send();
                    Session.this.setState(SipSession.State.TERMINATED);
                }
                catch (Exception e) {
                    LOG.debug("failed to cancel request", (Throwable)e);
                }
            }
            Session.this.invokeServlet(cancel);
        }

        @Override
        public void handleResponse(SipResponse response) {
            if (response.getStatus() == 100) {
                return;
            }
            if (!Session.this.isSameDialog(response)) {
                Session derived = Session.this._appSession.getSession(response);
                if (derived == null) {
                    derived = Session.this._appSession.createDerivedSession(Session.this);
                    if (Session.this._linkedSessionId != null) {
                        Session linkDerived = Session.this._appSession.createDerivedSession(Session.this.getLinkedSession());
                        linkDerived.setLinkedSession(derived);
                        derived.setLinkedSession(linkDerived);
                    }
                }
                derived._ua.handleResponse(response);
                return;
            }
            response.setSession(Session.this);
            Session.this.accessed();
            if (response.isInvite() && response.is2xx()) {
                long cseq = response.getCSeq().getNumber();
                ClientInvite invite = this.getClientInvite(cseq, true);
                if (invite._2xx != null || invite._ack != null) {
                    if (invite._ack != null) {
                        try {
                            ClientTransaction tx = (ClientTransaction)invite._ack.getTransaction();
                            Session.this.getServer().getConnectorManager().send(invite._ack, tx.getConnection());
                        }
                        catch (Exception e) {
                            LOG.ignore((Throwable)e);
                        }
                    }
                    return;
                }
                invite._2xx = response;
            } else if (response.isReliable1xx()) {
                long rseq = response.getRSeq();
                if (this._remoteRSeq != -1L && this._remoteRSeq + 1L != rseq) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Dropping 100rel with rseq {} since expecting {}", new Object[]{rseq, this._remoteRSeq + 1L});
                    }
                    return;
                }
                this._remoteRSeq = rseq;
                long cseq = response.getCSeq().getNumber();
                ClientInvite invite = this.getClientInvite(cseq, true);
                invite.addReliable1xx(response);
            } else {
                response.setCommitted(true);
            }
            Session.this.updateState(response, true);
            if (response.getStatus() < 300 && (response.isInvite() || response.isSubscribe())) {
                this.setRemoteTarget(response);
            }
            if (Session.this.isValid()) {
                Session.this.invokeServlet(response);
            }
        }

        public void sendResponse(SipResponse response, boolean reliable) throws IOException {
            ServerTransaction tx = (ServerTransaction)response.getTransaction();
            if (tx != null) {
                if (tx.isCompleted()) {
                    throw new IllegalStateException("transaction terminated for response " + response.getRequestLine());
                }
                tx.setListener(this);
            }
            Session.this.updateState(response, false);
            SipRequest request = (SipRequest)response.getRequest();
            if (request.isInitial() && response.to().getParameter("tag") == null) {
                String tag = Session.this._localParty.getParameter("tag");
                if (tag == null) {
                    tag = ID.newTag();
                }
                response.to().setParameter("tag", tag);
            }
            if (request.isInvite() || request.isSubscribe()) {
                this.setRemoteTarget(request);
            }
            if (request.isInvite()) {
                ServerInvite invite;
                int status = response.getStatus();
                long cseq = response.getCSeq().getNumber();
                if (200 <= status && status < 300) {
                    ServerInvite invite2 = this.getServerInvite(cseq, true);
                    invite2.set2xx(response);
                } else if (100 < status && status < 200 && reliable) {
                    ServerInvite invite3 = this.getServerInvite(cseq, true);
                    long rseq = this._localRSeq++;
                    response.getFields().addString((Buffer)SipHeaders.REQUIRE_BUFFER, "100rel");
                    response.setRSeq(rseq);
                    invite3.addReliable1xx(response);
                } else if (status >= 300 && (invite = this.getServerInvite(cseq, false)) != null) {
                    invite.stop1xxRetrans();
                }
            }
            if (tx != null) {
                tx.send(response);
            } else {
                Session.this.getServer().getConnectorManager().sendResponse(response);
            }
        }

        public void requestSent(SipRequest request) {
            ClientInvite invite;
            if (request.isAck()) {
                ClientInvite invite2 = this.getClientInvite(request.getCSeq().getNumber(), false);
                if (invite2 != null) {
                    invite2._2xx = null;
                    invite2._ack = request;
                }
            } else if (request.isPrack() && (invite = this.getClientInvite(request.getCSeq().getNumber(), false)) != null) {
                try {
                    invite.prack(request.getRAck().getRSeq());
                }
                catch (ServletParseException e) {
                    LOG.ignore((Throwable)e);
                }
            }
        }

        protected void resetDialog() {
            this._remoteTarget = Session.this._remoteParty.getURI();
            Session.this._remoteParty.setParameter("tag", null);
            this._remoteCSeq = -1L;
            this._routeSet = null;
            this._secure = false;
            this._remoteRSeq = -1L;
            this._localRSeq = 1L;
        }

        protected void createDialog(SipResponse response, boolean uac) {
            if (uac) {
                String tag = response.to().getParameter("tag");
                Session.this._remoteParty.setParameter("tag", tag);
                this.setRoute(response, true);
            } else {
                String tag = ID.newTag();
                Session.this._localParty.setParameter("tag", tag);
                SipRequest request = (SipRequest)response.getRequest();
                this._remoteCSeq = request.getCSeq().getNumber();
                this._secure = request.isSecure() && request.getRequestURI().getScheme().equals("sips");
                this.setRoute(request, false);
            }
        }

        protected void setRemoteTarget(SipMessage message) {
            Address contact = message.getFields().getAddress((Buffer)SipHeaders.CONTACT_BUFFER);
            if (contact != null) {
                this._remoteTarget = contact.getURI();
            }
        }

        protected void setRoute(SipMessage message, boolean reverse) {
            ListIterator<String> routes = message.getFields().getValues((Buffer)SipHeaders.RECORD_ROUTE_BUFFER);
            this._routeSet = new LinkedList();
            while (routes.hasNext()) {
                if (reverse) {
                    this._routeSet.addFirst(routes.next());
                    continue;
                }
                this._routeSet.addLast(routes.next());
            }
        }

        public boolean isSecure() {
            return this._secure;
        }

        @Override
        public void transactionTerminated(Transaction transaction) {
            if (transaction.isServer() && transaction.isInvite()) {
                long cseq = transaction.getRequest().getCSeq().getNumber();
                this.removeServerInvite(cseq);
            }
        }

        private ServerInvite getServerInvite(long cseq, boolean create) {
            int i = LazyList.size((Object)this._serverInvites);
            while (i-- > 0) {
                ServerInvite invite = (ServerInvite)LazyList.get((Object)this._serverInvites, (int)i);
                if (invite.getSeq() != cseq) continue;
                return invite;
            }
            if (create) {
                ServerInvite invite = new ServerInvite(cseq);
                this._serverInvites = LazyList.add((Object)this._serverInvites, (Object)invite);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("added server invite context with cseq " + cseq, new Object[0]);
                }
                return invite;
            }
            return null;
        }

        private ServerInvite removeServerInvite(long cseq) {
            int i = LazyList.size((Object)this._serverInvites);
            while (i-- > 0) {
                ServerInvite invite = (ServerInvite)LazyList.get((Object)this._serverInvites, (int)i);
                if (invite.getSeq() != cseq) continue;
                this._serverInvites = LazyList.remove((Object)this._serverInvites, (int)i);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("removed server invite context for cseq " + cseq, new Object[0]);
                }
                return invite;
            }
            return null;
        }

        private ClientInvite getClientInvite(long cseq, boolean create) {
            int i = LazyList.size((Object)this._clientInvites);
            while (i-- > 0) {
                ClientInvite invite = (ClientInvite)LazyList.get((Object)this._clientInvites, (int)i);
                if (invite.getCSeq() != cseq) continue;
                return invite;
            }
            if (create) {
                ClientInvite invite = new ClientInvite(cseq);
                this._clientInvites = LazyList.add((Object)this._clientInvites, (Object)invite);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("added client invite context with cseq " + cseq, new Object[0]);
                }
                return invite;
            }
            return null;
        }

        public List<SipServletResponse> getUncommitted1xx(UAMode mode) {
            ArrayList<SipResponse> list = null;
            if (mode == UAMode.UAS) {
                int i = LazyList.size((Object)this._serverInvites);
                while (i-- > 0) {
                    ServerInvite invite = (ServerInvite)LazyList.get((Object)this._serverInvites, (int)i);
                    int j = LazyList.size((Object)invite._reliable1xxs);
                    while (j-- > 0) {
                        ServerInvite.Reliable1xx reliable1xx = (ServerInvite.Reliable1xx)LazyList.get((Object)invite._reliable1xxs, (int)j);
                        SipResponse response = reliable1xx.getResponse();
                        if (response == null || response.isCommitted()) continue;
                        if (list == null) {
                            list = new ArrayList<SipResponse>();
                        }
                        list.add(response);
                    }
                }
            } else {
                int i = LazyList.size((Object)this._clientInvites);
                while (i-- > 0) {
                    ClientInvite invite = (ClientInvite)LazyList.get((Object)this._clientInvites, (int)i);
                    int j = LazyList.size((Object)invite._reliable1xxs);
                    while (j-- > 0) {
                        ClientInvite.Reliable1xxClient reliable1xx = (ClientInvite.Reliable1xxClient)LazyList.get((Object)invite._reliable1xxs, (int)j);
                        SipResponse response = reliable1xx.getResponse();
                        if (response == null || response.isCommitted()) continue;
                        if (list == null) {
                            list = new ArrayList();
                        }
                        list.add(response);
                    }
                }
            }
            if (list == null) {
                return Collections.emptyList();
            }
            return list;
        }

        public List<SipServletResponse> getUncommitted2xx(UAMode mode) {
            ArrayList<SipResponse> list = null;
            if (mode == UAMode.UAS) {
                int i = LazyList.size((Object)this._serverInvites);
                while (i-- > 0) {
                    ServerInvite invite = (ServerInvite)LazyList.get((Object)this._serverInvites, (int)i);
                    SipResponse response = invite.getResponse();
                    if (response == null || response.isCommitted()) continue;
                    if (list == null) {
                        list = new ArrayList();
                    }
                    list.add(response);
                }
            } else {
                int i = LazyList.size((Object)this._clientInvites);
                while (i-- > 0) {
                    ClientInvite invite = (ClientInvite)LazyList.get((Object)this._clientInvites, (int)i);
                    if (invite._2xx == null || invite._2xx.isCommitted()) continue;
                    if (list == null) {
                        list = new ArrayList<SipResponse>();
                    }
                    list.add(invite._2xx);
                }
            }
            if (list == null) {
                return Collections.emptyList();
            }
            return list;
        }

        @Override
        public void customizeRequest(SipRequest request, SipConnection connection) {
            if (request.needsContact()) {
                SipURI uri = connection.getConnector().getSipUri();
                Address contact = request.getFields().getAddress((Buffer)SipHeaders.CONTACT_BUFFER);
                SipURI contactUri = (SipURI)contact.getURI();
                contactUri.setHost(uri.getHost());
                contactUri.setPort(uri.getPort());
                if (uri.getTransportParam() != null) {
                    contactUri.setTransportParam(uri.getTransportParam());
                } else {
                    contactUri.removeParameter("transport");
                }
            }
        }

        class ServerInvite
        extends ReliableResponse {
            private Object _reliable1xxs;

            public ServerInvite(long cseq) {
                super(cseq);
            }

            public void set2xx(SipResponse response) {
                this.stop1xxRetrans();
                this.startRetrans(response);
            }

            public void addReliable1xx(SipResponse response) {
                Reliable1xx reliable1xx = new Reliable1xx(response.getRSeq());
                this._reliable1xxs = LazyList.add((Object)this._reliable1xxs, (Object)reliable1xx);
                reliable1xx.startRetrans(response);
            }

            public boolean prack(long rseq) {
                int i = LazyList.size((Object)this._reliable1xxs);
                while (i-- > 0) {
                    Reliable1xx reliable1xx = (Reliable1xx)LazyList.get((Object)this._reliable1xxs, (int)i);
                    if (reliable1xx.getSeq() != rseq) continue;
                    reliable1xx.ack();
                    this._reliable1xxs = LazyList.remove((Object)this._reliable1xxs, (int)i);
                    return true;
                }
                return false;
            }

            public void stop1xxRetrans() {
                int i = LazyList.size((Object)this._reliable1xxs);
                while (i-- > 0) {
                    Reliable1xx reliable1xx = (Reliable1xx)LazyList.get((Object)this._reliable1xxs, (int)i);
                    reliable1xx.stopRetrans();
                }
            }

            public void noAck() {
                if (Session.this.isValid()) {
                    Session.this._appSession.noAck(this.getResponse().getRequest(), this.getResponse());
                }
            }

            public long retransmit(long delay) {
                ServerTransaction tx = (ServerTransaction)this.getResponse().getTransaction();
                if (tx != null) {
                    tx.send(this.getResponse());
                } else {
                    try {
                        Session.this.getServer().getConnectorManager().sendResponse(this.getResponse());
                    }
                    catch (IOException e) {
                        LOG.debug((Throwable)e);
                    }
                }
                return Math.min(delay * 2L, (long)Transaction.__T2);
            }

            class Reliable1xx
            extends ReliableResponse {
                public Reliable1xx(long rseq) {
                    super(rseq);
                }

                public long retransmit(long delay) {
                    ServerTransaction tx = (ServerTransaction)this.getResponse().getTransaction();
                    if (tx.getState() == 3) {
                        tx.send(this.getResponse());
                        return delay * 2L;
                    }
                    return -1L;
                }

                public void noAck() {
                    if (Session.this.isValid()) {
                        Session.this._appSession.noPrack(this.getResponse().getRequest(), this.getResponse());
                    }
                }
            }
        }

        abstract class ReliableResponse {
            private static final int TIMER_RETRANS = 0;
            private static final int TIMER_WAIT_ACK = 1;
            private long _seq;
            protected SipResponse _response;
            private TimerTask[] _timers;
            private long _retransDelay = Transaction.__T1;

            public ReliableResponse(long seq) {
                this._seq = seq;
            }

            public long getSeq() {
                return this._seq;
            }

            public SipResponse getResponse() {
                return this._response;
            }

            public void startRetrans(SipResponse response) {
                this._response = response;
                this._timers = new TimerTask[2];
                this._timers[0] = Session.this.getCallSession().schedule(new Timer(0), this._retransDelay);
                this._timers[1] = Session.this.getCallSession().schedule(new Timer(1), 64 * Transaction.__T1);
            }

            public void stopRetrans() {
                this.cancelTimer(0);
                this._response = null;
            }

            public void ack() {
                this.stopRetrans();
                this.cancelTimer(1);
            }

            private void cancelTimer(int id) {
                TimerTask timer = this._timers[id];
                if (timer != null) {
                    Session.this.getCallSession().cancel(timer);
                }
                this._timers[id] = null;
            }

            public abstract long retransmit(long var1);

            public abstract void noAck();

            protected void timeout(int id) {
                switch (id) {
                    case 0: {
                        if (this._response == null) break;
                        this._retransDelay = this.retransmit(this._retransDelay);
                        if (this._retransDelay <= 0L) break;
                        this._timers[0] = Session.this.getCallSession().schedule(new Timer(0), this._retransDelay);
                        break;
                    }
                    case 1: {
                        this.cancelTimer(0);
                        if (this._response == null) break;
                        this.noAck();
                        this._response = null;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown id " + id);
                    }
                }
            }

            class Timer
            implements Runnable {
                private int _id;

                public Timer(int id) {
                    this._id = id;
                }

                public void run() {
                    ReliableResponse.this.timeout(this._id);
                }

                public String toString() {
                    return this._id == 0 ? "retrans" : "wait-ack";
                }
            }
        }

        class ClientInvite {
            private long _cseq;
            private SipRequest _ack;
            private SipResponse _2xx;
            private Object _reliable1xxs;

            public ClientInvite(long cseq) {
                this._cseq = cseq;
            }

            public long getCSeq() {
                return this._cseq;
            }

            public void addReliable1xx(SipResponse response) {
                Reliable1xxClient reliable1xx = new Reliable1xxClient(response);
                this._reliable1xxs = LazyList.add((Object)this._reliable1xxs, (Object)reliable1xx);
            }

            public boolean prack(long rseq) {
                int i = LazyList.size((Object)this._reliable1xxs);
                while (i-- > 0) {
                    Reliable1xxClient reliable1xx = (Reliable1xxClient)LazyList.get((Object)this._reliable1xxs, (int)i);
                    if (reliable1xx.getRSeq() != rseq) continue;
                    this._reliable1xxs = LazyList.remove((Object)this._reliable1xxs, (int)i);
                    return true;
                }
                return false;
            }

            class Reliable1xxClient {
                private SipResponse _1xx;

                public Reliable1xxClient(SipResponse response) {
                    this._1xx = response;
                }

                public long getRSeq() {
                    return this._1xx.getRSeq();
                }

                public SipResponse getResponse() {
                    return this._1xx;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Role {
        UNDEFINED,
        UAC,
        UAS,
        PROXY;

    }
}

