/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.session;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.cipango.server.session.AppSession;
import org.cipango.server.session.CallSession;
import org.cipango.server.session.Session;
import org.cipango.server.session.SessionManager;
import org.cipango.server.transaction.ClientTransaction;
import org.cipango.server.transaction.ServerTransaction;
import org.cipango.util.TimerTask;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallSessionViewer {
    private static final Logger LOG = Log.getLogger(CallSessionViewer.class);
    private SessionManager _sessionManager;

    public CallSessionViewer(SessionManager sessionManager) {
        this._sessionManager = sessionManager;
    }

    public String viewCall(String callId) {
        CallSession callSession = this._sessionManager.get(callId);
        if (callSession == null) {
            return "No call with ID " + callId + " found";
        }
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("+ ").append(callId).append('\n');
            SessionManager.CSession cSession = (SessionManager.CSession)callSession;
            Iterator<AppSession> it = cSession._appSessions.iterator();
            sb.append("\t+ [appSessions]\n");
            while (it.hasNext()) {
                this.printAppSession(sb, it.next());
            }
            Iterator<ClientTransaction> it2 = cSession._clientTransactions.iterator();
            if (it2.hasNext()) {
                sb.append("\t+ [clientTransaction]\n");
            }
            while (it2.hasNext()) {
                sb.append("\t\t+ ").append(it2.next()).append('\n');
            }
            Iterator<ServerTransaction> it3 = cSession._serverTransactions.iterator();
            if (it3.hasNext()) {
                sb.append("\t+ [serverTransaction]\n");
            }
            while (it3.hasNext()) {
                sb.append("\t\t+ ").append(it3.next()).append('\n');
            }
            Iterator it4 = cSession._timers.iterator();
            if (it4.hasNext()) {
                sb.append("\t+ [Timers]\n");
            }
            while (it4.hasNext()) {
                TimerTask task = (TimerTask)it4.next();
                sb.append("\t\t+ ").append(task).append('\n');
                this.printAttr(sb, "class", task.getRunnable().getClass().getName());
                this.printAttr(sb, "executionTime", new Date(task.getExecutionTime()));
            }
        }
        catch (Exception e) {
            sb.append("\n\n").append(e);
            LOG.warn((Throwable)e);
        }
        return sb.toString();
    }

    private void printAppSession(StringBuilder sb, AppSession appSession) {
        sb.append("\t\t+ ").append(appSession.getAppId()).append('\n');
        this.printAttr(sb, "created", new Date(appSession.getCreationTime()));
        this.printAttr(sb, "accessed", new Date(appSession.getLastAccessedTime()));
        this.printAttr(sb, "expirationTime", new Date(appSession.getExpirationTime()));
        this.printAttr(sb, "context", appSession.getContext().getName());
        this.printAttr(sb, "invalidateWhenReady", appSession.getInvalidateWhenReady());
        this.printAttr(sb, "attributes", appSession._attributes);
        Iterator<Session> it = appSession._sessions.iterator();
        if (it.hasNext()) {
            sb.append("\t\t\t+ [sipSessions]\n");
        }
        while (it.hasNext()) {
            Session session = it.next();
            sb.append("\t\t\t\t+ ").append(session.getId()).append('\n');
            this.printAttr(sb, "created", new Date(session.getCreationTime()), 5);
            this.printAttr(sb, "accessed", new Date(session.getLastAccessedTime()), 5);
            this.printAttr(sb, "role", (Object)session._role, 5);
            this.printAttr(sb, "state", session._state, 5);
            this.printAttr(sb, "invalidateWhenReady", session.getInvalidateWhenReady(), 5);
            this.printAttr(sb, "attributes", session._attributes, 5);
            this.printAttr(sb, "localParty", session._localParty, 5);
            this.printAttr(sb, "remoteParty", session._remoteParty, 5);
            this.printAttr(sb, "region", session._region, 5);
            this.printAttr(sb, "Call-ID", session._callId, 5);
            this.printAttr(sb, "linkedSessionId", session._linkedSessionId, 5);
            this.printAttr(sb, "subscriberURI", session._subscriberURI, 5);
            this.printAttr(sb, "handler", (Object)session.getHandler(), 5);
            Session.UA ua = session._ua;
            if (ua == null) continue;
            sb.append("\t\t\t\t\t+ [ua]\n");
            this.printAttr(sb, "local CSeq", ua._localCSeq, 6);
            this.printAttr(sb, "Remote CSeq", ua._remoteCSeq, 6);
            this.printAttr(sb, "Remote Target", ua._remoteTarget, 6);
            this.printAttr(sb, "route Set", ua._routeSet, 6);
            this.printAttr(sb, "Secure", ua._secure, 6);
            this.printAttr(sb, "local RSeq", ua._localRSeq, 6);
            this.printAttr(sb, "Remote RSeq", ua._remoteRSeq, 6);
        }
    }

    private void printAttr(StringBuilder sb, String name, Object value) {
        this.printAttr(sb, name, value, 3);
    }

    private void printAttr(StringBuilder sb, String name, Object value, int index) {
        for (int i = 0; i < index; ++i) {
            sb.append('\t');
        }
        sb.append("- ").append(name).append(": ").append(value).append('\n');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCallIds() {
        Map<String, SessionManager.CSession> map = this._sessionManager._sessions;
        synchronized (map) {
            return new ArrayList<String>(this._sessionManager._sessions.keySet());
        }
    }
}

