/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.session;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.sip.SipServletMessage;
import org.cipango.server.ID;
import org.cipango.server.Server;
import org.cipango.server.SipHandler;
import org.cipango.server.SipMessage;
import org.cipango.server.SipRequest;
import org.cipango.server.session.CallSession;
import org.cipango.server.session.SessionManager;
import org.cipango.sipapp.SipAppContext;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class CallSessionHandler
extends HandlerWrapper
implements SipHandler {
    private static final Logger LOG = Log.getLogger(CallSessionHandler.class);
    private Server _server;
    private Map<String, Queue> _queues = new HashMap<String, Queue>();

    protected void doStart() throws Exception {
        super.doStart();
        this._server = (Server)this.getServer();
    }

    public String getCallSessionId(SipMessage message) {
        if (message.isRequest()) {
            SipRequest request = (SipRequest)message;
            if (request.isInitial()) {
                String sessionKey = (String)request.getHandlerAttribute("session.key");
                if (sessionKey != null) {
                    SipAppContext context = (SipAppContext)request.getHandlerAttribute("context");
                    return ID.getIdFromKey(context.getName(), sessionKey);
                }
            } else {
                String appSessionId = request.getParameter("app-session-id");
                if (appSessionId != null && ID.isKey(appSessionId)) {
                    return appSessionId;
                }
            }
        } else {
            String appSessionId = message.getTopVia().getParameter("app-session-id");
            if (appSessionId != null && ID.isKey(appSessionId)) {
                return appSessionId;
            }
        }
        return ID.getCallSessionId(message.getCallId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(SipServletMessage message) throws IOException, ServletException {
        SipMessage baseMessage = (SipMessage)message;
        String id = this.getCallSessionId(baseMessage);
        if (LOG.isDebugEnabled()) {
            LOG.debug("handling message {} for call session: {}", new Object[]{baseMessage.getRequestLine(), id});
        }
        Queue queue = null;
        Map<String, Queue> map = this._queues;
        synchronized (map) {
            queue = this._queues.get(id);
            if (queue == null) {
                queue = new Queue(id);
                this._queues.put(id, queue);
            }
            queue.add(baseMessage);
        }
        queue.handle();
    }

    class Queue {
        private static final int INITIAL = 0;
        private static final int HANDLING = 1;
        private static final int DONE = 2;
        private String _id;
        private Object _messages;
        private int _state = 0;

        public Queue(String id) {
            this._id = id;
        }

        public synchronized void add(SipMessage message) {
            this._messages = LazyList.add((Object)this._messages, (Object)message);
        }

        public synchronized SipMessage poll() {
            if (LazyList.size((Object)this._messages) == 0) {
                return null;
            }
            SipMessage message = (SipMessage)LazyList.get((Object)this._messages, (int)0);
            this._messages = LazyList.remove((Object)this._messages, (int)0);
            return message;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isDone() {
            Map map = CallSessionHandler.this._queues;
            synchronized (map) {
                Queue queue = this;
                synchronized (queue) {
                    if (LazyList.size((Object)this._messages) == 0) {
                        CallSessionHandler.this._queues.remove(this._id);
                        this._state = 2;
                        return true;
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle() {
            Queue queue = this;
            synchronized (queue) {
                if (this._state != 0) {
                    return;
                }
                this._state = 1;
            }
            do {
                CallSession callSession = null;
                SessionManager.SessionScope scope = null;
                while (callSession == null) {
                    scope = CallSessionHandler.this._server.getSessionManager().openScope(this._id);
                    callSession = scope.getCallSession();
                    if (callSession != null) continue;
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException e) {}
                }
                try {
                    SipMessage message = null;
                    while ((message = this.poll()) != null) {
                        try {
                            message.setCallSession(callSession);
                            ((SipHandler)CallSessionHandler.this.getHandler()).handle(message);
                        }
                        catch (Exception e) {
                            LOG.ignore((Throwable)e);
                        }
                    }
                }
                finally {
                    scope.close();
                }
            } while (!this.isDone());
        }
    }
}

