/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.session;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.servlet.sip.ServletTimer;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipApplicationSessionAttributeListener;
import javax.servlet.sip.SipApplicationSessionBindingEvent;
import javax.servlet.sip.SipApplicationSessionBindingListener;
import javax.servlet.sip.SipApplicationSessionEvent;
import javax.servlet.sip.SipApplicationSessionListener;
import javax.servlet.sip.SipErrorEvent;
import javax.servlet.sip.SipErrorListener;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipSessionEvent;
import javax.servlet.sip.SipSessionListener;
import javax.servlet.sip.TimerListener;
import javax.servlet.sip.UAMode;
import javax.servlet.sip.URI;
import org.cipango.server.ID;
import org.cipango.server.SipMessage;
import org.cipango.server.session.AppSessionIf;
import org.cipango.server.session.CallSession;
import org.cipango.server.session.Session;
import org.cipango.sip.NameAddr;
import org.cipango.sipapp.SipAppContext;
import org.cipango.util.TimerTask;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppSession
implements AppSessionIf {
    private static final Logger LOG = Log.getLogger(AppSession.class);
    public static final String APP_ID_PREFIX = ";app-session-id=";
    protected static Method __noAck;
    protected static Method __noPrack;
    protected static Method __appSessionCreated;
    protected static Method __appSessionReadyToInvalidate;
    protected static Method __appSessionExpired;
    protected static Method __appSessionDestroyed;
    protected static Method __timerExpired;
    protected static Method __sessionCreated;
    protected static Method __sessionReadyToInvalidate;
    protected static Method __sessionDestroyed;
    private String _appId;
    private State _state = State.VALID;
    protected List<Session> _sessions = new ArrayList<Session>(1);
    private Object _otherSessions;
    private CallSession _callSession;
    protected SipAppContext _context;
    protected Map<String, Object> _attributes;
    protected long _created = System.currentTimeMillis();
    protected long _lastAccessed;
    protected int _expiryDelay;
    private List<ServletTimer> _timers;
    protected TimerTask _expiryTimer;
    protected boolean _invalidateWhenReady = true;

    public AppSession(CallSession callSession, String id) {
        this._callSession = callSession;
        this._appId = id;
    }

    public long getCreationTime() {
        this.checkValid();
        return this._created;
    }

    public long getLastAccessedTime() {
        return this._lastAccessed;
    }

    public String getId() {
        return this._callSession.getId() + ";" + this._appId;
    }

    public int setExpires(int deltaMinutes) {
        if (this._state != State.VALID && this._state != State.EXPIRED) {
            throw new IllegalStateException();
        }
        if (this._expiryTimer != null) {
            this._callSession.cancel(this._expiryTimer);
            this._expiryTimer = null;
        }
        this._expiryDelay = deltaMinutes;
        if (this._expiryDelay > 0) {
            long delayMs = (long)this._expiryDelay * 60000L;
            this._expiryTimer = this._callSession.schedule(new ExpiryTimeout(), delayMs);
            return this._expiryDelay;
        }
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        this.checkValid();
        if (LOG.isDebugEnabled()) {
            LOG.debug("invalidating SipApplicationSession: " + this, new Object[0]);
        }
        try {
            SipApplicationSessionListener[] listeners;
            if (this._expiryTimer != null) {
                this._callSession.cancel(this._expiryTimer);
                this._expiryTimer = null;
            }
            AppSession appSession = this;
            synchronized (appSession) {
                int i = this._sessions.size();
                while (i-- > 0) {
                    this._sessions.get(i).invalidate();
                }
                this._sessions.clear();
                i = LazyList.size((Object)this._otherSessions);
                while (i-- > 0) {
                    Object session = LazyList.get((Object)this._otherSessions, (int)i);
                    if (!(session instanceof HttpSession)) continue;
                    ((HttpSession)session).invalidate();
                }
                this._otherSessions = null;
                if (this._timers != null) {
                    Iterator<ServletTimer> it2 = this.getTimers().iterator();
                    while (it2.hasNext()) {
                        it2.next().cancel();
                    }
                }
            }
            this.getCallSession().removeSession(this);
            if (this.getContext() != null) {
                this.getContext().decrementSessions(System.currentTimeMillis() - this._created);
            }
            if ((listeners = this.getContext().getSipApplicationSessionListeners()).length > 0) {
                this.getContext().fire((EventListener[])listeners, __appSessionDestroyed, new SipApplicationSessionEvent((SipApplicationSession)this));
            }
            SipApplicationSessionAttributeListener[] attrListeners = this.getContext().getSipApplicationSessionAttributeListeners();
            while (this._attributes != null && this._attributes.size() > 0) {
                ArrayList<String> keys;
                AppSession appSession2 = this;
                synchronized (appSession2) {
                    keys = new ArrayList<String>(this._attributes.keySet());
                }
                for (String key : keys) {
                    Object value;
                    AppSession appSession3 = this;
                    synchronized (appSession3) {
                        value = this._attributes.remove(key);
                    }
                    this.unbindValue(key, value);
                    if (attrListeners == null) continue;
                    SipApplicationSessionBindingEvent event = new SipApplicationSessionBindingEvent((SipApplicationSession)this, key);
                    for (int i = 0; i < attrListeners.length; ++i) {
                        attrListeners[i].attributeRemoved(event);
                    }
                }
            }
        }
        finally {
            this._state = State.INVALID;
        }
    }

    protected void expired() {
        if (this._state == State.VALID) {
            this._state = State.EXPIRED;
            SipApplicationSessionListener[] listeners = this.getContext().getSipApplicationSessionListeners();
            if (listeners.length > 0) {
                this.getContext().fire((EventListener[])listeners, __appSessionExpired, new SipApplicationSessionEvent((SipApplicationSession)this));
            }
            if (this._state == State.EXPIRED) {
                if (this.getExpirationTime() != Long.MIN_VALUE) {
                    this._state = State.VALID;
                } else {
                    this.invalidate();
                }
            }
        }
    }

    public synchronized Session getSession(SipMessage message) {
        String ftag = message.from().getParameter("tag");
        String ttag = message.to().getParameter("tag");
        for (int i = 0; i < this._sessions.size(); ++i) {
            Session session = this._sessions.get(i);
            if (!session.isDialog(ftag, ttag)) continue;
            return session;
        }
        return null;
    }

    public synchronized Iterator<?> getSessions() {
        this.checkValid();
        ArrayList<Session> list = new ArrayList<Session>(this._sessions);
        list.addAll(LazyList.getList((Object)this._otherSessions));
        return list.iterator();
    }

    public synchronized Iterator<?> getSessions(String protocol) {
        this.checkValid();
        if (protocol == null) {
            throw new NullPointerException("null protocol");
        }
        if ("sip".equalsIgnoreCase(protocol)) {
            return this._sessions.iterator();
        }
        if ("http".equalsIgnoreCase(protocol)) {
            ArrayList<HttpSession> sessions = new ArrayList<HttpSession>();
            int i = LazyList.size((Object)this._otherSessions);
            while (i-- > 0) {
                Object session = LazyList.get((Object)this._otherSessions, (int)i);
                if (!(session instanceof HttpSession)) continue;
                sessions.add((HttpSession)session);
            }
            return sessions.iterator();
        }
        throw new IllegalArgumentException("Unknown protocol " + protocol);
    }

    public synchronized ServletTimer getTimer(String id) {
        this.checkValid();
        if (this._timers != null) {
            for (int i = 0; i < this._timers.size(); ++i) {
                ServletTimer timer = this._timers.get(i);
                if (!timer.getId().equals(id)) continue;
                return timer;
            }
        }
        return null;
    }

    public void encodeURI(URI uri) {
        this.checkValid();
        uri.setParameter("app-session-id", this.getId());
    }

    public synchronized Object getAttribute(String name) {
        this.checkValid();
        if (this._attributes == null) {
            return null;
        }
        return this._attributes.get(name);
    }

    public synchronized Iterator<String> getAttributeNames() {
        this.checkValid();
        if (this._attributes == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this._attributes.keySet().iterator();
    }

    public synchronized void setAttribute(String name, Object value) {
        Object oldValue;
        this.checkValid();
        if (value == null || name == null) {
            throw new NullPointerException("Name or attribute is null");
        }
        if (this._attributes == null) {
            this._attributes = new HashMap<String, Object>();
        }
        if ((oldValue = this._attributes.put(name, value)) == null || !value.equals(oldValue)) {
            this.unbindValue(name, oldValue);
            this.bindValue(name, value);
            SipApplicationSessionAttributeListener[] listeners = this.getContext().getSipApplicationSessionAttributeListeners();
            if (listeners.length > 0) {
                SipApplicationSessionBindingEvent event = new SipApplicationSessionBindingEvent((SipApplicationSession)this, name);
                for (int i = 0; i < listeners.length; ++i) {
                    if (oldValue == null) {
                        listeners[i].attributeAdded(event);
                        continue;
                    }
                    listeners[i].attributeReplaced(event);
                }
            }
        }
    }

    public synchronized void removeAttribute(String name) {
        this.checkValid();
        if (this._attributes == null) {
            return;
        }
        Object oldValue = this._attributes.remove(name);
        if (oldValue != null) {
            this.unbindValue(name, oldValue);
            SipApplicationSessionAttributeListener[] listeners = this.getContext().getSipApplicationSessionAttributeListeners();
            if (listeners != null) {
                SipApplicationSessionBindingEvent event = new SipApplicationSessionBindingEvent((SipApplicationSession)this, name);
                for (int i = 0; i < listeners.length; ++i) {
                    listeners[i].attributeRemoved(event);
                }
            }
        }
    }

    public Collection<ServletTimer> getTimers() {
        this.checkValid();
        if (this._timers == null) {
            return Collections.emptyList();
        }
        return new ArrayList<ServletTimer>(this._timers);
    }

    public void unbindValue(String name, Object value) {
        if (value != null && value instanceof SipApplicationSessionBindingListener) {
            ((SipApplicationSessionBindingListener)value).valueUnbound(new SipApplicationSessionBindingEvent((SipApplicationSession)this, name));
        }
    }

    public void bindValue(String name, Object value) {
        if (value != null && value instanceof SipApplicationSessionBindingListener) {
            ((SipApplicationSessionBindingListener)value).valueBound(new SipApplicationSessionBindingEvent((SipApplicationSession)this, name));
        }
    }

    public void setCallSession(CallSession callSession) {
        this._callSession = callSession;
    }

    public void access(long accessed) {
        this._lastAccessed = accessed;
        if (this._expiryTimer != null) {
            this._callSession.cancel(this._expiryTimer);
            this._expiryTimer = null;
        }
        if (this._expiryDelay > 0 && this.isValid()) {
            this._expiryTimer = this._callSession.schedule(new ExpiryTimeout(), (long)this._expiryDelay * 60000L);
        }
    }

    private void checkValid() {
        if (!this.isValid()) {
            throw new IllegalStateException("SipApplicationSession has been invalidated");
        }
    }

    public boolean isValid() {
        return this._state != State.INVALID;
    }

    public URL encodeURL(URL url) {
        this.checkValid();
        try {
            String sUrl = url.toExternalForm();
            String id = this.getId().replace(";", "%3B");
            int prefix = sUrl.indexOf(APP_ID_PREFIX);
            if (prefix != -1) {
                int suffix = sUrl.indexOf("?", prefix);
                if (suffix < 0) {
                    suffix = sUrl.indexOf("#", prefix);
                }
                if (suffix <= prefix) {
                    return new URL(sUrl.substring(0, prefix + APP_ID_PREFIX.length()) + id);
                }
                return new URL(sUrl.substring(0, prefix + APP_ID_PREFIX.length()) + id + sUrl.substring(suffix));
            }
            int suffix = sUrl.indexOf(63);
            if (suffix < 0) {
                suffix = sUrl.indexOf(35);
            }
            if (suffix < 0) {
                return new URL(sUrl + APP_ID_PREFIX + id);
            }
            return new URL(sUrl.substring(0, suffix) + APP_ID_PREFIX + id + sUrl.substring(suffix));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public String getApplicationName() {
        return this._context.getName();
    }

    public long getExpirationTime() {
        this.checkValid();
        if (this._expiryTimer == null) {
            return 0L;
        }
        long expirationTime = this._expiryTimer.getExecutionTime();
        if (expirationTime <= System.currentTimeMillis()) {
            return Long.MIN_VALUE;
        }
        return expirationTime;
    }

    public synchronized Object getSession(String id, SipApplicationSession.Protocol protocol) {
        block4: {
            block3: {
                this.checkValid();
                if (id == null || protocol == null) {
                    throw new NullPointerException(id == null ? "null id" : "null protocol");
                }
                if (protocol != SipApplicationSession.Protocol.SIP) break block3;
                for (Session session : this._sessions) {
                    if (!session.getId().equals(id)) continue;
                    return session;
                }
                break block4;
            }
            if (protocol != SipApplicationSession.Protocol.HTTP) break block4;
            int i = LazyList.size((Object)this._otherSessions);
            while (i-- > 0) {
                Object session = LazyList.get((Object)this._otherSessions, (int)i);
                if (!(session instanceof HttpSession) || !((HttpSession)session).getId().equals(id)) continue;
                return session;
            }
        }
        return null;
    }

    public SipSession getSipSession(String id) {
        return (SipSession)this.getSession(id, SipApplicationSession.Protocol.SIP);
    }

    public boolean isReadyToInvalidate() {
        this.checkValid();
        if (this._lastAccessed == 0L) {
            return false;
        }
        for (int i = 0; i < this._sessions.size(); ++i) {
            Session session = this._sessions.get(i);
            if (session.isReadyToInvalidate()) continue;
            return false;
        }
        if (LazyList.size((Object)this._otherSessions) != 0) {
            return false;
        }
        return this._timers == null || this._timers.isEmpty();
    }

    public void invalidateIfReady() {
        boolean invalidateSessionsWhenReady = true;
        for (int i = 0; i < this._sessions.size(); ++i) {
            Session session = this._sessions.get(i);
            if (session.getInvalidateWhenReady()) {
                session.invalidateIfReady();
                continue;
            }
            invalidateSessionsWhenReady = false;
        }
        if (this.isValid() && this.getInvalidateWhenReady() && invalidateSessionsWhenReady && this.isReadyToInvalidate()) {
            SipApplicationSessionListener[] listeners = this.getContext().getSipApplicationSessionListeners();
            if (listeners.length > 0) {
                this.getContext().fire((EventListener[])listeners, __appSessionReadyToInvalidate, new SipApplicationSessionEvent((SipApplicationSession)this));
            }
            if (this.getInvalidateWhenReady() && this.isValid()) {
                this.invalidate();
            }
        }
    }

    public void setInvalidateWhenReady(boolean invalidateWhenReady) {
        this.checkValid();
        this._invalidateWhenReady = invalidateWhenReady;
    }

    public boolean getInvalidateWhenReady() {
        this.checkValid();
        return this._invalidateWhenReady;
    }

    public SipAppContext getContext() {
        return this._context;
    }

    public void setContext(SipAppContext context) {
        SipApplicationSessionListener[] listeners;
        if (this._context != null) {
            throw new IllegalStateException("context != null");
        }
        this._context = context;
        this._context.incrementSessions();
        if (this._context.getSpecVersion() == 10) {
            this._invalidateWhenReady = false;
        }
        if ((listeners = this._context.getSipApplicationSessionListeners()).length > 0) {
            this.getContext().fire((EventListener[])listeners, __appSessionCreated, new SipApplicationSessionEvent((SipApplicationSession)this));
        }
        this.setExpires(this._context.getSessionTimeout());
    }

    public Session createSession() {
        Session session = new Session(this, ID.newSessionId());
        session.setInvalidateWhenReady(this._invalidateWhenReady);
        this.addSession(session);
        return session;
    }

    public Session createUacSession(String callId, NameAddr from, NameAddr to) {
        Session session = new Session(this, ID.newSessionId(), callId, from, to);
        session.setInvalidateWhenReady(this._invalidateWhenReady);
        this.addSession(session);
        session.createUA(UAMode.UAC);
        return session;
    }

    public Session createDerivedSession(Session session) {
        if (session.appSession() != this) {
            throw new IllegalArgumentException("SipSession " + session.getId() + " does not belong to SipApplicationSession " + this.getId());
        }
        Session derived = new Session(ID.newSessionId(), session);
        derived.setInvalidateWhenReady(this._invalidateWhenReady);
        this.addSession(derived);
        return derived;
    }

    public void addSession(Object session) {
        if (session instanceof Session) {
            this._sessions.add((Session)session);
            SipSessionListener[] listeners = this.getContext().getSipSessionListeners();
            if (listeners.length > 0) {
                this.getContext().fire((EventListener[])listeners, __sessionCreated, new SipSessionEvent((SipSession)session));
            }
        } else {
            this._otherSessions = LazyList.add((Object)this._otherSessions, (Object)session);
        }
    }

    public void removeSession(Object session) {
        if (session instanceof Session) {
            this._sessions.remove((Session)session);
            SipSessionListener[] listeners = this.getContext().getSipSessionListeners();
            if (listeners.length > 0) {
                this.getContext().fire((EventListener[])listeners, __sessionDestroyed, new SipSessionEvent((SipSession)session));
            }
        } else {
            this._otherSessions = LazyList.remove((Object)this._otherSessions, (Object)session);
        }
    }

    public CallSession getCallSession() {
        return this._callSession;
    }

    public String getAppId() {
        return this._appId;
    }

    public void noAck(SipServletRequest request, SipServletResponse response) {
        SipErrorListener[] listeners = this.getContext().getSipErrorListeners();
        if (listeners.length > 0) {
            this.getContext().fire((EventListener[])listeners, __noAck, new SipErrorEvent(request, response));
        }
    }

    public void noPrack(SipServletRequest request, SipServletResponse response) {
        SipErrorListener[] listeners = this.getContext().getSipErrorListeners();
        if (listeners.length > 0) {
            this.getContext().fire((EventListener[])listeners, __noPrack, new SipErrorEvent(request, response));
        }
    }

    public ServletTimer newTimer(long delay, boolean persistent, Serializable info) {
        this.checkValid();
        return new Timer(delay, persistent, info);
    }

    public ServletTimer newTimer(long delay, long period, boolean fixedDelay, boolean isPersistent, Serializable info) {
        this.checkValid();
        return new Timer(delay, period, fixedDelay, isPersistent, info);
    }

    private void addTimer(Timer timer) {
        if (this._timers == null) {
            this._timers = new ArrayList<ServletTimer>(1);
        }
        this._timers.add(timer);
    }

    private void removeTimer(Timer timer) {
        if (this._timers != null) {
            this._timers.remove(timer);
        }
    }

    @Override
    public AppSession getAppSession() {
        return this;
    }

    public String toString() {
        return this._appId + "/" + this.getApplicationName() + "(" + this._sessions.size() + ")";
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof AppSessionIf)) {
            return false;
        }
        AppSession session = ((AppSessionIf)o).getAppSession();
        return this == session;
    }

    public void save(DataOutputStream out) throws IOException {
        out.writeUTF(this._appId);
    }

    static {
        try {
            __noAck = SipErrorListener.class.getMethod("noAckReceived", SipErrorEvent.class);
            __noPrack = SipErrorListener.class.getMethod("noPrackReceived", SipErrorEvent.class);
            __appSessionCreated = SipApplicationSessionListener.class.getMethod("sessionCreated", SipApplicationSessionEvent.class);
            __appSessionReadyToInvalidate = SipApplicationSessionListener.class.getMethod("sessionReadyToInvalidate", SipApplicationSessionEvent.class);
            __appSessionExpired = SipApplicationSessionListener.class.getMethod("sessionExpired", SipApplicationSessionEvent.class);
            __appSessionDestroyed = SipApplicationSessionListener.class.getMethod("sessionDestroyed", SipApplicationSessionEvent.class);
            __timerExpired = TimerListener.class.getMethod("timeout", ServletTimer.class);
            __sessionCreated = SipSessionListener.class.getMethod("sessionCreated", SipSessionEvent.class);
            __sessionReadyToInvalidate = SipSessionListener.class.getMethod("sessionReadyToInvalidate", SipSessionEvent.class);
            __sessionDestroyed = SipSessionListener.class.getMethod("sessionDestroyed", SipSessionEvent.class);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public class Timer
    implements ServletTimer,
    Runnable {
        private Serializable _info;
        private long _period = -1L;
        private TimerTask _timerTask;
        private long _executionTime;
        private boolean _persistent;
        private String _id = ID.newID(4);

        public Timer(long delay, boolean persistent, Serializable info) {
            AppSession.this.addTimer(this);
            this._info = info;
            this._executionTime = System.currentTimeMillis() + delay;
            this._timerTask = AppSession.this.getCallSession().schedule(this, delay);
            this._persistent = persistent;
        }

        public Timer(long delay, long period, boolean fixedDelay, boolean isPersistent, Serializable info) {
            AppSession.this.addTimer(this);
            this._info = info;
            this._period = period;
            this._executionTime = System.currentTimeMillis() + delay;
            this._timerTask = AppSession.this.getCallSession().schedule(this, delay);
            this._persistent = isPersistent;
        }

        public Timer(long delay, long period, boolean fixedDelay, boolean isPersistent, Serializable info, String id) {
            AppSession.this.addTimer(this);
            this._info = info;
            this._period = period;
            this._executionTime = System.currentTimeMillis() + delay;
            this._timerTask = AppSession.this.getCallSession().schedule(this, delay);
            this._persistent = isPersistent;
            this._id = id;
        }

        public SipApplicationSession getApplicationSession() {
            return AppSession.this;
        }

        public Serializable getInfo() {
            return this._info;
        }

        public long scheduledExecutionTime() {
            return this._executionTime;
        }

        public String getId() {
            return this._id;
        }

        public long getTimeRemaining() {
            return this._executionTime - System.currentTimeMillis();
        }

        public long getPeriod() {
            return this._period;
        }

        public boolean isPersistent() {
            return this._persistent;
        }

        public void cancel() {
            if (this._timerTask != null) {
                AppSession.this.getCallSession().cancel(this._timerTask);
            }
            this._timerTask = null;
            AppSession.this.removeTimer(this);
            this._period = -1L;
        }

        public void run() {
            TimerListener[] listeners = AppSession.this.getContext().getTimerListeners();
            if (listeners.length > 0) {
                AppSession.this.getContext().fire((EventListener[])listeners, __timerExpired, this);
            }
            if (this._period != -1L) {
                this._executionTime = System.currentTimeMillis() + this._period;
                this._timerTask = AppSession.this.getCallSession().schedule(this, this._period);
            } else {
                AppSession.this.removeTimer(this);
            }
        }
    }

    public class ExpiryTimeout
    implements Runnable {
        public void run() {
            AppSession.this.expired();
        }

        public String toString() {
            return "session-timer";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        VALID,
        EXPIRED,
        INVALIDATING,
        INVALID;

    }
}

