/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.log;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.cipango.server.SipConnection;
import org.cipango.server.SipMessage;
import org.cipango.server.log.AbstractMessageLog;
import org.cipango.server.log.AccessLog;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.util.RolloverFileOutputStream;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class FileMessageLog
extends AbstractMessageLog
implements AccessLog {
    private static final Logger LOG = Log.getLogger(FileMessageLog.class);
    public static final String YYYY_MM_DD = "yyyy_mm_dd";
    private OutputStream _out;
    private String _filename;
    private boolean _append = true;
    private int _retainDays = 31;
    private Object _lock = new Object();

    protected void doStart() throws Exception {
        try {
            if (this._filename != null) {
                File file = new File(this._filename);
                file.getParentFile().mkdirs();
                this._out = new RolloverFileOutputStream(this._filename, this._append, this._retainDays);
            } else {
                this._out = System.out;
            }
            super.doStart();
            LOG.info("Access log started in {}", new Object[]{this._out instanceof RolloverFileOutputStream ? ((RolloverFileOutputStream)this._out).getDatedFilename() : "stdout"});
        }
        catch (Exception e) {
            LOG.warn("Unable to log SIP messages: " + e.getMessage(), new Object[0]);
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this._out != null) {
            try {
                this._out.close();
            }
            catch (IOException e) {
                LOG.ignore((Throwable)e);
            }
            this._out = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLog(SipMessage message, int direction, SipConnection connection) throws IOException {
        Object object = this._lock;
        synchronized (object) {
            this._out.write(this.generateInfoLine(direction, connection, System.currentTimeMillis()).getBytes());
            Buffer buffer = this.generateMessage(message);
            this._out.write(buffer.array(), 0, buffer.length());
            this._out.write(StringUtil.__LINE_SEPARATOR.getBytes());
            this._out.flush();
        }
    }

    public void setFilename(String filename) {
        if (filename != null && (filename = filename.trim()).length() == 0) {
            filename = null;
        }
        this._filename = filename;
    }

    public String getFilename() {
        return this._filename;
    }

    public boolean isAppend() {
        return this._append;
    }

    public void setAppend(boolean append) {
        this._append = append;
    }

    public int getRetainDays() {
        return this._retainDays;
    }

    public void setRetainDays(int days) {
        this._retainDays = days;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLogFiles() throws IOException {
        if (this._filename == null) {
            return;
        }
        Object object = this._lock;
        synchronized (object) {
            if (this._out != null) {
                this._out.close();
            }
            File file = new File(this._filename);
            File dir = new File(file.getParent());
            String fn = file.getName();
            int s = fn.toLowerCase().indexOf(YYYY_MM_DD);
            if (s < 0) {
                file.delete();
            } else {
                String prefix = fn.substring(0, s);
                String suffix = fn.substring(s + YYYY_MM_DD.length());
                String[] logList = dir.list();
                for (int i = 0; i < logList.length; ++i) {
                    fn = logList[i];
                    if (!fn.startsWith(prefix) || fn.indexOf(suffix, prefix.length()) < 0) continue;
                    new File(dir, fn).delete();
                }
            }
            if (this._out != null) {
                this._out = new RolloverFileOutputStream(this._filename, this._append, this._retainDays);
            }
        }
    }
}

