/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.log;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import org.cipango.server.log.CallLog;
import org.cipango.server.log.CallLogger;
import org.eclipse.jetty.util.DateCache;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class FileCallLog
extends AbstractLifeCycle
implements CallLog {
    private static final Logger LOG = Log.getLogger(FileCallLog.class);
    private String _logDirName;
    private File _logDir;
    private DateCache _dateCache;

    public void setLogDir(String logDirName) {
        this._logDirName = logDirName;
    }

    protected void doStart() throws Exception {
        this._logDir = new File(this._logDirName);
        if (!this._logDir.exists() && !this._logDir.mkdirs()) {
            throw new IOException("Failed to create call log directory " + this._logDir.getCanonicalPath());
        }
        this._dateCache = new DateCache("yyyy-MM-dd HH:mm:ss");
    }

    public CallLogger getLogger(String callId) {
        try {
            return new CallLoggerImpl(callId);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    class CallLoggerImpl
    implements CallLogger {
        private PrintWriter _writer;

        public CallLoggerImpl(String id) throws IOException {
            String name = URLEncoder.encode(id, "UTF-8");
            File log = new File(FileCallLog.this._logDir, name + ".log");
            this._writer = new PrintWriter(new FileOutputStream(log));
        }

        public void log(String message, Object arg0, Object arg1) {
            String d = FileCallLog.this._dateCache.now();
            int ms = FileCallLog.this._dateCache.lastMs();
            this._writer.println(d + (ms > 99 ? "." : (ms > 0 ? ".0" : ".00")) + ms + "   " + this.format(message, arg0, arg1));
            this._writer.flush();
        }

        private String format(String msg, Object arg0, Object arg1) {
            int i1;
            int i0 = msg.indexOf("{}");
            int n = i1 = i0 < 0 ? -1 : msg.indexOf("{}", i0 + 2);
            if (arg1 != null && i1 >= 0) {
                msg = msg.substring(0, i1) + arg1 + msg.substring(i1 + 2);
            }
            if (arg0 != null && i0 >= 0) {
                msg = msg.substring(0, i0) + arg0 + msg.substring(i0 + 2);
            }
            return msg;
        }

        public void close() {
            this._writer.close();
        }
    }
}

