/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.log;

import org.cipango.server.SipConnection;
import org.cipango.server.SipMessage;
import org.cipango.server.log.AccessLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class AccessLogCollection
extends AbstractLifeCycle
implements AccessLog {
    private static final Logger LOG = Log.getLogger(AccessLogCollection.class);
    private AccessLog[] _loggers;
    private Server _server;

    public void messageReceived(SipMessage message, SipConnection connection) {
        for (int i = 0; this._loggers != null && i < this._loggers.length; ++i) {
            this._loggers[i].messageReceived(message, connection);
        }
    }

    public void messageSent(SipMessage message, SipConnection connection) {
        for (int i = 0; this._loggers != null && i < this._loggers.length; ++i) {
            this._loggers[i].messageSent(message, connection);
        }
    }

    public AccessLog[] getLoggers() {
        return this._loggers;
    }

    public void setLoggers(AccessLog[] loggers) {
        Object[] oldLoggers;
        Object[] objectArray = oldLoggers = this._loggers == null ? null : (AccessLog[])this._loggers.clone();
        if (this._server != null) {
            this._server.getContainer().update((Object)this, oldLoggers, (Object[])loggers, "loggers", true);
        }
        this._loggers = loggers;
        MultiException mex = new MultiException();
        for (int i = 0; oldLoggers != null && i < oldLoggers.length; ++i) {
            if (oldLoggers[i] == null) continue;
            try {
                LifeCycle lifeCycle;
                if (!(oldLoggers[i] instanceof LifeCycle) || !(lifeCycle = (LifeCycle)oldLoggers[i]).isStarted()) continue;
                lifeCycle.stop();
                continue;
            }
            catch (Throwable e) {
                mex.add(e);
            }
        }
        if (this.isStarted()) {
            try {
                this.doStart();
            }
            catch (Throwable e) {
                mex.add(e);
            }
        }
        mex.ifExceptionThrowRuntime();
    }

    public void addLogger(AccessLog accessLog) {
        this.setLoggers((AccessLog[])LazyList.addToArray((Object[])this.getLoggers(), (Object)accessLog, AccessLog.class));
    }

    public void removeLogger(AccessLog accessLog) {
        Object[] loggers = this.getLoggers();
        if (loggers != null && loggers.length > 0) {
            this.setLoggers((AccessLog[])LazyList.removeFromArray((Object[])loggers, (Object)accessLog));
        }
    }

    public void setServer(Server server) {
        this._server = server;
    }

    protected void doStart() throws Exception {
        for (int i = 0; this._loggers != null && i < this._loggers.length; ++i) {
            try {
                if (!(this._loggers[i] instanceof LifeCycle)) continue;
                ((LifeCycle)this._loggers[i]).start();
                continue;
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
        super.doStart();
    }

    protected void doStop() {
        for (int i = 0; this._loggers != null && i < this._loggers.length; ++i) {
            try {
                if (!(this._loggers[i] instanceof LifeCycle)) continue;
                ((LifeCycle)this._loggers[i]).stop();
                continue;
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
    }
}

