/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.log;

import java.io.IOException;
import java.util.Locale;
import java.util.TimeZone;
import org.cipango.server.SipConnection;
import org.cipango.server.SipMessage;
import org.cipango.server.log.AccessLog;
import org.cipango.sip.SipGenerator;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.util.DateCache;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class AbstractMessageLog
extends AbstractLifeCycle
implements AccessLog {
    private static final Logger LOG = Log.getLogger(AbstractMessageLog.class);
    private DateCache _logDateCache;
    private String _logDateFormat = "yyyy-MM-dd HH:mm:ss";
    private Locale _logLocale = Locale.getDefault();
    private String _logTimeZone = TimeZone.getDefault().getID();
    private SipGenerator _generator;
    private StringBuilder _buf = new StringBuilder();
    private Buffer _buffer;
    public static final int IN = 0;
    public static final int OUT = 1;

    protected void doStart() throws Exception {
        try {
            this._logDateCache = new DateCache(this._logDateFormat, this._logLocale);
            this._logDateCache.setTimeZoneID(this._logTimeZone);
            this._generator = new SipGenerator();
            this._buffer = new ByteArrayBuffer(64000);
            super.doStart();
        }
        catch (Exception e) {
            LOG.warn("Unable to log SIP messages: " + e.getMessage(), new Object[0]);
        }
    }

    public void messageReceived(SipMessage message, SipConnection connection) {
        if (!this.isStarted()) {
            return;
        }
        try {
            this.doLog(message, 0, connection);
        }
        catch (Exception e) {
            LOG.warn("Failed to log message", (Throwable)e);
        }
    }

    public void messageSent(SipMessage message, SipConnection connection) {
        if (!this.isStarted()) {
            return;
        }
        try {
            this.doLog(message, 1, connection);
        }
        catch (Exception e) {
            LOG.warn("Failed to log message", (Throwable)e);
        }
    }

    public abstract void doLog(SipMessage var1, int var2, SipConnection var3) throws IOException;

    protected String generateInfoLine(int direction, SipConnection connection, long date) {
        this._buf.setLength(0);
        this._buf.append(this._logDateCache.format(date));
        if (direction == 0) {
            this._buf.append(" IN  ");
        } else {
            this._buf.append(" OUT ");
        }
        this._buf.append(connection.getConnector().getTransport());
        this._buf.append(" ");
        this._buf.append(connection.getLocalAddress());
        this._buf.append(':');
        this._buf.append(connection.getLocalPort());
        if (direction == 0) {
            this._buf.append(" < ");
        } else {
            this._buf.append(" > ");
        }
        this._buf.append(connection.getRemoteAddress());
        this._buf.append(':');
        this._buf.append(connection.getRemotePort());
        this._buf.append(StringUtil.__LINE_SEPARATOR);
        this._buf.append(StringUtil.__LINE_SEPARATOR);
        return this._buf.toString();
    }

    protected Buffer generateMessage(SipMessage message) {
        this._buffer.clear();
        this._generator.generate(this._buffer, message);
        return this._buffer;
    }
}

