/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.handler;

import java.io.IOException;
import java.lang.reflect.Method;
import javax.servlet.ServletException;
import javax.servlet.sip.Address;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.ar.SipApplicationRouterInfo;
import javax.servlet.sip.ar.SipApplicationRoutingDirective;
import javax.servlet.sip.ar.SipRouteModifier;
import org.cipango.server.ConnectorManager;
import org.cipango.server.ID;
import org.cipango.server.Server;
import org.cipango.server.SipConnector;
import org.cipango.server.SipHandler;
import org.cipango.server.SipMessage;
import org.cipango.server.SipRequest;
import org.cipango.server.SipResponse;
import org.cipango.server.ar.RouterInfoUtil;
import org.cipango.server.session.CallSessionHandler;
import org.cipango.server.session.SipSessionHandler;
import org.cipango.server.transaction.TransactionManager;
import org.cipango.sip.NameAddr;
import org.cipango.sip.SipURIImpl;
import org.cipango.sip.URIFactory;
import org.cipango.sipapp.SipAppContext;
import org.cipango.util.ExceptionUtil;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class SipContextHandlerCollection
extends ContextHandlerCollection
implements SipHandler {
    private static final Logger LOG = Log.getLogger(SipContextHandlerCollection.class);
    private SipAppContext[] _sipContexts;
    private SipHandler _handler;

    public SipContextHandlerCollection() {
        this.setContextClass(SipAppContext.class);
    }

    protected void doStart() throws Exception {
        if (this._handler == null) {
            CallSessionHandler callSessionHandler = new CallSessionHandler();
            SipSessionHandler sipSessionHandler = new SipSessionHandler();
            TransactionManager transactionManager = ((Server)this.getServer()).getTransactionManager();
            callSessionHandler.setHandler((Handler)transactionManager);
            transactionManager.setHandler((Handler)sipSessionHandler);
            this._handler = callSessionHandler;
        }
        this._handler.setServer(this.getServer());
        if (this._handler instanceof LifeCycle) {
            ((LifeCycle)this._handler).start();
        }
        super.doStart();
    }

    public void setHandler(SipHandler handler) {
        this._handler = handler;
    }

    public SipAppContext[] getSipContexts() {
        return this._sipContexts;
    }

    public SipAppContext getContext(String name) {
        if (this._sipContexts != null) {
            for (int i = 0; i < this._sipContexts.length; ++i) {
                if (!this._sipContexts[i].getName().equals(name)) continue;
                return this._sipContexts[i];
            }
        }
        return null;
    }

    public void setHandlers(Handler[] handlers) {
        super.setHandlers(handlers);
        Object sipHandlers = null;
        if (handlers != null) {
            for (int i = 0; i < handlers.length; ++i) {
                if (!(handlers[i] instanceof SipAppContext)) continue;
                sipHandlers = LazyList.add(sipHandlers, (Object)handlers[i]);
            }
        }
        this._sipContexts = (SipAppContext[])LazyList.toArray(sipHandlers, SipAppContext.class);
    }

    public ConnectorManager getConnectorManager() {
        return ((Server)this.getServer()).getConnectorManager();
    }

    private boolean isInitial(SipRequest request) {
        return request.getTo().getParameter("tag") == null && !request.isCancel();
    }

    public Address popLocalRoute(SipRequest request) {
        Address route = request.getTopRoute();
        if (route != null && this.getConnectorManager().isLocalUri(route.getURI())) {
            request.removeTopRoute();
            if (route.getURI().getParameter("drr") != null) {
                Address route2 = request.getTopRoute();
                String appId = route.getURI().getParameter("app-session-id");
                if (route2 != null && appId != null && appId.equals(route2.getURI().getParameter("app-session-id")) && this.getConnectorManager().isLocalUri(route2.getURI())) {
                    LOG.debug("Remove second top route {} due to RFC 5658", new Object[]{route2});
                    request.removeTopRoute();
                    if ("2".equals(route.getParameter("drr"))) {
                        route = route2;
                    }
                }
            }
            return route;
        }
        return null;
    }

    public void handle(SipServletMessage message) throws ServletException, IOException {
        if (((SipMessage)message).isRequest()) {
            SipRequest request = (SipRequest)message;
            Address route = this.popLocalRoute(request);
            if (this.isInitial(request)) {
                request.setInitial(true);
                SipApplicationRouterInfo routerInfo = null;
                SipAppContext appContext = null;
                try {
                    if (route != null) {
                        SipURI uri = (SipURI)route.getURI();
                        if ("X-Cipango-Router-Info".equals(uri.getUser())) {
                            routerInfo = RouterInfoUtil.decode(uri);
                            route = this.popLocalRoute(request);
                        }
                        if (route != null) {
                            request.setPoppedRoute(route);
                        }
                    }
                    if (routerInfo == null) {
                        routerInfo = ((Server)this.getServer()).getApplicationRouter().getNextApplication((SipServletRequest)request, null, SipApplicationRoutingDirective.NEW, null, null);
                    }
                }
                catch (Throwable t) {
                    if (!request.isAck()) {
                        SipResponse response = new SipResponse(request, 500, "Application router error: " + t.getMessage());
                        ExceptionUtil.fillStackTrace(response, t);
                        this.getConnectorManager().sendResponse(response);
                    }
                    return;
                }
                if (routerInfo != null && routerInfo.getNextApplicationName() != null) {
                    String applicationName;
                    Method method;
                    boolean handle = this.handlingRoute(request, routerInfo);
                    if (handle) {
                        return;
                    }
                    request.setStateInfo(routerInfo.getStateInfo());
                    request.setRegion(routerInfo.getRoutingRegion());
                    String s = routerInfo.getSubscriberURI();
                    if (s != null) {
                        try {
                            request.setSubscriberURI(URIFactory.parseURI(s));
                        }
                        catch (ServletParseException e) {
                            LOG.debug((Throwable)e);
                        }
                    }
                    Method method2 = method = (appContext = this.getContext(applicationName = routerInfo.getNextApplicationName())) == null ? null : appContext.getSipApplicationKeyMethod();
                    if (method != null) {
                        try {
                            String sessionKey = (String)method.invoke(null, request);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("routing initial request to key {}", new Object[]{sessionKey});
                            }
                            request.addHandlerAttribute("session.key", sessionKey);
                        }
                        catch (Exception e) {
                            LOG.debug("failed to get SipApplicationKey", (Throwable)e);
                        }
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("application router returned application {} for initial request {}", new Object[]{applicationName, request.getMethod()});
                    }
                    if (appContext == null && applicationName != null) {
                        LOG.debug("No application with name {} returned by application router could be found", new Object[]{applicationName, null});
                    }
                }
                if (appContext == null) {
                    if (!request.isAck()) {
                        SipResponse response = new SipResponse(request, 404, null);
                        response.to().setParameter("tag", ID.newTag());
                        this.getConnectorManager().sendResponse(response);
                    }
                    return;
                }
                request.addHandlerAttribute("context", appContext);
            } else if (route != null) {
                request.setPoppedRoute(route);
            }
        }
        this._handler.handle(message);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handlingRoute(SipRequest request, SipApplicationRouterInfo routerInfo) {
        if (routerInfo.getRouteModifier() == null) return false;
        if (SipRouteModifier.NO_ROUTE == routerInfo.getRouteModifier()) {
            return false;
        }
        String[] routes = routerInfo.getRoutes();
        try {
            if (SipRouteModifier.ROUTE == routerInfo.getRouteModifier() && routes != null) {
                NameAddr topRoute = new NameAddr(routes[0]);
                if (this.getConnectorManager().isLocalUri(topRoute.getURI())) {
                    request.setPoppedRoute(topRoute);
                    return false;
                }
                int i = routes.length;
                while (true) {
                    if (i < 0) {
                        request.send();
                        return true;
                    }
                    request.pushRoute(new NameAddr(routes[i]));
                    --i;
                }
            }
            if (SipRouteModifier.ROUTE_BACK == routerInfo.getRouteModifier() && routes != null) {
                SipConnector defaultConnector = this.getConnectorManager().getDefaultConnector();
                SipURIImpl ownRoute = new SipURIImpl(null, defaultConnector.getHost(), defaultConnector.getPort());
                RouterInfoUtil.encode(ownRoute, routerInfo);
                ownRoute.setLrParam(true);
                request.pushRoute(ownRoute);
                int i = routes.length;
                while (true) {
                    if (i < 0) {
                        request.send();
                        return true;
                    }
                    request.pushRoute(new NameAddr(routes[i]));
                    --i;
                }
            }
            if (routes != null) return false;
            if (SipRouteModifier.ROUTE_BACK != routerInfo.getRouteModifier()) {
                if (SipRouteModifier.ROUTE != routerInfo.getRouteModifier()) return false;
            }
            LOG.debug("Router info set route modifier to {} but no route provided, assume NO_ROUTE", new Object[]{routerInfo.getRouteModifier()});
            return false;
        }
        catch (Exception e) {
            if (request.isAck()) return true;
            SipResponse response = (SipResponse)request.createResponse(500, "Error in handler: " + e.getMessage());
            ExceptionUtil.fillStackTrace(response, e);
            try {
                this.getConnectorManager().sendResponse(response);
                return true;
            }
            catch (Exception e1) {
                LOG.ignore((Throwable)e1);
            }
            return true;
        }
    }
}

