/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.bio;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import javax.servlet.sip.URI;
import org.cipango.server.AbstractSipConnector;
import org.cipango.server.SipConnection;
import org.cipango.server.SipConnector;
import org.cipango.server.SipMessage;
import org.cipango.server.SipRequest;
import org.cipango.server.SipResponse;
import org.cipango.sip.SipHeaders;
import org.cipango.sip.SipParser;
import org.cipango.sip.URIFactory;
import org.cipango.util.HexString;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.View;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class UdpConnector
extends AbstractSipConnector {
    private static final Logger LOG = Log.getLogger(UdpConnector.class);
    public static final int MAX_UDP_SIZE = 65536;
    public static final int DEFAULT_PORT = 5060;
    public static final boolean RELIABLE = false;
    private DatagramPacket[] _packets;
    private DatagramSocket _datagramSocket;
    private InetAddress _localAddr;

    protected void doStart() throws Exception {
        this._packets = new DatagramPacket[this.getAcceptors()];
        for (int i = 0; i < this.getAcceptors(); ++i) {
            this._packets[i] = new DatagramPacket(new byte[65536], 65536);
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    public void open() throws IOException {
        this._datagramSocket = this.newDatagramSocket();
        this._localAddr = this._datagramSocket.getLocalAddress();
    }

    public boolean isOpen() {
        return this._datagramSocket != null && !this._datagramSocket.isClosed();
    }

    public int getLocalPort() {
        if (this._datagramSocket == null || this._datagramSocket.isClosed()) {
            return -1;
        }
        return this._datagramSocket.getLocalPort();
    }

    public Object getConnection() {
        return this._datagramSocket;
    }

    protected DatagramSocket newDatagramSocket() throws IOException {
        this._datagramSocket = this.getHost() == null ? new DatagramSocket(this.getPort()) : new DatagramSocket(this.getPort(), InetAddress.getByName(this.getHost()));
        return this._datagramSocket;
    }

    public void close() {
        this._datagramSocket.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(int acceptorID) throws IOException, InterruptedException {
        block7: {
            DatagramPacket p = this._packets[acceptorID];
            this._datagramSocket.receive(p);
            int length = p.getLength();
            if (length == 2 || length == 4) {
                return;
            }
            byte[] b = new byte[length];
            System.arraycopy(p.getData(), 0, b, 0, length);
            ByteArrayBuffer buffer = new ByteArrayBuffer(b);
            EventHandler handler = new EventHandler();
            SipParser parser = new SipParser((Buffer)buffer, handler);
            try {
                parser.parse();
                SipMessage message = handler.getMessage();
                message.setConnection(new UdpConnection(p.getAddress(), p.getPort()));
                this.process(message);
            }
            catch (Throwable t) {
                if (this._statsStartedAt != -1L) {
                    Object object = this._statsLock;
                    synchronized (object) {
                        ++this._nbParseErrors;
                    }
                }
                LOG.warn(t);
                if (!LOG.isDebugEnabled()) break block7;
                LOG.debug("Buffer content: \r\n" + HexString.toDetailedHexString(buffer.array(), p.getLength()), new Object[0]);
            }
        }
    }

    public SipConnection getConnection(InetAddress address, int port) {
        return new UdpConnection(address, port);
    }

    public int getDefaultPort() {
        return 5060;
    }

    public InetAddress getAddr() {
        return this._localAddr;
    }

    public int getTransportOrdinal() {
        return 1;
    }

    public boolean isReliable() {
        return false;
    }

    public boolean isSecure() {
        return false;
    }

    public Buffer newBuffer() {
        return new ByteArrayBuffer(65536);
    }

    public SipConnector getConnector() {
        return this;
    }

    public static class EventHandler
    extends SipParser.EventHandler {
        private SipMessage _message;

        public void startRequest(Buffer method, Buffer uri, Buffer version) throws IOException {
            try {
                URI ruri = URIFactory.parseURI(uri.toString());
                SipRequest request = new SipRequest();
                request.setMethod(method.toString());
                request.setRequestURI(ruri);
                this._message = request;
            }
            catch (Exception e) {
                throw new IOException("Parsing error: " + e.getMessage());
            }
        }

        public void startResponse(Buffer version, int status, Buffer reason) throws IOException {
            SipResponse response = new SipResponse();
            response.setStatus(status, reason.toString());
            this._message = response;
        }

        public SipMessage getMessage() {
            return this._message;
        }

        public void header(Buffer name, Buffer value) throws IOException {
            if (this._message == null) {
                throw new IOException("no status line");
            }
            if (SipHeaders.getType(name).isList()) {
                int end;
                boolean quote = false;
                int start = value.getIndex();
                byte[] b = value.array();
                int startValue = start;
                int endValue = end;
                for (end = value.putIndex(); end > start && b[end - 1] <= 32; --end) {
                }
                for (int i = start; i < end; ++i) {
                    byte c = b[i];
                    if (c == 34) {
                        boolean bl = quote = !quote;
                    }
                    if (c != 44 || quote) continue;
                    for (endValue = i; endValue > start && b[endValue - 1] <= 32; --endValue) {
                    }
                    while (startValue < endValue && b[startValue] <= 32) {
                        ++startValue;
                    }
                    View buffer = new View(value, startValue, startValue, endValue, 1);
                    this._message.getFields().addBuffer(name, (Buffer)buffer);
                    startValue = i + 1;
                }
                while (startValue < end && b[startValue] <= 32) {
                    ++startValue;
                }
                value = new View(value, startValue, startValue, end, 1);
                this._message.getFields().addBuffer(name, value);
            } else {
                this._message.getFields().addBuffer(name, value);
            }
        }

        public void content(Buffer buffer) throws IOException {
            if (buffer.length() > 0) {
                this._message.setRawContent(buffer.asArray());
            }
        }
    }

    class UdpConnection
    implements SipConnection {
        private InetAddress _remoteAddr;
        private int _remotePort;

        public UdpConnection(InetAddress remoteAddr, int remotePort) {
            this._remoteAddr = remoteAddr;
            this._remotePort = remotePort;
        }

        public SipConnector getConnector() {
            return UdpConnector.this;
        }

        public InetAddress getLocalAddress() {
            return UdpConnector.this._localAddr;
        }

        public int getLocalPort() {
            return UdpConnector.this.getPort();
        }

        public InetAddress getRemoteAddress() {
            return this._remoteAddr;
        }

        public int getRemotePort() {
            return this._remotePort;
        }

        public void write(Buffer buffer) throws IOException {
            DatagramPacket packet = new DatagramPacket(buffer.array(), buffer.length(), this._remoteAddr, this._remotePort);
            UdpConnector.this._datagramSocket.send(packet);
        }

        public boolean isOpen() {
            return UdpConnector.this._datagramSocket != null && !UdpConnector.this._datagramSocket.isClosed();
        }

        public String toString() {
            return "udp/" + this._remoteAddr.getHostAddress() + ":" + this._remotePort;
        }
    }
}

