/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.bio;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.security.cert.X509Certificate;
import org.cipango.server.SipMessage;
import org.cipango.server.bio.TcpConnector;
import org.eclipse.jetty.http.security.Password;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;

public class TlsConnector
extends TcpConnector {
    private static final Logger LOG = Log.getLogger(TlsConnector.class);
    public static final int DEFAULT_PORT = 5061;
    public static final String DEFAULT_KEYSTORE = System.getProperty("user.home") + File.separator + ".keystore";
    public static final String KEYPASSWORD_PROPERTY = "jetty.ssl.keypassword";
    public static final String PASSWORD_PROPERTY = "jetty.ssl.password";
    private String[] _excludeCipherSuites = null;
    private String _keystore = DEFAULT_KEYSTORE;
    private String _keystoreType = "JKS";
    private boolean _needClientAuth = false;
    private transient Password _password;
    private transient Password _keyPassword;
    private transient Password _trustPassword;
    private String _provider;
    private String _secureRandomAlgorithm;
    private String _sslKeyManagerFactoryAlgorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm") == null ? "SunX509" : Security.getProperty("ssl.KeyManagerFactory.algorithm");
    private String _sslTrustManagerFactoryAlgorithm = Security.getProperty("ssl.TrustManagerFactory.algorithm") == null ? "SunX509" : Security.getProperty("ssl.TrustManagerFactory.algorithm");
    private String _truststore;
    private String _truststoreType = "JKS";
    private boolean _wantClientAuth = false;
    private int _handshakeTimeout = 0;
    private boolean _allowRenegotiate = false;

    public ServerSocket newServerSocket() throws IOException {
        SSLServerSocketFactory factory = null;
        SSLServerSocket socket = null;
        try {
            factory = this.createFactory();
            socket = (SSLServerSocket)(this.getHost() == null ? factory.createServerSocket(this.getPort(), this.getBacklogSize()) : factory.createServerSocket(this.getPort(), this.getBacklogSize(), InetAddress.getByName(this.getHost())));
            if (this._wantClientAuth) {
                socket.setWantClientAuth(this._wantClientAuth);
            }
            if (this._needClientAuth) {
                socket.setNeedClientAuth(this._needClientAuth);
            }
            if (this._excludeCipherSuites != null && this._excludeCipherSuites.length > 0) {
                List<String> excludedCSList = Arrays.asList(this._excludeCipherSuites);
                String[] enabledCipherSuites = socket.getEnabledCipherSuites();
                ArrayList<String> enabledCSList = new ArrayList<String>(Arrays.asList(enabledCipherSuites));
                for (String cipherName : excludedCSList) {
                    if (!enabledCSList.contains(cipherName)) continue;
                    enabledCSList.remove(cipherName);
                }
                enabledCipherSuites = enabledCSList.toArray(new String[enabledCSList.size()]);
                socket.setEnabledCipherSuites(enabledCipherSuites);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.warn(e.toString(), new Object[0]);
            LOG.debug((Throwable)e);
            throw new IOException("!JsseListener: " + e);
        }
        return socket;
    }

    protected SSLServerSocketFactory createFactory() throws Exception {
        if (this._truststore == null) {
            this._truststore = this._keystore;
            this._truststoreType = this._keystoreType;
        }
        KeyManager[] keyManagers = null;
        InputStream keystoreInputStream = null;
        if (this._keystore != null) {
            keystoreInputStream = Resource.newResource((String)this._keystore).getInputStream();
        }
        KeyStore keyStore = KeyStore.getInstance(this._keystoreType);
        keyStore.load(keystoreInputStream, this._password == null ? null : this._password.toString().toCharArray());
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(this._sslKeyManagerFactoryAlgorithm);
        keyManagerFactory.init(keyStore, this._keyPassword == null ? null : this._keyPassword.toString().toCharArray());
        keyManagers = keyManagerFactory.getKeyManagers();
        TrustManager[] trustManagers = null;
        InputStream truststoreInputStream = null;
        if (this._truststore != null) {
            truststoreInputStream = Resource.newResource((String)this._truststore).getInputStream();
        }
        KeyStore trustStore = KeyStore.getInstance(this._truststoreType);
        trustStore.load(truststoreInputStream, this._trustPassword == null ? null : this._trustPassword.toString().toCharArray());
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(this._sslTrustManagerFactoryAlgorithm);
        trustManagerFactory.init(trustStore);
        trustManagers = trustManagerFactory.getTrustManagers();
        SecureRandom secureRandom = this._secureRandomAlgorithm == null ? null : SecureRandom.getInstance(this._secureRandomAlgorithm);
        SSLContext context = this._provider == null ? SSLContext.getInstance("TLS") : SSLContext.getInstance("TLS", this._provider);
        context.init(keyManagers, trustManagers, secureRandom);
        return context.getServerSocketFactory();
    }

    public void accept(int acceptorId) throws IOException, InterruptedException {
        try {
            Socket socket = this.getServerSocket().accept();
            TlsConnection connection = new TlsConnection((SSLSocket)socket);
            this.addConnection(socket.getInetAddress(), socket.getPort(), connection);
            connection.dispatch();
        }
        catch (SSLException e) {
            LOG.warn((Throwable)e);
            try {
                this.stop();
            }
            catch (Exception e2) {
                LOG.warn((Throwable)e2);
                throw new IllegalStateException(e2.getMessage());
            }
        }
    }

    public void process(SipMessage message) {
        TlsConnection tlsConnection = (TlsConnection)message.getConnection();
        SSLSocket sslSocket = tlsConnection.getSocket();
        try {
            SSLSession sslSession = sslSocket.getSession();
            java.security.cert.X509Certificate[] certs = (java.security.cert.X509Certificate[])sslSession.getValue(java.security.cert.X509Certificate.class.getName());
            if (certs == null) {
                certs = TlsConnector.getCertChain(sslSession);
                if (certs == null) {
                    certs = new java.security.cert.X509Certificate[]{};
                }
                sslSession.putValue(java.security.cert.X509Certificate.class.getName(), certs);
            }
            if (certs.length > 0) {
                message.setAttribute("javax.servlet.request.X509Certificate", certs);
            } else if (this._needClientAuth) {
                throw new IllegalStateException("no client auth");
            }
        }
        catch (Exception e) {
            LOG.warn("EXCEPTION ", (Throwable)e);
        }
        super.process(message);
    }

    private static java.security.cert.X509Certificate[] getCertChain(SSLSession sslSession) {
        try {
            X509Certificate[] javaxCerts = sslSession.getPeerCertificateChain();
            if (javaxCerts == null || javaxCerts.length == 0) {
                return null;
            }
            int length = javaxCerts.length;
            java.security.cert.X509Certificate[] javaCerts = new java.security.cert.X509Certificate[length];
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            for (int i = 0; i < length; ++i) {
                byte[] bytes = javaxCerts[i].getEncoded();
                ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                javaCerts[i] = (java.security.cert.X509Certificate)cf.generateCertificate(stream);
            }
            return javaCerts;
        }
        catch (SSLPeerUnverifiedException pue) {
            return null;
        }
        catch (Exception e) {
            LOG.warn("EXCEPTION ", (Throwable)e);
            return null;
        }
    }

    public boolean isSecure() {
        return true;
    }

    public int getDefaultPort() {
        return 5061;
    }

    public int getTransportOrdinal() {
        return 3;
    }

    protected TcpConnector.TcpConnection newConnection(InetAddress addr, int port) throws IOException {
        SSLSocketFactory sslsocketfactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        SSLSocket sslsocket = (SSLSocket)sslsocketfactory.createSocket(addr, port);
        return new TlsConnection(sslsocket);
    }

    public String[] getExcludeCipherSuites() {
        return this._excludeCipherSuites;
    }

    public String getKeystore() {
        return this._keystore;
    }

    public String getKeystoreType() {
        return this._keystoreType;
    }

    public boolean getNeedClientAuth() {
        return this._needClientAuth;
    }

    public String getProvider() {
        return this._provider;
    }

    public String getSecureRandomAlgorithm() {
        return this._secureRandomAlgorithm;
    }

    public String getSslKeyManagerFactoryAlgorithm() {
        return this._sslKeyManagerFactoryAlgorithm;
    }

    public String getSslTrustManagerFactoryAlgorithm() {
        return this._sslTrustManagerFactoryAlgorithm;
    }

    public String getTruststore() {
        return this._truststore;
    }

    public String getTruststoreType() {
        return this._truststoreType;
    }

    public boolean getWantClientAuth() {
        return this._wantClientAuth;
    }

    public void setExcludeCipherSuites(String[] cipherSuites) {
        this._excludeCipherSuites = cipherSuites;
    }

    public void setKeyPassword(String password) {
        this._keyPassword = Password.getPassword((String)KEYPASSWORD_PROPERTY, (String)password, null);
    }

    public void setKeystore(String keystore) {
        this._keystore = keystore;
    }

    public void setKeystoreType(String keystoreType) {
        this._keystoreType = keystoreType;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this._needClientAuth = needClientAuth;
    }

    public void setPassword(String password) {
        this._password = Password.getPassword((String)PASSWORD_PROPERTY, (String)password, null);
    }

    public void setTrustPassword(String password) {
        this._trustPassword = Password.getPassword((String)PASSWORD_PROPERTY, (String)password, null);
    }

    public void setProvider(String _provider) {
        this._provider = _provider;
    }

    public void setSecureRandomAlgorithm(String algorithm) {
        this._secureRandomAlgorithm = algorithm;
    }

    public void setSslKeyManagerFactoryAlgorithm(String algorithm) {
        this._sslKeyManagerFactoryAlgorithm = algorithm;
    }

    public void setSslTrustManagerFactoryAlgorithm(String algorithm) {
        this._sslTrustManagerFactoryAlgorithm = algorithm;
    }

    public void setTruststore(String truststore) {
        this._truststore = truststore;
    }

    public void setTruststoreType(String truststoreType) {
        this._truststoreType = truststoreType;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this._wantClientAuth = wantClientAuth;
    }

    public void setHandshakeTimeout(int msec) {
        this._handshakeTimeout = msec;
    }

    public int getHandshakeTimeout() {
        return this._handshakeTimeout;
    }

    public class TlsConnection
    extends TcpConnector.TcpConnection {
        private SSLSocket _socket;

        public TlsConnection(SSLSocket socket) throws IOException {
            super(socket);
            this._socket = socket;
        }

        public SSLSocket getSocket() {
            return this._socket;
        }

        public void run() {
            try {
                int handshakeTimeout = TlsConnector.this.getHandshakeTimeout();
                int oldTimeout = this._socket.getSoTimeout();
                if (handshakeTimeout > 0) {
                    this._socket.setSoTimeout(handshakeTimeout);
                }
                this._socket.addHandshakeCompletedListener(new HandshakeCompletedListener(){
                    boolean handshook = false;

                    public void handshakeCompleted(HandshakeCompletedEvent event) {
                        if (this.handshook) {
                            if (!TlsConnector.this._allowRenegotiate) {
                                LOG.warn("SSL renegotiate denied: " + TlsConnection.this._socket, new Object[0]);
                                try {
                                    TlsConnection.this._socket.close();
                                }
                                catch (IOException e) {
                                    LOG.warn((Throwable)e);
                                }
                            }
                        } else {
                            this.handshook = true;
                        }
                    }
                });
                this._socket.startHandshake();
                if (handshakeTimeout > 0) {
                    this._socket.setSoTimeout(oldTimeout);
                }
                super.run();
            }
            catch (SSLException e) {
                LOG.warn((Throwable)e);
                try {
                    this.close();
                }
                catch (IOException e2) {
                    LOG.ignore((Throwable)e2);
                }
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
                try {
                    this.close();
                }
                catch (IOException e2) {
                    LOG.ignore((Throwable)e2);
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("TLS Connection ");
            sb.append(this.getLocalAddr()).append(":").append(this.getLocalPort());
            sb.append(" - ");
            sb.append(this.getRemoteAddr()).append(":").append(this.getRemotePort());
            return sb.toString();
        }
    }
}

