/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.bio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cipango.server.AbstractSipConnector;
import org.cipango.server.SipConnection;
import org.cipango.server.SipConnector;
import org.cipango.server.SipMessage;
import org.cipango.server.transaction.Transaction;
import org.cipango.sip.BufferOverflowException;
import org.cipango.sip.SipParser;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.bio.SocketEndPoint;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TcpConnector
extends AbstractSipConnector {
    private static final Logger LOG = Log.getLogger(TcpConnector.class);
    public static final int DEFAULT_PORT = 5060;
    public static final boolean RELIABLE = true;
    public static final int DEFAULT_TCP_MESSAGE = 2048;
    public static final int MAX_TCP_MESSAGE = 409600;
    public static final int DEFAULT_SO_TIMEOUT = 2 * Transaction.__T1 * 64;
    private static final byte[] PING = new byte[]{13, 10, 13, 10};
    private static final byte[] PONG = new byte[]{13, 10};
    private ServerSocket _serverSocket;
    private InetAddress _addr;
    private Map<String, TcpConnection> _connections;
    private int _connectionTimeout = DEFAULT_SO_TIMEOUT;
    private int _backlogSize = 50;
    private ThreadPool _tcpThreadPool;
    private List<Buffer> _buffers = new ArrayList<Buffer>();

    @Override
    protected void doStart() throws Exception {
        this._connections = new HashMap<String, TcpConnection>();
        if (this._tcpThreadPool == null) {
            this._tcpThreadPool = new QueuedThreadPool();
        }
        if (this._tcpThreadPool instanceof LifeCycle) {
            ((LifeCycle)this._tcpThreadPool).start();
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        Object[] connections;
        super.doStop();
        if (this._tcpThreadPool instanceof LifeCycle) {
            ((LifeCycle)this._tcpThreadPool).stop();
        }
        for (Object o : connections = this._connections.values().toArray()) {
            TcpConnection connection = (TcpConnection)o;
            try {
                connection.close();
            }
            catch (Exception e) {
                LOG.ignore((Throwable)e);
            }
        }
    }

    @Override
    public InetAddress getAddr() {
        return this._addr;
    }

    public ThreadPool getTcpThreadPool() {
        return this._tcpThreadPool;
    }

    @Override
    public void open() throws IOException {
        this._serverSocket = this.newServerSocket();
        this._addr = this._serverSocket.getInetAddress();
    }

    @Override
    public int getLocalPort() {
        if (this._serverSocket == null || this._serverSocket.isClosed()) {
            return -1;
        }
        return this._serverSocket.getLocalPort();
    }

    @Override
    public Object getConnection() {
        return this._serverSocket;
    }

    public ServerSocket newServerSocket() throws IOException {
        if (this.getHost() == null) {
            return new ServerSocket(this.getPort(), this._backlogSize);
        }
        return new ServerSocket(this.getPort(), this._backlogSize, InetAddress.getByName(this.getHost()));
    }

    @Override
    public void close() throws IOException {
        if (this._serverSocket != null) {
            this._serverSocket.close();
        }
        this._serverSocket = null;
    }

    @Override
    public void accept(int acceptorId) throws IOException, InterruptedException {
        Socket socket = this._serverSocket.accept();
        TcpConnection connection = new TcpConnection(socket);
        this.addConnection(socket.getInetAddress(), socket.getPort(), connection);
        connection.dispatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addConnection(InetAddress host, int port, TcpConnection connection) {
        Map<String, TcpConnection> map = this._connections;
        synchronized (map) {
            this._connections.put(this.key(host, port), connection);
        }
    }

    protected ServerSocket getServerSocket() {
        return this._serverSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Buffer getBuffer(int size) {
        List<Buffer> list = this._buffers;
        synchronized (list) {
            if (this._buffers.size() == 0) {
                return this.newBuffer(10);
            }
            return this._buffers.remove(this._buffers.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnBuffer(Buffer buffer) {
        List<Buffer> list = this._buffers;
        synchronized (list) {
            buffer.clear();
            this._buffers.add(buffer);
        }
    }

    public Buffer newBuffer(int size) {
        return new ByteArrayBuffer(size);
    }

    @Override
    public int getDefaultPort() {
        return 5060;
    }

    @Override
    public boolean isReliable() {
        return true;
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public int getTransportOrdinal() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SipConnection getConnection(InetAddress addr, int port) throws IOException {
        Map<String, TcpConnection> map = this._connections;
        synchronized (map) {
            TcpConnection cnx = this._connections.get(this.key(addr, port));
            if (cnx == null) {
                cnx = this.newConnection(addr, port);
                this.addConnection(addr, port, cnx);
                cnx.dispatch();
            }
            return cnx;
        }
    }

    public boolean sendHeartBeat(InetAddress addr, int port) throws IOException {
        TcpConnection cnx = this._connections.get(this.key(addr, port));
        if (cnx == null) {
            return false;
        }
        cnx.write((Buffer)new ByteArrayBuffer(PING));
        return true;
    }

    protected TcpConnection newConnection(InetAddress addr, int port) throws IOException {
        return new TcpConnection(new Socket(addr, port));
    }

    protected Map<String, TcpConnection> getConnections() {
        return this._connections;
    }

    public void connectionOpened(TcpConnection connection) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosed(TcpConnection connection) {
        Map<String, TcpConnection> map = this._connections;
        synchronized (map) {
            this._connections.remove(connection.getRemoteAddr() + ":" + connection.getRemotePort());
        }
    }

    private String key(InetAddress addr, int port) {
        return addr.getHostAddress() + ":" + port;
    }

    public int getBacklogSize() {
        return this._backlogSize;
    }

    public void setBacklogSize(int backlogSize) {
        this._backlogSize = backlogSize;
    }

    public int getConnectionTimeout() {
        return this._connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this._connectionTimeout = connectionTimeout;
    }

    public class TcpConnection
    extends SocketEndPoint
    implements SipConnection,
    Runnable {
        private InetAddress _local;
        private InetAddress _remote;

        public TcpConnection(Socket socket) throws IOException {
            super(socket);
            socket.setTcpNoDelay(true);
            socket.setSoTimeout(TcpConnector.this._connectionTimeout);
            this._local = socket.getLocalAddress();
            this._remote = socket.getInetAddress();
        }

        public void dispatch() throws IOException {
            if (!TcpConnector.this.getTcpThreadPool().dispatch((Runnable)this)) {
                LOG.warn("dispatch failed for {}", new Object[]{this});
                this.close();
            }
        }

        public InetAddress getLocalAddress() {
            return this._local;
        }

        public InetAddress getRemoteAddress() {
            return this._remote;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(Buffer buffer) throws IOException {
            TcpConnection tcpConnection = this;
            synchronized (tcpConnection) {
                int nb = super.flush(buffer);
                this.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            AbstractSipConnector.EventHandler handler = new AbstractSipConnector.EventHandler();
            Buffer buffer = TcpConnector.this.newBuffer(2048);
            SipParser parser = new SipParser(buffer, (EndPoint)this, handler);
            try {
                TcpConnector.this.connectionOpened(this);
                SipMessage message = null;
                while (TcpConnector.this.isStarted() && !this.isClosed()) {
                    int size = 2048;
                    boolean overflow = false;
                    do {
                        overflow = false;
                        try {
                            parser.parse();
                            size = 2048;
                            parser.setBuffer(TcpConnector.this.newBuffer(size));
                        }
                        catch (BufferOverflowException e) {
                            overflow = true;
                            if ((size *= 2) > 409600) {
                                throw new IOException("Message too large");
                            }
                            Buffer extended = TcpConnector.this.newBuffer(size);
                            parser.setBuffer(extended, true);
                        }
                    } while (overflow);
                    if (handler.isPing()) {
                        this.write((Buffer)new ByteArrayBuffer(PONG));
                    } else if (!handler.isPong()) {
                        message = handler.getMessage();
                        message.setConnection(this);
                        TcpConnector.this.process(message);
                    }
                    handler.reset();
                }
            }
            catch (EofException e) {
                LOG.debug("EOF: {}", new Object[]{this});
                try {
                    this.close();
                }
                catch (IOException e2) {
                    LOG.ignore((Throwable)e2);
                }
            }
            catch (Throwable e) {
                System.out.println(parser.getState());
                if (TcpConnector.this._statsStartedAt != -1L) {
                    Object e2 = TcpConnector.this._statsLock;
                    synchronized (e2) {
                        TcpConnector.this._nbParseErrors++;
                    }
                }
                LOG.warn("TCP handle failed", e);
                if (handler.hasException()) {
                    LOG.warn((Throwable)handler.getException());
                }
                try {
                    this.close();
                }
                catch (IOException e2) {
                    LOG.ignore((Throwable)e2);
                }
            }
            finally {
                TcpConnector.this.connectionClosed(this);
            }
        }

        public SipConnector getConnector() {
            return TcpConnector.this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("TCP Connection ");
            sb.append(this.getLocalAddr()).append(":").append(this.getLocalPort());
            sb.append(" - ");
            sb.append(this.getRemoteAddr()).append(":").append(this.getRemotePort());
            return sb.toString();
        }
    }
}

