/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.ar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.ar.SipApplicationRouterInfo;
import javax.servlet.sip.ar.SipApplicationRoutingRegion;
import javax.servlet.sip.ar.SipRouteModifier;
import org.eclipse.jetty.util.TypeUtil;

public class RouterInfoUtil {
    public static final String ROUTER_INFO = "X-Cipango-Router-Info";
    private static final String NEXT_APPLICATION_NAME = "appName";
    private static final String STATE_INFO = "stateInfo";
    private static final String SUBSCRIBER_URI = "subUri";
    private static final String ROUTING_REGION = "region";
    private static final String ROUTES = "routes";
    private static final String ROUTE_MODIFIER = "route-modifier";

    public static void encode(SipURI uri, SipApplicationRouterInfo routerInfo) throws IOException {
        uri.setUser(ROUTER_INFO);
        uri.setParameter(NEXT_APPLICATION_NAME, routerInfo.getNextApplicationName());
        RouterInfoUtil.setParameter(uri, ROUTING_REGION, (Serializable)routerInfo.getRoutingRegion());
        RouterInfoUtil.setParameter(uri, SUBSCRIBER_URI, routerInfo.getSubscriberURI());
        RouterInfoUtil.setParameter(uri, ROUTES, (Serializable)routerInfo.getRoutes());
        if (routerInfo.getRouteModifier() != null) {
            uri.setParameter(ROUTE_MODIFIER, routerInfo.getRouteModifier().toString());
        }
        RouterInfoUtil.setParameter(uri, STATE_INFO, routerInfo.getStateInfo());
    }

    private static void setParameter(SipURI uri, String name, String value) {
        if (value != null) {
            uri.setParameter(name, value);
        }
    }

    private static void setParameter(SipURI uri, String name, Serializable value) throws IOException {
        if (value != null) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bout);
            out.writeObject(value);
            uri.setParameter(name, TypeUtil.toHexString((byte[])bout.toByteArray()));
        }
    }

    private static Serializable getSerializable(SipURI uri, String name) throws IOException, ClassNotFoundException {
        String s = uri.getParameter(name);
        if (s != null) {
            byte[] b = TypeUtil.fromHexString((String)s);
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(b));
            return (Serializable)in.readObject();
        }
        return null;
    }

    public static SipApplicationRouterInfo decode(SipURI uri) throws Exception {
        String appName = uri.getParameter(NEXT_APPLICATION_NAME);
        String sRouteModifier = uri.getParameter(ROUTE_MODIFIER);
        SipRouteModifier routeModifier = null;
        if (sRouteModifier != null) {
            routeModifier = SipRouteModifier.valueOf((String)sRouteModifier);
        }
        return new SipApplicationRouterInfo(appName, (SipApplicationRoutingRegion)RouterInfoUtil.getSerializable(uri, ROUTING_REGION), uri.getParameter(SUBSCRIBER_URI), (String[])RouterInfoUtil.getSerializable(uri, ROUTES), routeModifier, RouterInfoUtil.getSerializable(uri, STATE_INFO));
    }
}

