/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.sip.Address;
import javax.servlet.sip.Proxy;
import javax.servlet.sip.ProxyBranch;
import javax.servlet.sip.Rel100Exception;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import org.cipango.server.SipMessage;
import org.cipango.server.SipProxy;
import org.cipango.server.SipRequest;
import org.cipango.server.session.SessionManager;
import org.cipango.server.transaction.ServerTransaction;
import org.cipango.sip.NameAddr;
import org.cipango.sip.SipFields;
import org.cipango.sip.SipHeaders;
import org.cipango.sip.SipStatus;
import org.cipango.sip.Via;
import org.cipango.sip.security.Authenticate;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SipResponse
extends SipMessage
implements SipServletResponse {
    private static final Logger LOG = Log.getLogger(SipResponse.class);
    private SipRequest _request;
    private int _status;
    private String _reason;
    private SipProxy _proxy;
    private ProxyBranch _proxyBranch;
    private boolean _branchResponse;
    private boolean _sendOutsideTx = false;

    public SipResponse() {
    }

    public SipResponse(SipRequest request, int status, String reason) {
        this._request = request;
        if (status >= 200) {
            this._request.setCommitted(true);
        }
        this.setStatus(status, reason);
        this.setCallSession(request.getCallSession());
        this.setTransaction(request.getTransaction());
        this.setSession(request.session());
        SipFields reqFields = request.getFields();
        this._fields.copy(reqFields, (Buffer)SipHeaders.VIA_BUFFER);
        this._fields.copy(reqFields, (Buffer)SipHeaders.FROM_BUFFER);
        this._fields.copy(reqFields, (Buffer)SipHeaders.TO_BUFFER);
        this._fields.copy(reqFields, (Buffer)SipHeaders.CALL_ID_BUFFER);
        this._fields.copy(reqFields, (Buffer)SipHeaders.CSEQ_BUFFER);
        if (status < 300) {
            this._fields.copy(reqFields, (Buffer)SipHeaders.RECORD_ROUTE_BUFFER);
        }
        if (this.needsContact() && this._session != null) {
            if (request.getConnection() != null) {
                this.setContact(this._session.getContact(request.getConnection().getConnector()));
            } else {
                this.setContact(this._session.getContact());
            }
        }
    }

    public SipServletRequest createAck() {
        if (!"INVITE".equalsIgnoreCase(this.getMethod())) {
            throw new IllegalStateException("Not INVITE method");
        }
        if (this._status > 100 && this._status < 200) {
            try {
                return this.createPrack();
            }
            catch (Rel100Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        if (this._status >= 200 && this._status < 300) {
            this.setCommitted(true);
            return this._session.getUA().createRequest("ACK", this.getCSeq().getNumber());
        }
        throw new IllegalStateException("non 2xx or 1xx response");
    }

    public SipServletRequest createPrack() throws Rel100Exception {
        if (this.isCommitted()) {
            throw new IllegalStateException("Already committed");
        }
        if (!"INVITE".equalsIgnoreCase(this.getMethod())) {
            throw new Rel100Exception(1);
        }
        if (this._status > 100 && this._status < 200) {
            long rseq = this.getRSeq();
            if (!this.isReliable1xx()) {
                throw new Rel100Exception(4);
            }
            SipRequest request = (SipRequest)this._session.createRequest("PRACK");
            request.getFields().setString((Buffer)SipHeaders.RACK_BUFFER, rseq + " " + this.getCSeq());
            this.setCommitted(true);
            return request;
        }
        throw new Rel100Exception(0);
    }

    public ServletOutputStream getOutputStream() {
        return null;
    }

    public Proxy getProxy() {
        if (this._proxy == null) {
            this._proxy = this.getTransaction().getRequest().getProxyImpl();
        }
        return this._proxy;
    }

    public String getReason() {
        return this._reason;
    }

    public String getReasonPhrase() {
        if (this._reason == null) {
            return SipStatus.getReason(this._status);
        }
        return this._reason;
    }

    public SipServletRequest getRequest() {
        if (this._request == null && this.getTransaction() != null) {
            this._request = this.getTransaction().getRequest();
        }
        return this._request;
    }

    public int getStatus() {
        return this._status;
    }

    public PrintWriter getWriter() {
        return null;
    }

    public void send() throws IOException {
        this.send(false);
    }

    public void sendReliably() throws Rel100Exception {
        String s;
        SipRequest request = (SipRequest)this.getRequest();
        if (!request.isInvite()) {
            throw new Rel100Exception(1);
        }
        if (this._status < 101 || this._status > 199) {
            throw new Rel100Exception(0);
        }
        ListIterator<String> it = this._request.getHeaders("Supported");
        boolean supports100rel = false;
        while (it.hasNext() && !supports100rel) {
            s = (String)it.next();
            if (!s.equals("100rel")) continue;
            supports100rel = true;
        }
        if (!supports100rel) {
            it = this._request.getHeaders("Require");
            while (it.hasNext() && !supports100rel) {
                s = (String)it.next();
                if (!s.equals("100rel")) continue;
                supports100rel = true;
            }
        }
        if (!supports100rel) {
            throw new Rel100Exception(2);
        }
        try {
            this.send(true);
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
        }
    }

    @Override
    public void setCharacterEncoding(String encoding) {
        this._characterEncoding = encoding;
    }

    public void setStatus(int status) {
        this._status = status;
    }

    public void setStatus(int status, String reason) {
        if (status < 100 || status >= 700) {
            throw new IllegalArgumentException("Invalid status-code: " + status);
        }
        this._status = status;
        this._reason = reason;
    }

    public void flushBuffer() {
    }

    public int getBufferSize() {
        return 0;
    }

    public Locale getLocale() {
        return this.getContentLanguage();
    }

    public void reset() {
    }

    public void resetBuffer() {
    }

    public void setBufferSize(int size) {
    }

    public void setLocale(Locale locale) {
        this.setContentLanguage(locale);
    }

    public String getMethod() {
        return this.getCSeq().getMethod();
    }

    @Override
    public boolean isRequest() {
        return false;
    }

    @Override
    public boolean needsContact() {
        return (this.isInvite() || this.isSubscribe() || this.isNotify() || this.isRefer() || this.isUpdate()) && this.getStatus() < 300;
    }

    @Override
    protected boolean canSetContact() {
        return this.isRegister() || this.getStatus() >= 300 && this.getStatus() < 400 || this.getStatus() == 485 || this.getStatus() == 200 && this.isOptions();
    }

    public boolean is2xx() {
        return 200 <= this._status && this._status < 300;
    }

    public void setRSeq(long rseq) {
        this.getFields().setString((Buffer)SipHeaders.RSEQ_BUFFER, Long.toString(rseq));
    }

    public long getRSeq() {
        return this.getFields().getLong((Buffer)SipHeaders.RSEQ_BUFFER);
    }

    private void send(boolean reliable) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Response is commited");
        }
        SessionManager csm = this.getCallSession().getServer().getSessionManager();
        SessionManager.SessionScope scope = csm.openScope(this.getCallSession());
        try {
            this._session.sendResponse(this, (ServerTransaction)this.getTransaction(), reliable);
            this.setCommitted(true);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IllegalStateException(e.getMessage());
        }
        finally {
            scope.close();
        }
    }

    public Via removeTopVia() {
        Via via = this._fields.getVia();
        this._fields.removeFirst((Buffer)SipHeaders.VIA_BUFFER);
        return via;
    }

    public void setContact(Address contact) {
        this._fields.setAddress("Contact", (Address)((NameAddr)contact));
    }

    public boolean isReliable1xx() {
        if (this._status > 100 && this._status < 200) {
            if (this.getRSeq() == -1L) {
                return false;
            }
            ListIterator<String> it = this._fields.getValues((Buffer)SipHeaders.REQUIRE_BUFFER);
            while (it.hasNext()) {
                String val = (String)it.next();
                if (!"100rel".equalsIgnoreCase(val)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public Iterator<String> getChallengeRealms() {
        Authenticate authenticate;
        ArrayList<String> list = new ArrayList<String>();
        ListIterator<String> it = this._fields.getValues((Buffer)SipHeaders.WWW_AUTHENTICATE_BUFFER);
        while (it.hasNext()) {
            authenticate = new Authenticate(it.next());
            list.add(authenticate.getParameter(Authenticate.REALM_BUFFER));
        }
        it = this._fields.getValues((Buffer)SipHeaders.PROXY_AUTHENTICATE_BUFFER);
        while (it.hasNext()) {
            authenticate = new Authenticate(it.next());
            list.add(authenticate.getParameter(Authenticate.REALM_BUFFER));
        }
        return list.iterator();
    }

    public ProxyBranch getProxyBranch() {
        return this._proxyBranch;
    }

    public void setProxyBranch(ProxyBranch branch) {
        this._proxyBranch = branch;
    }

    public boolean isBranchResponse() {
        return this._branchResponse;
    }

    public void setBranchResponse(boolean branch) {
        this._branchResponse = branch;
    }

    @Override
    public String getRequestLine() {
        return this._status + " " + this._reason;
    }

    @Override
    public Object clone() {
        SipResponse clone = (SipResponse)super.clone();
        clone._request = null;
        clone._proxy = null;
        return clone;
    }
}

