/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.sip.Address;
import javax.servlet.sip.AuthInfo;
import javax.servlet.sip.B2buaHelper;
import javax.servlet.sip.Proxy;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.TooManyHopsException;
import javax.servlet.sip.URI;
import javax.servlet.sip.ar.SipApplicationRouterInfo;
import javax.servlet.sip.ar.SipApplicationRoutingDirective;
import javax.servlet.sip.ar.SipApplicationRoutingRegion;
import org.cipango.server.B2bHelper;
import org.cipango.server.SipMessage;
import org.cipango.server.SipProxy;
import org.cipango.server.SipResponse;
import org.cipango.server.session.SessionManager;
import org.cipango.server.transaction.ClientTransaction;
import org.cipango.server.transaction.ServerTransaction;
import org.cipango.sip.NameAddr;
import org.cipango.sip.RAck;
import org.cipango.sip.SipHeaders;
import org.cipango.sip.URIFactory;
import org.cipango.sip.Via;
import org.cipango.sip.security.AuthInfoImpl;
import org.cipango.sip.security.Authenticate;
import org.cipango.sip.security.Authorization;
import org.cipango.util.LazyMap;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SipRequest
extends SipMessage
implements SipServletRequest {
    private static final Logger LOG = Log.getLogger(SipRequest.class);
    private String _method;
    private URI _requestUri;
    private String _sRequestUri;
    private boolean _initial = false;
    private SipProxy _proxy;
    private Address _poppedRoute;
    private Address _initialPoppedRoute;
    private Serializable _stateInfo;
    private SipApplicationRouterInfo _nextRouterInfo;
    private SipApplicationRoutingDirective _directive;
    private SipApplicationRoutingRegion _region;
    private URI _subscriberURI;
    private boolean _nextHopStrictRouting = false;
    private Object _handlerAttributes;
    private SipRequest _linkedRequest;

    public SipServletRequest createCancel() throws IllegalStateException {
        if (this.getTransaction().isCompleted()) {
            throw new IllegalStateException("Transaction has completed");
        }
        SipRequest cancel = this.createRequest("CANCEL");
        cancel.to().removeParameter("tag");
        return cancel;
    }

    public SipServletResponse createResponse(int status) {
        return this.createResponse(status, null);
    }

    public SipServletResponse createResponse(int status, String reason) {
        if (this.isAck()) {
            throw new IllegalStateException("Cannot create response on ACK");
        }
        if (!(this.getTransaction() instanceof ServerTransaction)) {
            throw new IllegalStateException("Cannot create response if not in UAS mode");
        }
        if (this.getTransaction().isCompleted()) {
            throw new IllegalStateException("Cannot create response if final response has been sent");
        }
        return new SipResponse(this, status, reason);
    }

    public ServletInputStream getInputStream() {
        return null;
    }

    public int getMaxForwards() {
        return (int)this._fields.getLong((Buffer)SipHeaders.MAX_FORWARDS_BUFFER);
    }

    public Proxy getProxy() throws TooManyHopsException {
        return this.getProxy(true);
    }

    public Proxy getProxy(boolean create) throws TooManyHopsException {
        if (this._proxy != null || !create) {
            return this._proxy;
        }
        if (!this.isServer()) {
            throw new IllegalStateException("Not a received request");
        }
        this._session.setProxy();
        if (this._proxy == null) {
            this._proxy = new SipProxy(this);
            this._proxy.setProxyTimeout(this.appSession().getContext().getProxyTimeout());
        }
        return this._proxy;
    }

    public BufferedReader getReader() {
        return null;
    }

    public URI getRequestURI() {
        if (this._requestUri == null && this._sRequestUri != null) {
            try {
                this._requestUri = URIFactory.parseURI(this._sRequestUri);
                this._sRequestUri = null;
            }
            catch (ServletParseException e) {
                LOG.info("Received bad request: " + e.getMessage(), new Object[0]);
            }
        }
        return this._requestUri;
    }

    public boolean isInitial() {
        return this._initial;
    }

    public void pushRoute(SipURI route) {
        this.pushRoute(new NameAddr((URI)route));
    }

    public void pushRoute(Address route) {
        boolean strictRouting;
        if (!route.getURI().isSipURI()) {
            throw new IllegalArgumentException("Only routes with a SIP URI may be pushed");
        }
        boolean bl = strictRouting = !((SipURI)route.getURI()).getLrParam();
        if (this.isNextHopStrictRouting()) {
            if (strictRouting) {
                this._fields.addAddress((Buffer)SipHeaders.ROUTE_BUFFER, (Address)new NameAddr(this.getRequestURI()), true);
                this.setRequestURI(route.getURI());
            } else {
                Address lastRoute = this.removeLastRoute();
                this._fields.addAddress((Buffer)SipHeaders.ROUTE_BUFFER, (Address)new NameAddr(this.getRequestURI()), true);
                this.setRequestURI(lastRoute.getURI());
                this._fields.addAddress((Buffer)SipHeaders.ROUTE_BUFFER, (Address)((NameAddr)route), true);
            }
        } else if (strictRouting) {
            this._fields.addAddress((Buffer)SipHeaders.ROUTE_BUFFER, (Address)new NameAddr(this.getRequestURI()), false);
            this.setRequestURI(route.getURI());
        } else {
            this._fields.addAddress((Buffer)SipHeaders.ROUTE_BUFFER, route, true);
        }
        this.setNextHopStrinctRouting(strictRouting);
    }

    public Address getLastRoute() {
        ListIterator<Address> routes = this._fields.getAddressValues((Buffer)SipHeaders.ROUTE_BUFFER);
        Address lastRoute = null;
        while (routes.hasNext()) {
            lastRoute = routes.next();
        }
        return lastRoute;
    }

    public void setNextHopStrinctRouting(boolean nextHopStrictRouting) {
        this._nextHopStrictRouting = nextHopStrictRouting;
    }

    public boolean isNextHopStrictRouting() {
        return this._nextHopStrictRouting;
    }

    public void pushPath(Address path) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send() throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Request is already commited");
        }
        if (this.getTransaction() != null && !(this.getTransaction() instanceof ClientTransaction)) {
            throw new IllegalStateException("Can send request only in UAC mode");
        }
        this.setCommitted(true);
        SessionManager csm = this.getCallSession().getServer().getSessionManager();
        SessionManager.SessionScope scope = csm.openScope(this.getCallSession());
        try {
            if (this.isCancel()) {
                ((ClientTransaction)this.getTransaction()).cancel(this);
            } else {
                this._session.sendRequest(this);
            }
        }
        finally {
            scope.close();
        }
    }

    public void setMaxForwards(int maxForwards) {
        if (maxForwards < 0 || maxForwards > 255) {
            throw new IllegalArgumentException("Max-Forwards should be between 0 and 255");
        }
        this._fields.setString((Buffer)SipHeaders.MAX_FORWARDS_BUFFER, Long.toString(maxForwards));
    }

    public void setRequestURI(URI uri) {
        if (uri == null) {
            throw new NullPointerException("Null uri");
        }
        this._requestUri = uri;
    }

    @Override
    public boolean isRequest() {
        return true;
    }

    public String getMethod() {
        return this._method;
    }

    public Locale getLocale() {
        return this.getAcceptLanguage();
    }

    public Enumeration<Locale> getLocales() {
        final Iterator<Locale> it = this.getAcceptLanguages();
        return new Enumeration<Locale>(){

            @Override
            public boolean hasMoreElements() {
                return it.hasNext();
            }

            @Override
            public Locale nextElement() {
                return (Locale)it.next();
            }
        };
    }

    public String getLocalName() {
        return this.getConnection() != null ? this.getConnection().getLocalAddress().getHostName() : null;
    }

    public String getParameter(String name) {
        SipURI paramUri = this.getParamUri();
        if (paramUri == null) {
            return null;
        }
        return paramUri.getParameter(name);
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        SipURI paramUri = this.getParamUri();
        if (paramUri != null) {
            Iterator it = paramUri.getParameterNames();
            while (it.hasNext()) {
                String key = (String)it.next();
                map.put(key, new String[]{paramUri.getParameter(key)});
            }
        }
        return Collections.unmodifiableMap(map);
    }

    public Enumeration<String> getParameterNames() {
        SipURI paramUri = this.getParamUri();
        if (paramUri == null) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
        return new IteratorToEnum(paramUri.getParameterNames());
    }

    public String[] getParameterValues(String name) {
        String value = this.getParameter(name);
        if (value == null) {
            return null;
        }
        return new String[]{value};
    }

    public String getRealPath(String path) {
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw new UnsupportedOperationException("Not Applicable");
    }

    public String getRemoteHost() {
        return this.getRemoteAddr();
    }

    public String getScheme() {
        return this._requestUri.getScheme();
    }

    public String getServerName() {
        return this.getLocalName();
    }

    public int getServerPort() {
        return this.getLocalPort();
    }

    @Override
    public Object getAttribute(String name) {
        if ("javax.sip.request.poppedRoute".equals(name)) {
            return this.getPoppedRoute().getURI();
        }
        return super.getAttribute(name);
    }

    public SipURI getParamUri() {
        if (this._poppedRoute != null) {
            return (SipURI)this._poppedRoute.getURI();
        }
        if (this._requestUri.isSipURI()) {
            return (SipURI)this._requestUri;
        }
        return null;
    }

    public void addRecordRoute(NameAddr route) {
        this._fields.addAddress((Buffer)SipHeaders.RECORD_ROUTE_BUFFER, (Address)route, true);
    }

    public void pushVia(Via via) {
        this._fields.addVia(via, true);
    }

    protected SipProxy getProxyImpl() {
        return this._proxy;
    }

    protected void setProxyImpl(SipProxy proxy) {
        this._proxy = proxy;
    }

    public SipRequest createRequest(String method) {
        SipRequest request = new SipRequest();
        request._session = this._session;
        request._callSession = this._callSession;
        request.setTransaction(this.getTransaction());
        request._fields.setAddress("From", (Address)((NameAddr)this.getFrom().clone()));
        request._fields.setAddress("To", (Address)((NameAddr)this.getTo().clone()));
        request.setMethod(method);
        request.setRequestURI(this.getRequestURI());
        request._fields.copy(this._fields, (Buffer)SipHeaders.CALL_ID_BUFFER);
        request._fields.setString((Buffer)SipHeaders.CSEQ_BUFFER, this.getCSeq().getNumber() + " " + method);
        request._fields.addVia(this.getTopVia(), true);
        request._fields.copy(this._fields, (Buffer)SipHeaders.MAX_FORWARDS_BUFFER);
        request._fields.copy(this._fields, (Buffer)SipHeaders.ROUTE_BUFFER);
        return request;
    }

    @Override
    protected boolean canSetContact() {
        return this.isRegister();
    }

    public Address getTopRoute() {
        return this._fields.getAddress((Buffer)SipHeaders.ROUTE_BUFFER);
    }

    public boolean isServer() {
        return this.getTransaction().isServer();
    }

    @Override
    public boolean needsContact() {
        return this.isInvite() || this.isSubscribe() || this.isNotify() || this.isRefer() || this.isUpdate();
    }

    public RAck getRAck() throws ServletParseException {
        String s = this.getFields().getString((Buffer)SipHeaders.RACK_BUFFER);
        if (s == null) {
            return null;
        }
        return new RAck(s);
    }

    public Address removeTopRoute() {
        Address topRoute = this._fields.getAddress((Buffer)SipHeaders.ROUTE_BUFFER);
        this._fields.removeFirst((Buffer)SipHeaders.ROUTE_BUFFER);
        return topRoute;
    }

    public Address removeLastRoute() {
        Address route;
        Iterator<Object> it = this._fields.getAddressValues((Buffer)SipHeaders.ROUTE_BUFFER);
        ArrayList<Address> list = new ArrayList<Address>();
        Address lastRoute = null;
        while (it.hasNext()) {
            route = (Address)it.next();
            if (it.hasNext()) {
                list.add(route);
                continue;
            }
            lastRoute = route;
        }
        it = list.iterator();
        if (it.hasNext()) {
            this._fields.setAddress((Buffer)SipHeaders.ROUTE_BUFFER, (Address)((NameAddr)it.next()));
        } else {
            return this.removeTopRoute();
        }
        while (it.hasNext()) {
            route = (NameAddr)it.next();
            this._fields.addAddress((Buffer)SipHeaders.ROUTE_BUFFER, route, false);
        }
        return lastRoute;
    }

    public void setInitial(boolean b) {
        this._initial = b;
    }

    public void setMethod(String method) {
        this._method = method;
    }

    public void setPoppedRoute(Address route) {
        this._poppedRoute = route;
        if (this._initialPoppedRoute == null) {
            this._initialPoppedRoute = route;
        }
    }

    public Address getPoppedRoute() {
        return this._poppedRoute;
    }

    public void setRequestURI(Buffer buffer) {
        this._sRequestUri = buffer.toString();
    }

    public String getRequestURIAsString() {
        if (this._requestUri != null) {
            return this._requestUri.toString();
        }
        return this._sRequestUri;
    }

    public void addAuthHeader(SipServletResponse challengeResponse, AuthInfo authInfo) {
        Authorization authorization;
        AuthInfoImpl.AuthElement element;
        Authenticate authenticate;
        ListIterator authenticates = challengeResponse.getHeaders("WWW-Authenticate");
        while (authenticates.hasNext()) {
            authenticate = new Authenticate((String)authenticates.next());
            element = ((AuthInfoImpl)authInfo).getAuthElement(challengeResponse.getStatus(), authenticate.getRealm());
            authorization = new Authorization(authenticate, element.getUsername(), element.getPassword(), this.getRequestURIAsString(), this.getMethod());
            this.addHeader("Authorization", authorization.toString());
        }
        authenticates = challengeResponse.getHeaders("Proxy-Authenticate");
        while (authenticates.hasNext()) {
            authenticate = new Authenticate((String)authenticates.next());
            element = ((AuthInfoImpl)authInfo).getAuthElement(challengeResponse.getStatus(), authenticate.getRealm());
            authorization = new Authorization(authenticate, element.getUsername(), element.getPassword(), this.getRequestURIAsString(), this.getMethod());
            this.addHeader("Proxy-Authorization", authorization.toString());
        }
    }

    public void addAuthHeader(SipServletResponse challengeResponse, String username, String password) {
        Authorization authorization;
        Authenticate authenticate;
        ListIterator authenticates = challengeResponse.getHeaders("WWW-Authenticate");
        while (authenticates.hasNext()) {
            authenticate = new Authenticate((String)authenticates.next());
            authorization = new Authorization(authenticate, username, password, this.getRequestURIAsString(), this.getMethod());
            this.addHeader("Authorization", authorization.toString());
        }
        authenticates = challengeResponse.getHeaders("Proxy-Authenticate");
        while (authenticates.hasNext()) {
            authenticate = new Authenticate((String)authenticates.next());
            authorization = new Authorization(authenticate, username, password, this.getRequestURIAsString(), this.getMethod());
            this.addHeader("Proxy-Authorization", authorization.toString());
        }
    }

    public B2buaHelper getB2buaHelper() {
        if (this._proxy != null) {
            throw new IllegalStateException("getProxy() had already been called");
        }
        return B2bHelper.getInstance();
    }

    public Address getInitialPoppedRoute() {
        return this._initialPoppedRoute;
    }

    public void setInitialPoppedRoute(Address route) {
        this._initialPoppedRoute = route;
    }

    public SipApplicationRoutingRegion getRegion() {
        return this._region;
    }

    public URI getSubscriberURI() {
        if (!this.isInitial()) {
            throw new IllegalStateException("SipServletRequest is not initial");
        }
        return this._subscriberURI;
    }

    public void setRegion(SipApplicationRoutingRegion region) {
        this._region = region;
    }

    @Override
    public Object clone() {
        SipRequest clone = (SipRequest)super.clone();
        clone._region = null;
        clone._subscriberURI = null;
        clone._proxy = null;
        clone._initialPoppedRoute = null;
        clone._requestUri = this.getRequestURI().clone();
        return clone;
    }

    public void setSubscriberURI(URI uri) {
        this._subscriberURI = uri;
    }

    public SipApplicationRoutingDirective getRoutingDirective() throws IllegalStateException {
        if (!this.isInitial()) {
            throw new IllegalStateException("SipServletRequest is not initial");
        }
        return this._directive;
    }

    public void setRoutingDirective(SipApplicationRoutingDirective directive, SipServletRequest origRequest) throws IllegalStateException {
        if (!this.isInitial()) {
            throw new IllegalStateException("SipServletRequest is not initial");
        }
        if (!(directive == SipApplicationRoutingDirective.NEW || origRequest != null && origRequest.isInitial())) {
            throw new IllegalStateException("origRequest is not initial");
        }
        if (this.isCommitted()) {
            throw new IllegalStateException("SipServletRequest is committed");
        }
        this._directive = directive;
    }

    public Serializable getStateInfo() {
        return this._stateInfo;
    }

    public void setStateInfo(Serializable stateInfo) {
        this._stateInfo = stateInfo;
    }

    public SipApplicationRouterInfo peekRouterInfo() {
        return this._nextRouterInfo;
    }

    public SipApplicationRouterInfo popRouterInfo() {
        SipApplicationRouterInfo info = this._nextRouterInfo;
        this._nextRouterInfo = null;
        return info;
    }

    public void pushRouterInfo(SipApplicationRouterInfo routerInfo) {
        this._nextRouterInfo = routerInfo;
    }

    public Object getHandlerAttribute(String name) {
        return LazyMap.get(this._handlerAttributes, name);
    }

    public void addHandlerAttribute(String name, Object value) {
        this._handlerAttributes = LazyMap.add(this._handlerAttributes, name, value);
    }

    @Override
    public String getRequestLine() {
        return this._method + " " + this.getRequestURI().toString();
    }

    public SipRequest getLinkedRequest() {
        return this._linkedRequest;
    }

    public void setLinkedRequest(SipRequest request) {
        this._linkedRequest = request;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IteratorToEnum
    implements Enumeration<String> {
        private Iterator<String> _it;

        public IteratorToEnum(Iterator<String> it) {
            this._it = it;
        }

        @Override
        public boolean hasMoreElements() {
            return this._it.hasNext();
        }

        @Override
        public String nextElement() {
            return this._it.next();
        }
    }
}

