/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.servlet.sip.Address;
import javax.servlet.sip.Proxy;
import javax.servlet.sip.ProxyBranch;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.TooManyHopsException;
import javax.servlet.sip.URI;
import javax.servlet.sip.ar.SipApplicationRoutingDirective;
import org.cipango.server.ID;
import org.cipango.server.SipConnection;
import org.cipango.server.SipConnector;
import org.cipango.server.SipRequest;
import org.cipango.server.SipResponse;
import org.cipango.server.session.AppSession;
import org.cipango.server.session.CallSession;
import org.cipango.server.session.Session;
import org.cipango.server.session.SessionManager;
import org.cipango.server.transaction.ClientTransaction;
import org.cipango.server.transaction.ClientTransactionListener;
import org.cipango.server.transaction.ServerTransaction;
import org.cipango.server.transaction.ServerTransactionListener;
import org.cipango.server.transaction.Transaction;
import org.cipango.sip.NameAddr;
import org.cipango.sip.SipGrammar;
import org.cipango.util.TimerTask;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SipProxy
implements Proxy,
ServerTransactionListener,
Serializable {
    private static final Logger LOG = Log.getLogger(SipProxy.class);
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_TIMEOUT = 15;
    public static final int DEFAULT_TIMER_C = 180;
    public static int __maxForwards = 70;
    public static int __timerC = 180;
    private boolean _started;
    private boolean _parallel = true;
    private boolean _recurse = true;
    private boolean _supervised = true;
    private boolean _noCancel = false;
    private int _proxyTimeout = 15;
    private SipURI _rrUri;
    private SipURI _pathUri;
    private ServerTransaction _tx;
    private SipResponse _best;
    private int _actives;
    private Object _branches;
    private Object _targets;

    public SipProxy(SipRequest request) throws TooManyHopsException {
        this._tx = (ServerTransaction)request.getTransaction();
        this._tx.setListener(this);
        int maxForwards = request.getMaxForwards();
        if (maxForwards == 0) {
            throw new TooManyHopsException();
        }
        if (maxForwards == -1) {
            request.setMaxForwards(70);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created proxy for tx {}", new Object[]{this._tx, null});
        }
    }

    public void cancel() {
        this.cancel(null, null, null);
    }

    public void cancel(String[] protocol, int[] reasonCode, String[] reasonText) {
        if (this._tx.isCompleted()) {
            throw new IllegalStateException("Transaction has completed");
        }
        this.doCancel(protocol, reasonCode, reasonText);
    }

    protected void doCancel(String[] protocol, int[] reasonCode, String[] reasonText) {
        int i = LazyList.size((Object)this._branches);
        while (i-- > 0) {
            Branch branch = (Branch)LazyList.get((Object)this._branches, (int)i);
            branch.cancel(protocol, reasonCode, reasonText);
        }
    }

    public List<ProxyBranch> createProxyBranches(List<? extends URI> list) {
        ArrayList<ProxyBranch> branches = new ArrayList<ProxyBranch>();
        for (URI uRI : list) {
            Branch branch = this.addBranch(uRI);
            if (branch == null) continue;
            branches.add(branch);
        }
        return branches;
    }

    public boolean getAddToPath() {
        return this._pathUri != null;
    }

    public boolean getNoCancel() {
        return this._noCancel;
    }

    public SipServletRequest getOriginalRequest() {
        return this._tx.getRequest();
    }

    public boolean getParallel() {
        return this._parallel;
    }

    public SipURI getPathURI() {
        if (this._pathUri == null) {
            throw new IllegalStateException("addToPath is not enabled");
        }
        return this._pathUri;
    }

    public ProxyBranch getProxyBranch(URI uri) {
        BranchIterator it = new BranchIterator(this._branches);
        while (it.hasNext()) {
            Branch branch = (Branch)it.next();
            if (!branch.getUri().equals(uri)) continue;
            return branch;
        }
        return null;
    }

    public List<ProxyBranch> getProxyBranches() {
        return LazyList.getList((Object)this._branches);
    }

    public int getProxyTimeout() {
        return this._proxyTimeout;
    }

    public boolean getRecordRoute() {
        return this._rrUri != null;
    }

    public SipURI getRecordRouteURI() {
        if (this._rrUri == null) {
            throw new IllegalStateException("Record-Routing is not enabled");
        }
        return this._rrUri;
    }

    public boolean getRecurse() {
        return this._recurse;
    }

    public int getSequentialSearchTimeout() {
        return this.getProxyTimeout();
    }

    public boolean getStateful() {
        return true;
    }

    public boolean getSupervised() {
        return this._supervised;
    }

    public void proxyTo(List<? extends URI> targets) {
        for (URI uRI : targets) {
            if (!uRI.isSipURI() && this.getOriginalRequest().getHeader("Route") == null) {
                throw new IllegalArgumentException("Cannot route " + uRI);
            }
            this.addBranch(uRI);
        }
        this.startProxy();
    }

    public void proxyTo(URI uri) {
        if (!uri.isSipURI() && this.getOriginalRequest().getHeader("Route") == null) {
            throw new IllegalArgumentException("Cannot route " + uri);
        }
        this.addBranch(uri);
        this.startProxy();
    }

    public void setAddToPath(boolean addToPath) {
        if (!addToPath) {
            this._pathUri = null;
        } else if (this._pathUri == null) {
            this._pathUri = this.newProxyURI(false);
        }
    }

    public void setNoCancel(boolean b) {
        this._noCancel = b;
    }

    public void setOutboundInterface(InetAddress address) {
        if (address == null) {
            throw new NullPointerException("Null address");
        }
    }

    public void setOutboundInterface(InetSocketAddress address) {
        if (address == null) {
            throw new NullPointerException("Null address");
        }
    }

    public void setParallel(boolean parallel) {
        this._parallel = parallel;
    }

    public void setProxyTimeout(int seconds) {
        if (seconds <= 0) {
            throw new IllegalArgumentException("Proxy timeout too low: " + seconds);
        }
        this._proxyTimeout = seconds;
    }

    public void setRecordRoute(boolean recordRoute) {
        if (this._started) {
            throw new IllegalStateException("Proxy has already been started");
        }
        if (!recordRoute) {
            this._rrUri = null;
        } else if (this._rrUri == null) {
            this._rrUri = this.newProxyURI(true);
        }
    }

    public void setRecurse(boolean recurse) {
        this._recurse = recurse;
    }

    public void setSequentialSearchTimeout(int seconds) {
        this.setProxyTimeout(seconds);
    }

    public void setStateful(boolean b) {
    }

    public void setSupervised(boolean supervised) {
        this._supervised = supervised;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProxy() {
        this._started = true;
        if (this._tx.isCompleted()) {
            throw new IllegalStateException("Transaction has completed");
        }
        if (!this._parallel && this._actives > 0) {
            return;
        }
        CallSession callSession = this._tx.getRequest().getCallSession();
        SessionManager cm = callSession.getServer().getSessionManager();
        SessionManager.SessionScope work = cm.openScope(callSession);
        try {
            while (LazyList.size((Object)this._targets) > 0) {
                Branch branch = (Branch)LazyList.get((Object)this._targets, (int)0);
                this._targets = LazyList.remove((Object)this._targets, (int)0);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxying to {} ", new Object[]{branch.getUri(), null});
                }
                branch.start();
                if (this._parallel) continue;
                break;
            }
        }
        finally {
            work.close();
        }
    }

    private SipURI newProxyURI(boolean applicationId) {
        return this.newProxyURI(this._tx.getRequest().getConnection().getConnector(), applicationId);
    }

    private SipURI newProxyURI(SipConnector connector, boolean applicationId) {
        SipURI rrUri = (SipURI)connector.getSipUri().clone();
        rrUri.setParameter("lr", "");
        if (applicationId) {
            AppSession appSession = this._tx.getRequest().appSession();
            rrUri.setParameter("app-session-id", appSession.getAppId());
        }
        return rrUri;
    }

    private boolean isInTargetSet(URI uri) {
        if (this._branches == null) {
            return false;
        }
        BranchIterator it = new BranchIterator(this._branches);
        while (it.hasNext()) {
            if (!((Branch)it.next()).getUri().equals(uri)) continue;
            return true;
        }
        return false;
    }

    protected Branch addTarget(URI uri) {
        URI target = uri.clone();
        if (target.isSipURI()) {
            SipURI sipUri = (SipURI)target;
            sipUri.removeParameter("method");
            Iterator it = sipUri.getHeaderNames();
            while (it.hasNext()) {
                it.remove();
            }
        }
        if (this.isInTargetSet(target)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("target {} is already in target set", new Object[]{target});
            }
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("adding target {} to target set", new Object[]{target});
        }
        Branch branch = new Branch(target);
        this._targets = LazyList.add((Object)this._targets, (Object)branch);
        return branch;
    }

    protected Branch addBranch(URI uri) {
        if (this._tx.isCompleted()) {
            throw new IllegalStateException("transaction completed");
        }
        Branch branch = this.addTarget(uri);
        if (branch != null) {
            branch.setRecurse(this.getRecurse());
            branch.setRecordRoute(this.getRecordRoute());
            branch.setAddToPath(this.getAddToPath());
            branch.setProxyBranchTimeout(this.getProxyTimeout());
            this._branches = LazyList.add((Object)this._branches, (Object)branch);
        }
        return branch;
    }

    @Override
    public void handleCancel(ServerTransaction tx, SipRequest cancel) {
        cancel.setSession(this._tx.getRequest().session());
        this.cancel();
        try {
            cancel.session().invokeServlet(cancel);
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
        }
    }

    @Override
    public void transactionTerminated(Transaction transaction) {
    }

    private void tryFinal() {
        assert (this._actives == 0);
        if (LOG.isDebugEnabled()) {
            LOG.debug("tryFinal, branches: {}, untried: {}", new Object[]{this._branches, this._targets});
        }
        if (this._best == null) {
            this._best = (SipResponse)this.getOriginalRequest().createResponse(408);
            this._best.setToTag(ID.newTag());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("final response is {}", new Object[]{this._best, null});
        }
        this._best.setBranchResponse(false);
        this.invokeServlet(this._best);
        if (this._actives > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("new branch(es) created in callback {}", new Object[]{this._branches, null});
            }
            return;
        }
        this.forward(this._best);
    }

    private void invokeServlet(SipResponse response) {
        if (this._supervised) {
            response.session().invokeServlet(response);
        }
    }

    private void forward(SipResponse response) {
        if (response.getStatus() >= 300) {
            response.session().updateState(response, false);
        }
        this._tx.send(response);
        response.setCommitted(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BranchIterator
    implements Iterator<Branch> {
        private Iterator<Branch> _it;
        private Object _branches;
        private Branch _next;
        private int _index;

        public BranchIterator(Object branches) {
            this._branches = branches;
            this._index = 0;
        }

        @Override
        public boolean hasNext() {
            if (this._next == null) {
                if (this._it != null && this._it.hasNext()) {
                    this._next = this._it.next();
                } else if (this._index < LazyList.size((Object)this._branches)) {
                    Branch branch;
                    this._next = branch = (Branch)LazyList.get((Object)this._branches, (int)this._index++);
                    if (LazyList.size((Object)branch._recursedBranches) > 0) {
                        this._it = new BranchIterator(branch._recursedBranches);
                    }
                }
            }
            return this._next != null;
        }

        @Override
        public Branch next() {
            if (this.hasNext()) {
                Branch next = this._next;
                this._next = null;
                return next;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Branch
    implements ProxyBranch,
    ClientTransactionListener,
    Serializable {
        private static final long serialVersionUID = 1L;
        private URI _uri;
        private SipRequest _request;
        private SipResponse _response;
        private ClientTransaction _ctx;
        private boolean _provisional = false;
        private TimerTask _timerC;
        private boolean _branchRecurse;
        private SipURI _branchPathUri;
        private SipURI _branchRRUri;
        private int _branchTimeout;
        private Object _recursedBranches;

        public Branch(URI uri) {
            this._uri = uri;
            this._request = (SipRequest)((SipRequest)SipProxy.this.getOriginalRequest()).clone();
            this._request.setProxyImpl(((SipRequest)SipProxy.this.getOriginalRequest()).getProxyImpl());
            if (SipProxy.this.getOriginalRequest().isInitial()) {
                this._request.setRoutingDirective(SipApplicationRoutingDirective.CONTINUE, SipProxy.this.getOriginalRequest());
            }
        }

        public void cancel() {
            this.cancel(null, null, null);
        }

        public void cancel(String[] protocol, int[] reasonCode, String[] reasonText) {
            if (!this._ctx.isCompleted()) {
                this.stopTimerC();
                SipRequest cancel = (SipRequest)this._ctx.getRequest().createCancel();
                if (protocol != null) {
                    for (int i = 0; i < protocol.length; ++i) {
                        String reason = protocol[i] + ";cause=" + reasonCode[i] + ";reason=\"" + SipGrammar.escapeQuoted(reasonText[i]) + "\"";
                        cancel.addHeader("Reason", reason);
                    }
                }
                this._ctx.cancel(cancel);
            }
            int i = LazyList.size((Object)this._recursedBranches);
            while (i-- > 0) {
                ((Branch)LazyList.get((Object)this._recursedBranches, (int)i)).cancel(protocol, reasonCode, reasonText);
            }
        }

        public boolean getAddToPath() {
            return this._branchPathUri != null;
        }

        public SipURI getPathURI() {
            return this._branchPathUri;
        }

        public Proxy getProxy() {
            return SipProxy.this;
        }

        public int getProxyBranchTimeout() {
            return this._branchTimeout;
        }

        public boolean getRecordRoute() {
            return this._branchRRUri != null;
        }

        public SipURI getRecordRouteURI() {
            if (this._branchRRUri == null) {
                throw new IllegalStateException("Record-Routing is not enabled");
            }
            return this._branchRRUri;
        }

        public boolean getRecurse() {
            return this._branchRecurse;
        }

        public List<ProxyBranch> getRecursedProxyBranches() {
            return LazyList.getList((Object)this._recursedBranches);
        }

        public SipServletRequest getRequest() {
            return this._request;
        }

        public SipServletResponse getResponse() {
            return this._response;
        }

        public boolean isStarted() {
            return this._ctx != null;
        }

        public void setAddToPath(boolean b) {
            if (!b) {
                this._branchPathUri = null;
            } else if (this._branchPathUri == null) {
                this._branchPathUri = (SipURI)(SipProxy.this._pathUri != null ? SipProxy.this._pathUri.clone() : SipProxy.this.newProxyURI(false));
            }
        }

        public void setOutboundInterface(InetAddress address) {
            if (!SipProxy.this._tx.getRequest().session().isValid()) {
                throw new IllegalStateException("Session not valid");
            }
            if (address == null) {
                throw new NullPointerException("Null address");
            }
        }

        public void setOutboundInterface(InetSocketAddress address) {
            if (!SipProxy.this._tx.getRequest().session().isValid()) {
                throw new IllegalStateException("Session not valid");
            }
            if (address == null) {
                throw new NullPointerException("Null address");
            }
        }

        public void setProxyBranchTimeout(int seconds) {
            if (seconds <= 0 || seconds > SipProxy.this._proxyTimeout) {
                throw new IllegalArgumentException("Invalid branch timeout: " + seconds);
            }
            this._branchTimeout = seconds;
        }

        public void setRecordRoute(boolean b) {
            if (this.isStarted()) {
                throw new IllegalStateException("Proxy branch is started");
            }
            if (!b) {
                this._branchRRUri = null;
            } else if (this._branchRRUri == null) {
                this._branchRRUri = (SipURI)(SipProxy.this._rrUri != null ? SipProxy.this._rrUri.clone() : SipProxy.this.newProxyURI(true));
            }
        }

        public void setRecurse(boolean recurse) {
            this._branchRecurse = recurse;
        }

        public URI getUri() {
            return this._uri;
        }

        protected void start() {
            int mf = this._request.getMaxForwards();
            mf = mf == -1 ? __maxForwards : --mf;
            this._request.setMaxForwards(mf);
            this._request.setRequestURI(this._uri);
            if (this._branchRRUri != null) {
                this._request.addRecordRoute(new NameAddr((URI)this._branchRRUri));
            }
            if (this._branchPathUri != null && this._request.isRegister()) {
                this._request.addAddressHeader("Path", new NameAddr((URI)this._branchPathUri), true);
            }
            try {
                this._ctx = this._request.session().sendRequest(this._request, this);
                if (this._request.isInvite()) {
                    this.startTimerC();
                }
                SipProxy.this._actives++;
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
            }
        }

        public void startTimerC() {
            this._timerC = SipProxy.this._tx.getCallSession().schedule(new TimeoutC(this), __timerC * 1000);
        }

        public void updateTimerC() {
            if (this._timerC == null) {
                return;
            }
            this._provisional = true;
            SipProxy.this._tx.getCallSession().cancel(this._timerC);
            this._timerC = SipProxy.this._tx.getCallSession().schedule(new TimeoutC(this), __timerC * 1000);
        }

        public void stopTimerC() {
            SipProxy.this._tx.getCallSession().cancel(this._timerC);
            this._timerC = null;
        }

        public void timeoutTimerC() {
            this._timerC = null;
            LOG.debug("Timer C timed out for branch {}", new Object[]{this._ctx.getBranch(), null});
            if (this._provisional) {
                this.cancel();
            } else {
                SipResponse timeout = this._ctx.create408();
                this.handleResponse(timeout);
            }
        }

        @Override
        public void handleResponse(SipResponse response) {
            this._response = response;
            int status = response.getStatus();
            if (status == 100) {
                return;
            }
            if (SipProxy.this._tx.isCompleted() && !response.is2xx()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Dropping response " + response.getStatus() + " since proxy is completed", new Object[0]);
                }
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got response {}", new Object[]{response, null});
            }
            SipRequest request = SipProxy.this._tx.getRequest();
            Session session = request.session();
            if (request.isInitial() && status < 300 && !session.isSameDialog(response)) {
                AppSession appSession = session.appSession();
                Session derived = appSession.getSession(response);
                if (derived == null) {
                    derived = appSession.createDerivedSession(session);
                }
                session = derived;
            }
            response.setSession(session);
            if (status < 300) {
                session.updateState(response, false);
            }
            response.removeTopVia();
            response.setProxyBranch(this);
            if (status < 200) {
                if (response.isInvite()) {
                    this.updateTimerC();
                }
                SipProxy.this.invokeServlet(response);
                SipProxy.this.forward(response);
            } else {
                SipProxy.this._actives--;
                this.stopTimerC();
                if (300 <= status && status < 400 && this._branchRecurse) {
                    try {
                        ListIterator<Address> it = response.getAddressHeaders("Contact");
                        while (it.hasNext()) {
                            Branch branch;
                            Address contact = (Address)it.next();
                            if (!contact.getURI().isSipURI() || (branch = SipProxy.this.addTarget(contact.getURI())) == null) continue;
                            this._recursedBranches = LazyList.add((Object)this._recursedBranches, (Object)branch);
                            branch.setRecurse(this._branchRecurse);
                        }
                    }
                    catch (ServletParseException e) {
                        LOG.ignore((Throwable)e);
                    }
                }
                if (SipProxy.this._best == null || SipProxy.this._best.getStatus() < 600 && (status < SipProxy.this._best.getStatus() || status >= 600)) {
                    SipProxy.this._best = response;
                }
                if (status >= 600) {
                    SipProxy.this.doCancel(null, null, null);
                }
                if (status < 300) {
                    SipProxy.this.invokeServlet(response);
                    SipProxy.this.forward(response);
                    SipProxy.this.doCancel(null, null, null);
                } else {
                    if (LazyList.size((Object)SipProxy.this._targets) > 0) {
                        SipProxy.this.startProxy();
                    }
                    if (SipProxy.this._actives > 0) {
                        response.setBranchResponse(true);
                        SipProxy.this.invokeServlet(response);
                    } else {
                        SipProxy.this.tryFinal();
                    }
                }
            }
        }

        @Override
        public void transactionTerminated(Transaction transaction) {
        }

        @Override
        public void customizeRequest(SipRequest request, SipConnection connection) {
            SipConnector connector = SipProxy.this._tx.getRequest().getConnection().getConnector();
            if (this.getRecordRoute() && connection.getConnector() != connector) {
                SipURI rrUri = SipProxy.this.newProxyURI(connection.getConnector(), true);
                rrUri.setParameter("drr", "2");
                this._branchRRUri.setParameter("drr", "");
                if (connector.getTransportOrdinal() == 2) {
                    this._branchRRUri.setTransportParam("tcp");
                }
                if (connection.getConnector().getTransportOrdinal() == 2) {
                    rrUri.setTransportParam("tcp");
                }
                request.addRecordRoute(new NameAddr((URI)rrUri));
            }
        }
    }

    class TimeoutC
    implements Runnable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Branch _branch;

        public TimeoutC(Branch branch) {
            this._branch = branch;
        }

        public void run() {
            this._branch.timeoutTimerC();
        }
    }
}

